/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.page;

import com.bimface.page.Page;

public class PageHtmlDisplay {
    public String display(Page page) {
        StringBuilder sb = new StringBuilder();
        sb.append("<div>\u5171<span>" + page.getTotalCount() + "</span>\u6761</div>");
        if (page.getTotalCount() <= 0) {
            return sb.toString();
        }
        int start = Math.max(page.getPageNo() - 4, 1);
        if (page.getTotalPages() - 6 > 1) {
            start = Math.min(start, page.getTotalPages() - 6);
        }
        int end = Math.min(page.getTotalPages(), start + 6);
        sb.append("<ul>");
        sb.append("<li><a data-no='" + page.getPrePage() + "'>\u4e0a\u9875</a></li>");
        if (start > 1) {
            sb.append("<li><a data-no='1'>1</a></li>");
        }
        for (int i = start; i <= end; ++i) {
            if (start > 2 && i == start) {
                sb.append("<li>...</li>");
            }
            if (i == page.getPageNo()) {
                sb.append("<li><span>" + i + "</span></li>");
            } else {
                sb.append("<li><a data-no='" + i + "'>" + i + "</a></li>");
            }
            if (end >= page.getTotalPages() - 1 || i != end) continue;
            sb.append("<li>...</li>");
        }
        if (page.getTotalPages() > end) {
            sb.append("<li><a data-no='" + page.getTotalPages() + "'>" + page.getTotalPages() + "</a></li>");
        }
        sb.append("<li><a data-no='" + page.getNextPage() + "'>\u4e0b\u9875</a></li>");
        sb.append("</ul>");
        if (page.getTotalPages() > 10) {
            sb.append("<div>\u8f6c\u5230\u7b2c <input type='text' value='" + page.getPageNo() + "' /> \u9875 ");
            sb.append("<input type='button' value='\u786e\u5b9a' /></div>");
        }
        return sb.toString();
    }
}

