/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.page;

import com.bimface.page.PageHtmlDisplay;
import java.io.Serializable;

public class Page
implements Serializable {
    private static final long serialVersionUID = 537084264161935450L;
    private static final int DEFAULT_PAGE_SIZE = 20;
    private int pageNo = 1;
    private int pageSize = 20;
    private int totalCount = 0;

    public Page() {
    }

    public Page(int pageNo) {
        this.pageNo = pageNo;
    }

    public Page(int pageNo, int pageSize) {
        if (pageNo > 0) {
            this.pageNo = pageNo;
        }
        if (pageSize > 0) {
            this.pageSize = pageSize;
        }
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
        if (pageNo < 1) {
            this.pageNo = 1;
        }
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getStartIndex() {
        return (this.pageNo - 1) * this.pageSize;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
        int totalPages = this.getTotalPages();
        if (this.pageNo > totalPages) {
            this.setPageNo(totalPages);
        }
    }

    public int getTotalPages() {
        if (this.totalCount <= 0) {
            return 0;
        }
        int totalPages = this.totalCount / this.pageSize;
        if (this.totalCount % this.pageSize > 0) {
            ++totalPages;
        }
        return totalPages;
    }

    public boolean hasNext() {
        return this.pageNo + 1 <= this.getTotalPages();
    }

    public int getNextPage() {
        if (this.hasNext()) {
            return this.pageNo + 1;
        }
        return this.pageNo;
    }

    public boolean hasPre() {
        return this.pageNo - 1 >= 1;
    }

    public int getPrePage() {
        if (this.hasPre()) {
            return this.pageNo - 1;
        }
        return this.pageNo;
    }

    public String getHtmlDisplay() {
        return new PageHtmlDisplay().display(this);
    }

    public String htmlDisplay() {
        return this.getHtmlDisplay();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.pageNo;
        result = 31 * result + this.pageSize;
        result = 31 * result + this.totalCount;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Page other = (Page)obj;
        if (this.pageNo != other.pageNo) {
            return false;
        }
        if (this.pageSize != other.pageSize) {
            return false;
        }
        return this.totalCount == other.totalCount;
    }

    public String toString() {
        return "Page [pageNo=" + this.pageNo + ", pageSize=" + this.pageSize + ", totalCount=" + this.totalCount + "]";
    }
}

