/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.message.mns;

import com.aliyun.mns.client.CloudAccount;
import com.aliyun.mns.client.CloudQueue;
import com.aliyun.mns.client.MNSClient;
import com.aliyun.mns.common.ClientException;
import com.aliyun.mns.common.ServiceException;
import com.aliyun.mns.model.QueueMeta;
import com.bimface.message.QueueService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MnsQueueServiceImpl
implements QueueService {
    private static final Logger logger = LoggerFactory.getLogger(MnsQueueServiceImpl.class);
    private CloudAccount cloudAccount;
    private MNSClient client;

    public void init() {
        this.client = this.cloudAccount.getMNSClient();
    }

    @Override
    public CloudQueue createQueue(String queueName) {
        QueueMeta meta = new QueueMeta();
        meta.setQueueName(queueName);
        meta.setPollingWaitSeconds(Integer.valueOf(10));
        CloudQueue cloudQueue = null;
        try {
            cloudQueue = this.client.createQueue(meta);
        }
        catch (ClientException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (ServiceException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return cloudQueue;
    }

    @Override
    public Boolean isQueueExist(String queueName) {
        QueueMeta queueMeta = null;
        try {
            queueMeta = this.client.getQueueRef(queueName).getAttributes();
        }
        catch (ClientException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return queueMeta != null;
    }

    public void setCloudAccount(CloudAccount cloudAccount) {
        this.cloudAccount = cloudAccount;
    }
}

