/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.message.mns;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.mns.client.CloudAccount;
import com.aliyun.mns.client.CloudQueue;
import com.aliyun.mns.client.MNSClient;
import com.aliyun.mns.model.Message;
import com.bimface.message.MessageListenerAware;
import com.bimface.message.MessageService;
import com.bimface.message.QueueMessage;
import com.bimface.message.QueueService;
import com.bimface.message.exception.MessageException;
import com.bimface.message.exception.MessageHandleException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MnsMessageServiceImpl
implements MessageService {
    private static final Logger logger = LoggerFactory.getLogger(MnsMessageServiceImpl.class);
    private Set<String> existQueues = new ConcurrentSkipListSet<String>();
    private CloudAccount cloudAccount;
    private QueueService queueService;
    private MNSClient client;

    public void init() {
        this.client = this.cloudAccount.getMNSClient();
    }

    @Override
    public void send(String queueName, String messageId, Object object, Integer priority) throws MessageException {
        String objectJson = JSONObject.toJSONString((Object)object);
        Message message = new Message();
        message.setMessageBody(objectJson);
        if (priority != null) {
            message.setPriority(priority.intValue());
        }
        Message putMessage = null;
        CloudQueue queue = this.initQueue(queueName);
        try {
            putMessage = queue.putMessage(message);
        }
        catch (Exception e) {
            throw new MessageException(e);
        }
        if (putMessage == null || putMessage.getMessageId() == null) {
            throw new MessageException("Message sended failed.");
        }
        logger.info(MessageFormat.format("Message sended, object = {0}, message id = {1}", objectJson, putMessage.getMessageId()));
    }

    @Override
    public void receiveAndHandle(List<String> queueNames, MessageListenerAware listener, Map<String, Integer> queueMessageHandleTimeout) throws MessageException {
        if (queueNames == null || queueNames.size() <= 0) {
            return;
        }
        Message message = null;
        CloudQueue queue = null;
        String receiptHandle = null;
        for (String queueName : queueNames) {
            queue = this.initQueue(queueName);
            try {
                message = queue.popMessage();
            }
            catch (Exception e) {
                throw new MessageException(e);
            }
            if (message == null) continue;
            receiptHandle = message.getReceiptHandle();
            boolean isVisibilityTimeoutChanged = false;
            Integer messageHandleTimeout = this.getMessageHandleTimeout(queueName, queueMessageHandleTimeout);
            if (messageHandleTimeout != null && messageHandleTimeout > 0) {
                try {
                    receiptHandle = queue.changeMessageVisibilityTimeout(receiptHandle, messageHandleTimeout.intValue());
                    isVisibilityTimeoutChanged = true;
                }
                catch (Exception e) {
                    throw new MessageException(e);
                }
            }
            QueueMessage queueMessage = new QueueMessage();
            queueMessage.setMessageId(message.getMessageId());
            queueMessage.setMessageBody(message.getMessageBody());
            queueMessage.setPriority(message.getPriority());
            try {
                listener.onMessage(queueMessage);
                queue.deleteMessage(receiptHandle);
            }
            catch (MessageHandleException e) {
                if (!isVisibilityTimeoutChanged) continue;
                Long queueVisibilityTimeout = queue.getAttributes().getVisibilityTimeout();
                try {
                    queue.changeMessageVisibilityTimeout(receiptHandle, queueVisibilityTimeout.intValue());
                }
                catch (Exception e1) {
                    throw new MessageException(e1);
                }
            }
            catch (Exception e) {
                throw new MessageException(e);
            }
        }
    }

    private Integer getMessageHandleTimeout(String queueName, Map<String, Integer> queueMessageHandleTimeout) {
        if (queueMessageHandleTimeout == null) {
            return null;
        }
        return queueMessageHandleTimeout.get(queueName);
    }

    private CloudQueue initQueue(String queueName) {
        if (!this.existQueues.contains(queueName)) {
            if (!this.queueService.isQueueExist(queueName).booleanValue()) {
                this.queueService.createQueue(queueName);
            }
            this.existQueues.add(queueName);
        }
        return this.client.getQueueRef(queueName);
    }

    public void setCloudAccount(CloudAccount cloudAccount) {
        this.cloudAccount = cloudAccount;
    }

    public void setQueueService(QueueService queueService) {
        this.queueService = queueService;
    }

    @Override
    public void changePriority(String queueName, String messageId, Integer priority) {
    }

    @Override
    public void processOvertimeMessage(String queueName, long delay) {
    }

    @Override
    public void unhideMessage(String queueName, int priority, String messageId) {
    }

    @Override
    public void deleteHideMessage(String queueName, String messageId) {
    }

    @Override
    public void deleteMessage(String queueName, String messageId, Integer priority) {
    }
}

