/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.message;

import com.bimface.message.MessageListenerAware;
import com.bimface.message.MessageService;
import com.bimface.message.exception.MessageException;
import java.util.List;
import java.util.Map;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageConsumer
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(MessageConsumer.class);
    private volatile boolean running = true;
    private List<String> queueNames;
    private final MessageListenerAware listener;
    private final MessageService messagingService;
    private Map<String, Integer> queueMessageHandleTimeout;

    public MessageConsumer(MessageService messagingService, MessageListenerAware listener, List<String> queueNames, Map<String, Integer> queueMessageHandleTimeout) {
        this.messagingService = messagingService;
        this.listener = listener;
        this.queueNames = queueNames;
        this.queueMessageHandleTimeout = queueMessageHandleTimeout;
    }

    public void setQueueNames(List<String> queueNames) {
        this.queueNames = queueNames;
    }

    public void setQueueMessageHandleTimeout(Map<String, Integer> queueMessageHandleTimeout) {
        this.queueMessageHandleTimeout = queueMessageHandleTimeout;
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                this.messagingService.receiveAndHandle(this.queueNames, this.listener, this.queueMessageHandleTimeout);
            }
            catch (MessageException e) {
                logger.error("Receive message failed.", (Throwable)e);
            }
            catch (Throwable e) {
                logger.error("Receive message failed.", e);
            }
        }
    }

    public void stop() {
        this.running = false;
    }

    @PreDestroy
    public void shutdown() {
        this.running = false;
        Thread.currentThread().interrupt();
    }
}

