/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.message;

import com.bimface.message.MessageConsumer;
import com.bimface.message.MessageListenerAware;
import com.bimface.message.MessageService;
import java.util.List;
import java.util.Map;

public class ConsumerListenerContainer {
    private Integer threadSize;
    private List<String> queueNames;
    private Map<String, Integer> queueMessageHandleTimeout;
    private MessageListenerAware listener;
    private MessageService messageService;
    private MessageConsumer consumer;

    public void launch() {
        this.consumer = new MessageConsumer(this.messageService, this.listener, this.queueNames, this.queueMessageHandleTimeout);
        for (int i = 0; i < this.getThreadSize(); ++i) {
            new Thread(this.consumer).start();
        }
    }

    public void stop() {
        this.consumer.stop();
    }

    private Integer getThreadSize() {
        if (this.threadSize == null || this.threadSize <= 0) {
            this.threadSize = 1;
        }
        return this.threadSize;
    }

    public void setThreadSize(Integer threadSize) {
        this.threadSize = threadSize;
    }

    public void setQueueNames(List<String> queueNames) {
        this.queueNames = queueNames;
        if (this.consumer != null) {
            this.consumer.setQueueNames(queueNames);
        }
    }

    public void setQueueMessageHandleTimeout(Map<String, Integer> queueMessageHandleTimeout) {
        this.queueMessageHandleTimeout = queueMessageHandleTimeout;
        if (this.consumer != null) {
            this.consumer.setQueueMessageHandleTimeout(queueMessageHandleTimeout);
        }
    }

    public void setListener(MessageListenerAware listener) {
        this.listener = listener;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }
}

