/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.lock;

import com.bimface.lock.Lock;
import com.bimface.lock.LockName;
import com.bimface.lock.LockStrategy;
import java.lang.annotation.Annotation;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Aspect
@Order(value=1)
public class LockAspect {
    private final Logger logger = LoggerFactory.getLogger(LockAspect.class);
    private final String LOCK_PREFIX = "bimface:lock:";
    private final long RETRY_LOCK_INTERVAL_IN_MILLS = 500L;
    private final String DEFAULT_LOCK_NAME = "";
    @Autowired
    private RedisTemplate<String, String> redisStringTemplate;
    private RedisSerializer<String> serializer = new StringRedisSerializer();

    public void setRedisStringTemplate(RedisTemplate<String, String> redisStringTemplate) {
        this.redisStringTemplate = redisStringTemplate;
    }

    @Around(value="@annotation(lock)")
    public Object lock(ProceedingJoinPoint joinPoint, Lock lock) throws Throwable {
        this.logger.debug("enter in lock aspect");
        String lockName = lock.name();
        if ("".equals(lockName)) {
            lockName = this.getLockNameFromParameter(joinPoint);
        }
        if ("".equals(lockName)) {
            lockName = joinPoint.getSignature().toLongString();
        }
        if (!this.isNeedLock(joinPoint, lock)) {
            return joinPoint.proceed();
        }
        if (lock.waitTime() <= 0L) {
            return this.noWaitLock(joinPoint, lock, lockName);
        }
        return this.waitLock(joinPoint, lock, lockName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object noWaitLock(ProceedingJoinPoint joinPoint, Lock lock, String lockName) throws Throwable {
        boolean locked = this.tryLocking(lockName, lock);
        if (locked) {
            try {
                Object object = joinPoint.proceed();
                return object;
            }
            finally {
                if (lock.unLockAfterDone()) {
                    this.unlock(lockName);
                }
            }
        }
        this.logger.warn("skip this invoking because of failure to get lock");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object waitLock(ProceedingJoinPoint joinPoint, Lock lock, String lockName) throws Throwable {
        long start;
        long current = start = System.currentTimeMillis();
        Expiration expiration = Expiration.from((long)lock.waitTime(), (TimeUnit)lock.timeUnit());
        long duration = expiration.getExpirationTimeInMilliseconds();
        while (current - start <= duration) {
            boolean locked = this.tryLocking(lockName, lock);
            if (locked) {
                this.logger.debug("got lock, lock name: {}", (Object)lockName);
                try {
                    Object object = joinPoint.proceed();
                    return object;
                }
                finally {
                    if (lock.unLockAfterDone()) {
                        this.unlock(lockName);
                        this.logger.debug("released lock, lock name: {}", (Object)lockName);
                    }
                }
            }
            Thread.sleep(500L);
            current = System.currentTimeMillis();
            this.logger.debug("not got lock this time, try again, lock name: {}", (Object)lockName);
        }
        this.logger.warn("not got lock, wait time out, lock name: {}", (Object)lockName);
        this.logger.warn("skip this invoking because of wait time out, waitTime:{},  timeUnit:{}", (Object)lock.waitTime(), (Object)lock.timeUnit());
        return null;
    }

    private String getLockNameFromParameter(ProceedingJoinPoint joinPoint) {
        Object param = this.getParameter(joinPoint);
        if (param == null) {
            return "";
        }
        return param.toString();
    }

    boolean isNeedLock(ProceedingJoinPoint joinPoint, Lock lock) {
        Object param = this.getParameter(joinPoint);
        return param != null || this.getParamIndex(joinPoint) < 0 || lock.lockStrategyWhenParameterIsNull() != LockStrategy.NO_LOCK;
    }

    private Object getParameter(ProceedingJoinPoint joinPoint) {
        Object[] args = joinPoint.getArgs();
        int paramIndex = this.getParamIndex(joinPoint);
        if (paramIndex > -1) {
            return args[paramIndex];
        }
        return null;
    }

    private int getParamIndex(ProceedingJoinPoint joinPoint) {
        Annotation[][] paramAnnotations = ((MethodSignature)joinPoint.getSignature()).getMethod().getParameterAnnotations();
        int paramIndex = -1;
        block0: for (int i = 0; i < paramAnnotations.length; ++i) {
            for (int j = 0; j < paramAnnotations[i].length; ++j) {
                if (!(paramAnnotations[i][j] instanceof LockName)) continue;
                paramIndex = i;
                continue block0;
            }
        }
        return paramIndex;
    }

    private boolean tryLocking(String lockName, Lock lock) {
        String lockKey = "bimface:lock:" + lockName;
        return (Boolean)this.redisStringTemplate.execute(connection -> {
            String uuid = UUID.randomUUID().toString();
            byte[] key = this.serializer.serialize((Object)lockKey);
            connection.set(key, this.serializer.serialize((Object)uuid), Expiration.from((long)lock.leaseTime(), (TimeUnit)lock.timeUnit()), RedisStringCommands.SetOption.SET_IF_ABSENT);
            byte[] value = connection.get(key);
            return uuid.equals(this.serializer.deserialize(value));
        });
    }

    private void unlock(String lockName) {
        String lockKey = "bimface:lock:" + lockName;
        this.redisStringTemplate.delete((Object)lockKey);
    }
}

