/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.http;

import com.alibaba.fastjson.JSONObject;
import com.bimface.exception.BimfaceException;
import com.bimface.exception.BimfaceRuntimeException;
import com.bimface.http.HttpConfig;
import com.bimface.http.HttpFormEncoding;
import com.bimface.http.HttpHeader;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.ConnectionPool;
import com.squareup.okhttp.Dispatcher;
import com.squareup.okhttp.FormEncodingBuilder;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import okio.BufferedSink;
import org.apache.commons.codec.binary.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(ExtHttpClient.class);
    private static final MediaType MEDIA_TYPE_JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static final String STREAM_MIME = "application/octet-stream";
    public static final int BLOCK_SIZE = 0x400000;
    private static final int PUT_THRESHOLD = 0x400000;
    private OkHttpClient okHttpClient;
    private ScheduledExecutorService scheduledThreadPool = Executors.newScheduledThreadPool(1);
    public RequestBody emptyRequestBody = RequestBody.create((MediaType)MEDIA_TYPE_JSON, (String)"");

    public ExtHttpClient() {
        this(new HttpConfig());
    }

    public ExtHttpClient(HttpConfig config) {
        Dispatcher dispatcher = new Dispatcher();
        dispatcher.setMaxRequests(config.getMaxRequests());
        dispatcher.setMaxRequestsPerHost(config.getMaxRequestsPerHost());
        ConnectionPool connectionPool = new ConnectionPool(config.getMaxIdleConnections(), config.getKeepAliveDurationNs());
        this.okHttpClient = new OkHttpClient();
        this.okHttpClient.setDispatcher(dispatcher);
        this.okHttpClient.setConnectionPool(connectionPool);
        this.okHttpClient.networkInterceptors().add(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request request = chain.request();
                Response response = chain.proceed(request);
                return response;
            }
        });
        this.okHttpClient.setConnectTimeout((long)config.getConnectTimeout(), TimeUnit.SECONDS);
        this.okHttpClient.setReadTimeout((long)config.getReadTimeout(), TimeUnit.SECONDS);
        this.okHttpClient.setWriteTimeout((long)config.getWriteTimeout(), TimeUnit.SECONDS);
    }

    public Response get(String url) {
        return this.get(url, new HttpHeader());
    }

    public Response get(String url, HttpHeader headers) {
        try {
            Request.Builder requestBuilder = new Request.Builder().get().url(url);
            return this.send(requestBuilder, Headers.of(headers.getHeaders()));
        }
        catch (BimfaceException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BimfaceRuntimeException("system.error", "The system is in preparation. Please try again later.");
        }
    }

    public Response post(String url, HttpHeader headers) {
        return this.post(url, this.emptyRequestBody, headers);
    }

    public Response post(String url, byte[] body, HttpHeader headers) {
        return this.post(url, body, headers, STREAM_MIME);
    }

    public Response post(String url, String body, HttpHeader headers) {
        return this.post(url, StringUtils.getBytesUtf8((String)body), headers, STREAM_MIME);
    }

    public Response post(String url, HttpFormEncoding params, HttpHeader headers) {
        FormEncodingBuilder f = new FormEncodingBuilder();
        for (String key : params.getParams().keySet()) {
            f.add(key, params.getParams().get(key));
        }
        return this.post(url, f.build(), headers);
    }

    public Response post(String url, byte[] body, HttpHeader headers, String contentType) {
        RequestBody rbody;
        if (body != null && body.length > 0) {
            MediaType t = MediaType.parse((String)contentType);
            rbody = RequestBody.create((MediaType)t, (byte[])body);
        } else {
            rbody = RequestBody.create(null, (byte[])new byte[0]);
        }
        return this.post(url, rbody, headers);
    }

    public Response post(String url, byte[] body, int offset, int size, HttpHeader headers, String contentType) {
        RequestBody rbody;
        if (body != null && body.length > 0) {
            MediaType t = MediaType.parse((String)contentType);
            rbody = ExtHttpClient.requestIO(t, body, offset, size);
        } else {
            rbody = RequestBody.create(null, (byte[])new byte[0]);
        }
        return this.post(url, rbody, headers);
    }

    public Response post(String url, InputStream inputStream, Long contentLength, HttpHeader headers) {
        return this.post(url, ExtHttpClient.requestIO(inputStream, contentLength), headers);
    }

    private Response post(String url, RequestBody body, HttpHeader headers) {
        try {
            Request.Builder requestBuilder = new Request.Builder().url(url).post(body);
            return this.send(requestBuilder, Headers.of(headers.getHeaders()));
        }
        catch (BimfaceException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BimfaceRuntimeException("system.error", "The system is in preparation. Please try again later.");
        }
    }

    public Response put(String url, HttpHeader headers) {
        return this.put(url, this.emptyRequestBody, headers);
    }

    public Response put(String url, Object body, HttpHeader headers) {
        return this.put(url, JSONObject.toJSONString((Object)body), headers);
    }

    public Response put(String url, String body, HttpHeader headers) {
        return this.put(url, RequestBody.create((MediaType)MEDIA_TYPE_JSON, (String)body), headers);
    }

    public Response put(String url, InputStream inputStream, Long contentLength, HttpHeader headers) {
        return this.put(url, ExtHttpClient.requestIO(inputStream, contentLength), headers);
    }

    private Response put(String url, RequestBody body, HttpHeader headers) {
        try {
            Request.Builder requestBuilder = new Request.Builder().url(url).put(body);
            return this.send(requestBuilder, Headers.of(headers.getHeaders()));
        }
        catch (BimfaceException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BimfaceRuntimeException("system.error", "The system is in preparation. Please try again later.");
        }
    }

    public Response delete(String url) {
        return this.delete(url, new HttpHeader());
    }

    public Response delete(String url, HttpHeader headers) {
        try {
            Request.Builder requestBuilder = new Request.Builder().url(url).delete();
            return this.send(requestBuilder, Headers.of(headers.getHeaders()));
        }
        catch (BimfaceException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BimfaceRuntimeException("system.error", "The system is in preparation. Please try again later.");
        }
    }

    public Response send(Request.Builder requestBuilder, Headers headers) throws BimfaceException {
        if (headers != null) {
            requestBuilder.headers(headers);
        }
        try {
            Response response = this.okHttpClient.newCall(requestBuilder.build()).execute();
            if (response.code() >= 300) {
                String message = MessageFormat.format("Http call failed, url: {0}, http code: {1}", requestBuilder.build().httpUrl(), response.code());
                logger.error(message);
                throw new BimfaceRuntimeException("http.call.failed", message);
            }
            return response;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BimfaceException(e.getMessage());
        }
    }

    public void asyncGet(String url, Callback responseCallback) {
        this.asyncGet(url, new HttpHeader(), responseCallback);
    }

    public void asyncScheduleGet(final String url, final Callback responseCallback, final long delay) {
        this.scheduledThreadPool.schedule(new Runnable(){

            @Override
            public void run() {
                logger.info("async schedule get url:[{0}], delay:[{1}]", (Object)url, (Object)delay);
                ExtHttpClient.this.asyncGet(url, new HttpHeader(), responseCallback);
            }
        }, delay, TimeUnit.MILLISECONDS);
    }

    public void asyncGet(String url, HttpHeader headers, Callback responseCallback) {
        try {
            Request.Builder requestBuilder = new Request.Builder().get().url(url);
            this.asyncSend(requestBuilder, Headers.of(headers.getHeaders()), responseCallback);
        }
        catch (BimfaceException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BimfaceRuntimeException("system.error", "The system is in preparation. Please try again later.");
        }
    }

    public void asyncPost(String url, Callback callback) {
        this.asyncPost(url, new HttpHeader(), callback);
    }

    public void asyncPost(String url, HttpHeader httpHeader, Callback callback) {
        this.aysncPost(url, httpHeader, this.emptyRequestBody, callback);
    }

    public void aysncPost(String url, HttpHeader httpHeader, RequestBody requestBody, Callback callback) {
        try {
            Request.Builder requestBuilder = new Request.Builder().post(requestBody).url(url);
            this.asyncSend(requestBuilder, Headers.of(httpHeader.getHeaders()), callback);
        }
        catch (BimfaceException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BimfaceRuntimeException("system.error", "The system is in preparation. Please try again later.");
        }
    }

    public void asyncSend(Request.Builder requestBuilder, Headers headers, Callback responseCallback) throws BimfaceException {
        if (headers != null) {
            requestBuilder.headers(headers);
        }
        this.okHttpClient.newCall(requestBuilder.build()).enqueue(responseCallback);
    }

    private static RequestBody requestIO(final MediaType contentType, final byte[] content, final int offset, final int size) {
        if (content == null) {
            throw new NullPointerException("content == null");
        }
        return new RequestBody(){

            public MediaType contentType() {
                return contentType;
            }

            public long contentLength() {
                return size;
            }

            public void writeTo(BufferedSink sink) throws IOException {
                sink.write(content, offset, size);
            }
        };
    }

    private static RequestBody requestIO(final InputStream inputStream, final Long contentLength) {
        if (inputStream == null) {
            throw new NullPointerException("content == null");
        }
        return new RequestBody(){

            public MediaType contentType() {
                return MediaType.parse((String)ExtHttpClient.STREAM_MIME);
            }

            public long contentLength() {
                return contentLength;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void writeTo(BufferedSink sink) throws IOException {
                block7: {
                    try {
                        int l;
                        byte[] buffer = new byte[0x400000];
                        if (contentLength < 0x400000L) {
                            int l2;
                            while ((l2 = inputStream.read(buffer)) != -1) {
                                sink.outputStream().write(buffer, 0, l2);
                            }
                            break block7;
                        }
                        for (long remaining = contentLength.longValue(); remaining > 0L; remaining -= (long)l) {
                            l = inputStream.read(buffer, 0, (int)Math.min(0x400000L, remaining));
                            if (l == -1) {
                                break;
                            }
                            sink.outputStream().write(buffer, 0, l);
                        }
                    }
                    finally {
                        sink.close();
                    }
                }
            }
        };
    }
}

