/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.http;

import com.bimface.exception.BimfaceRuntimeException;
import com.glodon.paas.foundation.restclient.RESTException;
import com.glodon.paas.foundation.restclient.RESTResponseChecker;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import okhttp3.Request;

public class BimfaceResponseChecker
implements RESTResponseChecker {
    @Override
    public void check(Request request, String responseString) throws RESTException {
        String url = request.url().toString();
        String code = null;
        String message = "";
        try {
            JsonReader reader = new JsonReader((Reader)new StringReader(responseString));
            reader.beginObject();
            while (reader.hasNext()) {
                String key;
                block6 : switch (key = reader.nextName()) {
                    case "code": {
                        switch (reader.peek()) {
                            case STRING: {
                                code = reader.nextString();
                                break block6;
                            }
                        }
                        throw new RESTException(request.method(), url, -1L, "unrecognized code in response!");
                    }
                    case "message": {
                        if (JsonToken.STRING.equals((Object)reader.peek())) {
                            message = reader.nextString();
                            break;
                        }
                        reader.skipValue();
                        break;
                    }
                    case "data": {
                        reader.skipValue();
                    }
                }
            }
            reader.endObject();
            reader.close();
        }
        catch (IOException e) {
            throw new RESTException(request.method(), url, e);
        }
        if (!"success".equals(code)) {
            throw new BimfaceRuntimeException(code, message);
        }
    }
}

