/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.db;

import com.bimface.exception.BimfaceRuntimeException;
import java.io.BufferedReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptRunner {
    private static final Logger logger = LoggerFactory.getLogger(ScriptRunner.class);
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    private static final String DEFAULT_DELIMITER = ";";
    private Connection connection;
    private boolean stopOnError;
    private boolean throwWarning;
    private boolean autoCommit;
    private boolean sendFullScript;
    private boolean removeCRs;
    private boolean escapeProcessing = true;
    private String delimiter = ";";
    private boolean fullLineDelimiter;

    public ScriptRunner(Connection connection) {
        this.connection = connection;
    }

    public void setStopOnError(boolean stopOnError) {
        this.stopOnError = stopOnError;
    }

    public void setThrowWarning(boolean throwWarning) {
        this.throwWarning = throwWarning;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public void setSendFullScript(boolean sendFullScript) {
        this.sendFullScript = sendFullScript;
    }

    public void setRemoveCRs(boolean removeCRs) {
        this.removeCRs = removeCRs;
    }

    public void setEscapeProcessing(boolean escapeProcessing) {
        this.escapeProcessing = escapeProcessing;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setFullLineDelimiter(boolean fullLineDelimiter) {
        this.fullLineDelimiter = fullLineDelimiter;
    }

    public void runScript(Reader reader) {
        this.setAutoCommit();
        try {
            if (this.sendFullScript) {
                this.executeFullScript(reader);
            } else {
                this.executeLineByLine(reader);
            }
        }
        finally {
            this.rollbackConnection();
        }
    }

    private void executeFullScript(Reader reader) {
        StringBuilder script = new StringBuilder();
        try {
            String line;
            BufferedReader lineReader = new BufferedReader(reader);
            while ((line = lineReader.readLine()) != null) {
                script.append(line);
                script.append(LINE_SEPARATOR);
            }
            String command = script.toString();
            logger.info(command);
            this.executeStatement(command);
            this.commitConnection();
        }
        catch (Exception e) {
            String message = "Error executing: " + script + ".  Cause: " + e;
            logger.error(message);
            throw new BimfaceRuntimeException("system.error", message, e);
        }
    }

    private void executeLineByLine(Reader reader) {
        StringBuilder command = new StringBuilder();
        try {
            String line;
            BufferedReader lineReader = new BufferedReader(reader);
            while ((line = lineReader.readLine()) != null) {
                command = this.handleLine(command, line);
            }
            this.commitConnection();
            this.checkForMissingLineTerminator(command);
        }
        catch (Exception e) {
            String message = "Error executing: " + command + ".  Cause: " + e;
            logger.error(message);
            throw new BimfaceRuntimeException("system.error", message, e);
        }
    }

    public void closeConnection() {
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setAutoCommit() {
        try {
            if (this.autoCommit != this.connection.getAutoCommit()) {
                this.connection.setAutoCommit(this.autoCommit);
            }
        }
        catch (Throwable t) {
            throw new BimfaceRuntimeException("system.error", "Could not set AutoCommit to " + this.autoCommit + ". Cause: " + t, t);
        }
    }

    private void commitConnection() {
        try {
            if (!this.connection.getAutoCommit()) {
                this.connection.commit();
            }
        }
        catch (Throwable t) {
            throw new BimfaceRuntimeException("system.error", "Could not commit transaction. Cause: " + t, t);
        }
    }

    private void rollbackConnection() {
        try {
            if (!this.connection.getAutoCommit()) {
                this.connection.rollback();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void checkForMissingLineTerminator(StringBuilder command) {
        if (command != null && command.toString().trim().length() > 0) {
            throw new BimfaceRuntimeException("system.error", "Line missing end-of-line terminator (" + this.delimiter + ") => " + command);
        }
    }

    private StringBuilder handleLine(StringBuilder command, String line) throws SQLException, UnsupportedEncodingException {
        String trimmedLine = line.trim();
        if (this.lineIsComment(trimmedLine)) {
            String cleanedString = trimmedLine.substring(2).trim().replaceFirst("//", "");
            if (cleanedString.toUpperCase().startsWith("@DELIMITER")) {
                this.delimiter = cleanedString.substring(11, 12);
                return command;
            }
            logger.info(trimmedLine);
        } else {
            if (trimmedLine.toUpperCase().startsWith("DELIMITER")) {
                this.delimiter = StringUtils.substringAfter((String)trimmedLine, (String)"DELIMITER").trim();
                return command;
            }
            if (this.commandReadyToExecute(trimmedLine)) {
                command.append(line.substring(0, line.lastIndexOf(this.delimiter)));
                command.append(LINE_SEPARATOR);
                logger.info(command.toString());
                this.executeStatement(command.toString());
                command.setLength(0);
            } else if (trimmedLine.length() > 0) {
                command.append(line);
                command.append(LINE_SEPARATOR);
            }
        }
        return command;
    }

    private boolean lineIsComment(String trimmedLine) {
        return trimmedLine.startsWith("//") || trimmedLine.startsWith("--");
    }

    private boolean commandReadyToExecute(String trimmedLine) {
        return !this.fullLineDelimiter && trimmedLine.endsWith(this.delimiter) || this.fullLineDelimiter && trimmedLine.equals(this.delimiter);
    }

    private void executeStatement(String command) throws SQLException {
        boolean hasResults = false;
        Statement statement = this.connection.createStatement();
        statement.setEscapeProcessing(this.escapeProcessing);
        String sql = command;
        if (this.removeCRs) {
            sql = sql.replaceAll("\r\n", "\n");
        }
        if (this.stopOnError) {
            SQLWarning warning;
            hasResults = statement.execute(sql);
            if (this.throwWarning && (warning = statement.getWarnings()) != null) {
                throw warning;
            }
        } else {
            try {
                hasResults = statement.execute(sql);
            }
            catch (SQLException e) {
                String message = "Error executing: " + command + ".  Cause: " + e;
                logger.error(message);
            }
        }
        this.printResults(statement, hasResults);
        try {
            statement.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void printResults(Statement statement, boolean hasResults) {
        try {
            ResultSet rs;
            if (hasResults && (rs = statement.getResultSet()) != null) {
                ResultSetMetaData md = rs.getMetaData();
                int cols = md.getColumnCount();
                StringBuffer titleLine = new StringBuffer();
                for (int i = 0; i < cols; ++i) {
                    String name = md.getColumnLabel(i + 1);
                    titleLine.append(name + "\t");
                }
                logger.info(titleLine.toString());
                while (rs.next()) {
                    StringBuffer dataLine = new StringBuffer();
                    for (int i = 0; i < cols; ++i) {
                        String value = rs.getString(i + 1);
                        dataLine.append(value + "\t");
                    }
                    logger.info(dataLine.toString());
                }
            }
        }
        catch (SQLException e) {
            logger.error("Error printing results: " + e.getMessage());
        }
    }
}

