/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.db;

import com.bimface.db.ScriptRunner;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class MySqlInitializer {
    private static String defaultSqlResourcePattern = "classpath*:sql/*.sql";
    private static String defaultScriptCharset = "UTF-8";
    private static String bootstrapPrefix = "bootstrap_";
    private static String scriptSuffix = ".sql";

    public static void executeSqlResourceIfNotExistsDb(Connection connection, String database) throws SQLException, IOException {
        MySqlInitializer.executeSqlResourceIfNotExistsDb(connection, database, defaultSqlResourcePattern, defaultScriptCharset);
    }

    public static void executeSqlResourceIfNotExistsDb(Connection connection, String database, String sqlResourcePattern, String scriptCharset) throws SQLException, IOException {
        if (!MySqlInitializer.isDbExists(connection, database)) {
            try {
                MySqlInitializer.executeSqlResource(connection, sqlResourcePattern, scriptCharset);
            }
            catch (Exception e) {
                try {
                    MySqlInitializer.dropDb(connection, database);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e;
            }
        }
    }

    public static void executeSqlResource(Connection connection) throws IOException {
        MySqlInitializer.executeSqlResource(connection, defaultSqlResourcePattern, defaultScriptCharset);
    }

    public static void executeSqlResource(Connection connection, String sqlResourcePattern, String scriptCharset) throws IOException {
        ScriptRunner runner = new ScriptRunner(connection);
        runner.setStopOnError(true);
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        Resource[] resources = resolver.getResources(sqlResourcePattern);
        String bootstrapTimestamp = null;
        Resource bootstrapResource = null;
        for (Resource resource : resources) {
            String fileName = resource.getFilename();
            if (!fileName.startsWith(bootstrapPrefix) || !fileName.endsWith(scriptSuffix)) continue;
            String timestamp = StringUtils.substringBetween((String)fileName, (String)bootstrapPrefix, (String)scriptSuffix);
            if (null != bootstrapTimestamp && timestamp.compareTo(bootstrapTimestamp) <= 0) continue;
            bootstrapTimestamp = timestamp;
            bootstrapResource = resource;
        }
        TreeMap<String, Resource> scriptResources = new TreeMap<String, Resource>();
        scriptResources.put(bootstrapTimestamp, bootstrapResource);
        for (Resource resource : resources) {
            String timestamp;
            String fileName = resource.getFilename();
            if (fileName.startsWith(bootstrapPrefix) || !fileName.endsWith(scriptSuffix) || fileName.endsWith("manual" + scriptSuffix) || (timestamp = fileName.substring(0, bootstrapTimestamp.length())).compareTo(bootstrapTimestamp) <= 0) continue;
            scriptResources.put(timestamp, resource);
        }
        for (Resource resource : scriptResources.values()) {
            InputStreamReader reader = new InputStreamReader(resource.getInputStream(), scriptCharset);
            Throwable throwable = null;
            try {
                runner.runScript(reader);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader == null) continue;
                if (throwable != null) {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((Reader)reader).close();
            }
        }
    }

    private static boolean isDbExists(Connection connection, String database) throws SQLException {
        String sql;
        Statement stmt = connection.createStatement();
        ResultSet rs = stmt.executeQuery(sql = "SELECT COUNT(*) FROM information_schema.schemata WHERE schema_name=\"" + database + "\"");
        if (rs.next()) {
            return rs.getInt(1) != 0;
        }
        return false;
    }

    private static void dropDb(Connection connection, String database) throws SQLException {
        Statement stmt = connection.createStatement();
        String sql = "DROP DATABASE " + database;
        stmt.execute(sql);
    }
}

