/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.data.enums;

import com.bimface.data.enums.DataExceptionCode;
import com.bimface.data.exception.DataExceptionFactory;
import org.apache.commons.lang3.StringUtils;

public enum QuantityType {
    ALL(0),
    BILL(3),
    NORM(4),
    REINFORCEMENT(5);

    private byte code;

    private QuantityType(byte code) {
        this.code = code;
    }

    public byte getCode() {
        return this.code;
    }

    public static QuantityType getType(String type) {
        if (StringUtils.isEmpty((CharSequence)type)) {
            return ALL;
        }
        try {
            return QuantityType.valueOf(type);
        }
        catch (IllegalArgumentException e) {
            throw DataExceptionFactory.create(DataExceptionCode.UNKNOWN_ELEMENT_QUANTITY_TYPE, type);
        }
    }
}

