/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.data.bean;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.parser.Feature;
import com.bimface.data.common.SerializeIgnoreNullValue;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@SerializeIgnoreNullValue
public class PropertyItem {
    private String key;
    private Object value;
    private String unit;
    private Integer valueType;
    private String code;
    private Map<String, Object> extension;
    @JSONField(serialize=false)
    private Integer orderNumber;

    public PropertyItem(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public PropertyItem(String key, String value, String unit, Integer valueType, String code, String extension) {
        this(key, value);
        this.unit = unit;
        this.valueType = valueType;
        this.code = code;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{extension})) {
            try {
                this.extension = (Map)JSON.parseObject((String)extension, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public PropertyItem(String key, String value, String unit, Integer valueType, String code, String extension, Integer orderNumber) {
        this(key, value, unit, valueType, code, extension);
        this.orderNumber = orderNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyItem that = (PropertyItem)o;
        return new EqualsBuilder().append((Object)this.key, (Object)that.key).append(this.value, that.value).append((Object)this.unit, (Object)that.unit).append((Object)this.valueType, (Object)that.valueType).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append((Object)this.key).append(this.value).append((Object)this.unit).append((Object)this.valueType).toHashCode();
    }

    public String getKey() {
        return this.key;
    }

    public Object getValue() {
        return this.value;
    }

    public String getUnit() {
        return this.unit;
    }

    public Integer getValueType() {
        return this.valueType;
    }

    public String getCode() {
        return this.code;
    }

    public Map<String, Object> getExtension() {
        return this.extension;
    }

    public Integer getOrderNumber() {
        return this.orderNumber;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public void setValueType(Integer valueType) {
        this.valueType = valueType;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setExtension(Map<String, Object> extension) {
        this.extension = extension;
    }

    public void setOrderNumber(Integer orderNumber) {
        this.orderNumber = orderNumber;
    }

    public String toString() {
        return "PropertyItem(key=" + this.getKey() + ", value=" + this.getValue() + ", unit=" + this.getUnit() + ", valueType=" + this.getValueType() + ", code=" + this.getCode() + ", extension=" + this.getExtension() + ", orderNumber=" + this.getOrderNumber() + ")";
    }

    public PropertyItem() {
    }
}

