/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.data.bean;

import com.bimface.data.bean.BoundingBox;
import com.bimface.data.bean.PropertyGroup;
import com.bimface.data.bean.PropertyItem;
import com.bimface.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Property {
    private String elementId;
    private String name;
    private BoundingBox boundingBox;
    private String familyGuid;
    private List<PropertyGroup> properties = new ArrayList<PropertyGroup>();
    private String guid;

    public Property(String elementId, String name) {
        this(elementId);
        this.name = name;
    }

    public Property(String elementId) {
        this.elementId = elementId;
    }

    public static Property getCommonProperty(Property p1, Property p2) {
        List<PropertyGroup> commonPropertyGroups;
        Property res = new Property();
        if (p1 == null && p2 == null) {
            return res;
        }
        if (p1 == null) {
            return p2;
        }
        if (p2 == null) {
            return p1;
        }
        if (StringUtils.equals((CharSequence)p1.getName(), (CharSequence)p2.getName())) {
            res.setName(p1.getName());
        }
        if (StringUtils.equals((CharSequence)p1.getFamilyGuid(), (CharSequence)p2.getFamilyGuid())) {
            res.setFamilyGuid(p1.getFamilyGuid());
        }
        if (StringUtils.equals((CharSequence)p1.getGuid(), (CharSequence)p2.getGuid())) {
            res.setGuid(p1.getGuid());
        }
        if ((commonPropertyGroups = Property.getCommonPropertyGroups(p1.getProperties(), p2.getProperties())) != null) {
            res.setProperties(commonPropertyGroups);
        }
        return res;
    }

    private static List<PropertyGroup> getCommonPropertyGroups(List<PropertyGroup> groups1, List<PropertyGroup> groups2) {
        ArrayList<PropertyGroup> commonGroups = new ArrayList<PropertyGroup>();
        CollectionUtils.permute(groups1, groups2).forEach(pair -> {
            List<PropertyItem> commonPropertyItems;
            PropertyGroup group1 = (PropertyGroup)pair.getLeft();
            PropertyGroup group2 = (PropertyGroup)pair.getRight();
            if (StringUtils.equals((CharSequence)group2.getGroup(), (CharSequence)group1.getGroup()) && (commonPropertyItems = Property.getCommonPropertyItems(group1.getItems(), group2.getItems())) != null) {
                commonGroups.add(new PropertyGroup(group1.getGroup(), commonPropertyItems));
            }
        });
        return commonGroups.isEmpty() ? null : commonGroups;
    }

    private static List<PropertyItem> getCommonPropertyItems(List<PropertyItem> items1, List<PropertyItem> items2) {
        ArrayList<PropertyItem> commonItems = new ArrayList<PropertyItem>();
        CollectionUtils.permute(items1, items2).forEach(pair -> {
            PropertyItem item2;
            PropertyItem item1 = (PropertyItem)pair.getLeft();
            if (item1.equals(item2 = (PropertyItem)pair.getRight())) {
                commonItems.add(item1);
            }
        });
        return commonItems.isEmpty() ? null : commonItems;
    }

    public String getElementId() {
        return this.elementId;
    }

    public String getName() {
        return this.name;
    }

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public String getFamilyGuid() {
        return this.familyGuid;
    }

    public List<PropertyGroup> getProperties() {
        return this.properties;
    }

    public String getGuid() {
        return this.guid;
    }

    public void setElementId(String elementId) {
        this.elementId = elementId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setBoundingBox(BoundingBox boundingBox) {
        this.boundingBox = boundingBox;
    }

    public void setFamilyGuid(String familyGuid) {
        this.familyGuid = familyGuid;
    }

    public void setProperties(List<PropertyGroup> properties) {
        this.properties = properties;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Property)) {
            return false;
        }
        Property other = (Property)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$elementId = this.getElementId();
        String other$elementId = other.getElementId();
        if (this$elementId == null ? other$elementId != null : !this$elementId.equals(other$elementId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        BoundingBox this$boundingBox = this.getBoundingBox();
        BoundingBox other$boundingBox = other.getBoundingBox();
        if (this$boundingBox == null ? other$boundingBox != null : !((Object)this$boundingBox).equals(other$boundingBox)) {
            return false;
        }
        String this$familyGuid = this.getFamilyGuid();
        String other$familyGuid = other.getFamilyGuid();
        if (this$familyGuid == null ? other$familyGuid != null : !this$familyGuid.equals(other$familyGuid)) {
            return false;
        }
        List<PropertyGroup> this$properties = this.getProperties();
        List<PropertyGroup> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        String this$guid = this.getGuid();
        String other$guid = other.getGuid();
        return !(this$guid == null ? other$guid != null : !this$guid.equals(other$guid));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Property;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $elementId = this.getElementId();
        result = result * 59 + ($elementId == null ? 43 : $elementId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        BoundingBox $boundingBox = this.getBoundingBox();
        result = result * 59 + ($boundingBox == null ? 43 : ((Object)$boundingBox).hashCode());
        String $familyGuid = this.getFamilyGuid();
        result = result * 59 + ($familyGuid == null ? 43 : $familyGuid.hashCode());
        List<PropertyGroup> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        String $guid = this.getGuid();
        result = result * 59 + ($guid == null ? 43 : $guid.hashCode());
        return result;
    }

    public String toString() {
        return "Property(elementId=" + this.getElementId() + ", name=" + this.getName() + ", boundingBox=" + this.getBoundingBox() + ", familyGuid=" + this.getFamilyGuid() + ", properties=" + this.getProperties() + ", guid=" + this.getGuid() + ")";
    }

    public Property() {
    }
}

