/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.data.bean;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class ElementPropertyFilterRequest {
    private List<String> elementIds;
    private List<GroupAndKeysPair> filter;

    public static boolean checkValid(ElementPropertyFilterRequest request) {
        return request.getFilter().stream().noneMatch(it -> it.getGroup() == null);
    }

    public List<String> getElementIds() {
        return this.elementIds;
    }

    public List<GroupAndKeysPair> getFilter() {
        return this.filter;
    }

    public void setElementIds(List<String> elementIds) {
        this.elementIds = elementIds;
    }

    public void setFilter(List<GroupAndKeysPair> filter) {
        this.filter = filter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ElementPropertyFilterRequest)) {
            return false;
        }
        ElementPropertyFilterRequest other = (ElementPropertyFilterRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$elementIds = this.getElementIds();
        List<String> other$elementIds = other.getElementIds();
        if (this$elementIds == null ? other$elementIds != null : !((Object)this$elementIds).equals(other$elementIds)) {
            return false;
        }
        List<GroupAndKeysPair> this$filter = this.getFilter();
        List<GroupAndKeysPair> other$filter = other.getFilter();
        return !(this$filter == null ? other$filter != null : !((Object)this$filter).equals(other$filter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ElementPropertyFilterRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $elementIds = this.getElementIds();
        result = result * 59 + ($elementIds == null ? 43 : ((Object)$elementIds).hashCode());
        List<GroupAndKeysPair> $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : ((Object)$filter).hashCode());
        return result;
    }

    public String toString() {
        return "ElementPropertyFilterRequest(elementIds=" + this.getElementIds() + ", filter=" + this.getFilter() + ")";
    }

    public static class GroupAndKeysPair {
        private String group;
        private Set<String> keys;

        public static String concat(String group, String key) {
            if (key == null) {
                return group;
            }
            return key + "%_%" + group;
        }

        public static Set<String> flatConcat(String group, Set<String> keys) {
            if (CollectionUtils.isEmpty(keys)) {
                HashSet<String> result = new HashSet<String>();
                result.add(group);
                return result;
            }
            return keys.stream().map(k -> GroupAndKeysPair.concat(group, k)).collect(Collectors.toSet());
        }

        public String getGroup() {
            return this.group;
        }

        public Set<String> getKeys() {
            return this.keys;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public void setKeys(Set<String> keys) {
            this.keys = keys;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GroupAndKeysPair)) {
                return false;
            }
            GroupAndKeysPair other = (GroupAndKeysPair)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$group = this.getGroup();
            String other$group = other.getGroup();
            if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
                return false;
            }
            Set<String> this$keys = this.getKeys();
            Set<String> other$keys = other.getKeys();
            return !(this$keys == null ? other$keys != null : !((Object)this$keys).equals(other$keys));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GroupAndKeysPair;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $group = this.getGroup();
            result = result * 59 + ($group == null ? 43 : $group.hashCode());
            Set<String> $keys = this.getKeys();
            result = result * 59 + ($keys == null ? 43 : ((Object)$keys).hashCode());
            return result;
        }

        public String toString() {
            return "ElementPropertyFilterRequest.GroupAndKeysPair(group=" + this.getGroup() + ", keys=" + this.getKeys() + ")";
        }
    }
}

