/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.data.api;

import com.bimface.data.bean.Area;
import com.bimface.data.bean.CustomizedTree;
import com.bimface.data.bean.DrawingSheet;
import com.bimface.data.bean.ElementIdWithBoundingBox;
import com.bimface.data.bean.ElementIdWithFileId;
import com.bimface.data.bean.ElementsWithBoundingBox;
import com.bimface.data.bean.FileIdHashWithElementIds;
import com.bimface.data.bean.FileViews;
import com.bimface.data.bean.Floor;
import com.bimface.data.bean.IntegrateFileData;
import com.bimface.data.bean.LinkGraphNode;
import com.bimface.data.bean.MaterialInfo;
import com.bimface.data.bean.Property;
import com.bimface.data.bean.PropertyModifyDto;
import com.bimface.data.bean.QueryElementIdsParam;
import com.bimface.data.bean.Room;
import com.bimface.data.bean.RoomWithElementIdFileIds;
import com.bimface.data.bean.Tree;
import com.bimface.data.enums.DataExceptionCode;
import com.bimface.data.enums.ToleranceType;
import com.bimface.data.exception.DataExceptionFactory;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public interface IntegrateModelService {
    public ElementsWithBoundingBox listElements(Long var1, QueryElementIdsParam var2, @NonNull String var3);

    public Property getProperty(Long var1, String var2, String var3, boolean var4, @NonNull String var5);

    public List<Property> getProperties(Long var1, List<FileIdHashWithElementIds> var2, boolean var3, @NonNull String var4);

    default public Property getCommonElementProperties(Long integrateId, List<FileIdHashWithElementIds> fileIdHashWithElementIdsList, boolean includeOverrides, @NonNull String appKey) {
        if (appKey == null) {
            throw new NullPointerException("appKey");
        }
        throw new UnsupportedOperationException();
    }

    public List<MaterialInfo> getMaterials(Long var1, String var2, String var3, @NonNull String var4);

    @Deprecated
    public Object getTreeV1(Long var1, int var2, @NonNull String var3);

    public Tree getDefaultFloorTree(Long var1);

    public Tree getDefaultFloorTree(Long var1, @NonNull String var2);

    public Tree getDefaultSpecialtyTree(Long var1);

    public Tree getDefaultSpecialtyTree(Long var1, @NonNull String var2);

    public Tree getLonghuTongTree(Long var1);

    public Tree getCustomizedTree(Long var1, List<String> var2, List<List<String>> var3, List<ElementIdWithFileId> var4, Map<String, String> var5, boolean var6);

    public Tree getCustomizedTree(Long var1, List<String> var2, List<List<String>> var3, List<ElementIdWithFileId> var4, Map<String, String> var5, boolean var6, @NonNull String var7);

    @Deprecated
    public List<Tree> getCustomizedTreeList(Long var1, List<CustomizedTree> var2, boolean var3);

    @Deprecated
    public List<Tree> getElementsTree(Long var1, List<CustomizedTree> var2, List<ElementIdWithFileId> var3);

    default public List<Floor> listFloors(Long integrateId, boolean includeArea, boolean includeRoom, @NonNull String appKey) {
        if (appKey == null) {
            throw new NullPointerException("appKey");
        }
        throw DataExceptionFactory.create(DataExceptionCode.UNSUPPORTED_OPERATION, "Listing floors unsupported!");
    }

    default public List<Floor> listFloors(Long integrateId, boolean includeArea, boolean includeRoom) {
        throw DataExceptionFactory.create(DataExceptionCode.UNSUPPORTED_OPERATION, "Listing floors unsupported!");
    }

    default public List<ElementIdWithBoundingBox> listElementsByIds(Long integrateId, Map<String, List<String>> fileId2ElementIdListMap, @NonNull String appKey) {
        if (appKey == null) {
            throw new NullPointerException("appKey");
        }
        throw DataExceptionFactory.create(DataExceptionCode.UNSUPPORTED_OPERATION, "Listing elements by ids unsupported!");
    }

    default public List<ElementIdWithBoundingBox> listElementsByIds(Long integrateId, List<String> elementIds, @NonNull String appKey) {
        if (appKey == null) {
            throw new NullPointerException("appKey");
        }
        throw DataExceptionFactory.create(DataExceptionCode.UNSUPPORTED_OPERATION, "Listing elements by ids unsupported!");
    }

    public List<FileViews> getFileViewsList(Long var1, String var2, @NonNull String var3);

    default public List<Room> getRoomsByFloorId(Long integrateId, String floorId, @NonNull String appKey) {
        if (appKey == null) {
            throw new NullPointerException("appKey");
        }
        throw DataExceptionFactory.create(DataExceptionCode.UNSUPPORTED_OPERATION, "Rooms not supported!");
    }

    default public List<Room> getRoomsByFloorId(Long integrateId, String floorId) {
        throw DataExceptionFactory.create(DataExceptionCode.UNSUPPORTED_OPERATION, "Rooms not supported!");
    }

    public List<Room> getRoomByElementId(Long var1, String var2, @NonNull String var3, ToleranceType var4, ToleranceType var5);

    default public List<RoomWithElementIdFileIds> getRoomIdWithElementIds(Long integrateId, @NonNull String appKey, ToleranceType tolZ, ToleranceType tolXY) {
        if (appKey == null) {
            throw new NullPointerException("appKey");
        }
        throw DataExceptionFactory.create(DataExceptionCode.UNSUPPORTED_OPERATION, "Rooms with elementIds not supported!");
    }

    default public Room getRoom(Long integrateId, String roomId, @NonNull String appKey) {
        if (appKey == null) {
            throw new NullPointerException("appKey");
        }
        throw DataExceptionFactory.create(DataExceptionCode.UNSUPPORTED_OPERATION, "Room property not supported!");
    }

    default public Room getRoom(Long integrateId, String roomId) {
        throw DataExceptionFactory.create(DataExceptionCode.UNSUPPORTED_OPERATION, "Room property not supported!");
    }

    default public List<Area> getAreasByFloorId(Long integrateId, String floorId, @NonNull String appKey) {
        if (appKey == null) {
            throw new NullPointerException("appKey");
        }
        throw DataExceptionFactory.create(DataExceptionCode.UNSUPPORTED_OPERATION, "Areas not supported!");
    }

    default public List<Area> getAreasByFloorId(Long integrateId, String floorId) {
        throw DataExceptionFactory.create(DataExceptionCode.UNSUPPORTED_OPERATION, "Areas not supported!");
    }

    default public Area getArea(Long integrateId, String areaId, @NonNull String appKey) {
        if (appKey == null) {
            throw new NullPointerException("appKey");
        }
        throw DataExceptionFactory.create(DataExceptionCode.UNSUPPORTED_OPERATION, "Areas property not supported!");
    }

    default public Area getArea(Long integrateId, String areaId) {
        throw DataExceptionFactory.create(DataExceptionCode.UNSUPPORTED_OPERATION, "Areas property not supported!");
    }

    default public List<IntegrateFileData> getIntegrateFiles(Long integrateId, boolean includeDrawingSheet, @NonNull String appKey) {
        if (appKey == null) {
            throw new NullPointerException("appKey");
        }
        throw DataExceptionFactory.create(DataExceptionCode.UNSUPPORTED_OPERATION, "get integrate files not supported!");
    }

    default public List<IntegrateFileData> getIntegrateFiles(Long integrateId, boolean includeDrawingSheet) {
        throw DataExceptionFactory.create(DataExceptionCode.UNSUPPORTED_OPERATION, "get integrate files not supported!");
    }

    public List<LinkGraphNode> getLinkGraph(Long var1, String var2);

    default public List<DrawingSheet> getDrawingSheets(Long integrateId, @NonNull String appKey) {
        if (appKey == null) {
            throw new NullPointerException("appKey");
        }
        throw DataExceptionFactory.create(DataExceptionCode.UNSUPPORTED_OPERATION, "Type not supported!");
    }

    default public List<DrawingSheet> getDrawingSheets(Long integrateId) {
        throw DataExceptionFactory.create(DataExceptionCode.UNSUPPORTED_OPERATION, "Type not supported!");
    }

    public void modifyElement(Long var1, String var2, String var3, List<PropertyModifyDto> var4, @NonNull String var5);
}

