/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.cache.redis;

import com.bimface.cache.CacheService;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisServiceImpl
implements CacheService {
    private static final String CACHE_PREFIX_BIMFACE = "bimface:";
    private static final long CACHE_DEFAULT_EXPIRES = 604800L;
    private RedisTemplate<String, String> redisStringTemplate;
    private RedisTemplate<String, Map<String, String>> redisMapTemplate;

    @Override
    public String get(String key) {
        return (String)this.redisStringTemplate.opsForValue().get((Object)this.contactKey(key));
    }

    @Override
    public Map<String, String> getMap(String key) {
        return (Map)this.redisMapTemplate.opsForValue().get((Object)this.contactKey(key));
    }

    @Override
    public String getMapValue(String key, String hashKey) {
        return String.valueOf(this.redisMapTemplate.opsForHash().get((Object)this.contactKey(key), (Object)hashKey));
    }

    @Override
    public void put(String key, String value, long expires) {
        this.redisStringTemplate.opsForValue().set((Object)this.contactKey(key), (Object)value, expires, TimeUnit.SECONDS);
    }

    @Override
    public void put(String key, String value) {
        this.put(key, value, 604800L);
    }

    @Override
    public void putMap(String key, String hashKey, String value, long expires) {
        this.redisMapTemplate.opsForHash().put((Object)this.contactKey(key), (Object)hashKey, (Object)value);
        this.redisMapTemplate.expire((Object)this.contactKey(key), expires, TimeUnit.SECONDS);
    }

    @Override
    public void putMap(String key, Map<String, String> map) {
        this.putMap(key, map, 604800L);
    }

    @Override
    public void putMap(String key, Map<String, String> map, long expires) {
        this.redisMapTemplate.opsForHash().putAll((Object)this.contactKey(key), map);
        this.redisMapTemplate.expire((Object)this.contactKey(key), expires, TimeUnit.SECONDS);
    }

    @Override
    public void putMap(String key, String hashKey, String value) {
        this.putMap(key, hashKey, value, 604800L);
    }

    @Override
    public void remove(String key) {
        this.redisStringTemplate.delete((Object)this.contactKey(key));
    }

    @Override
    public void remove(String key, Object ... hashKeys) {
        this.redisMapTemplate.opsForHash().delete((Object)this.contactKey(key), hashKeys);
    }

    @Override
    public void expire(String key, long timeout) {
        this.redisStringTemplate.expire((Object)this.contactKey(key), timeout, TimeUnit.SECONDS);
    }

    @Override
    public void expireMap(String key, long timeout) {
        this.redisMapTemplate.expire((Object)this.contactKey(key), timeout, TimeUnit.SECONDS);
    }

    private String contactKey(String key) {
        return CACHE_PREFIX_BIMFACE + key;
    }

    public void setRedisStringTemplate(RedisTemplate<String, String> redisStringTemplate) {
        this.redisStringTemplate = redisStringTemplate;
    }

    public void setRedisMapTemplate(RedisTemplate<String, Map<String, String>> redisMapTemplate) {
        this.redisMapTemplate = redisMapTemplate;
    }
}

