/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.api.enums;

public enum TranslateStatus {
    PREPARE((byte)0, "prepare"),
    PROCESSING((byte)1, "processing"),
    SUCCESS((byte)99, "success"),
    FAILED((byte)-1, "failed");

    private Byte value;
    private String name;

    private TranslateStatus(Byte value, String name) {
        this.value = value;
        this.name = name;
    }

    public Byte getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public static TranslateStatus parse(Byte value) {
        for (TranslateStatus e : TranslateStatus.values()) {
            if (!e.value.equals(value)) continue;
            return e;
        }
        return null;
    }

    public static TranslateStatus parse(String name) {
        for (TranslateStatus e : TranslateStatus.values()) {
            if (!e.name.equalsIgnoreCase(name)) continue;
            return e;
        }
        return null;
    }

    public static Boolean isFinal(Byte value) {
        return TranslateStatus.isFinal(TranslateStatus.parse(value));
    }

    public static Boolean isFinal(TranslateStatus status) {
        return SUCCESS.equals((Object)status) || FAILED.equals((Object)status);
    }
}

