/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.api.enums;

public enum ReceiveType {
    TRANSLATE((byte)1, "translate"),
    TRANSLATE_DATA((byte)2, "translateData"),
    INTEGRATE((byte)3, "integrate"),
    INTEGRATE_DATA((byte)4, "integrateData"),
    MODEL_COMPARE((byte)5, "modelCompare"),
    MODEL_COMPARE_DATA((byte)6, "modelCompareData"),
    OFFLINE_DATABAG((byte)7, "offlineDatabag"),
    DATABAG_DERIVATIVE((byte)8, "databagDerivative"),
    BIZ_BINDING_DATA((byte)9, "bizBindingData"),
    BIZ_ASSOCIATION((byte)10, "businessAssociation");

    private Byte value;
    private String name;

    private ReceiveType(Byte value, String name) {
        this.value = value;
        this.name = name;
    }

    public Byte getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public static ReceiveType parse(Byte value) {
        for (ReceiveType e : ReceiveType.values()) {
            if (!e.value.equals(value)) continue;
            return e;
        }
        return null;
    }

    public static ReceiveType parse(String name) {
        for (ReceiveType e : ReceiveType.values()) {
            if (!e.name.equalsIgnoreCase(name)) continue;
            return e;
        }
        return null;
    }
}

