/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.api.enums;

public enum ModelCompareStatus {
    PREPARE((byte)0, "prepare"),
    PROCESSING((byte)1, "processing"),
    SUCCESS((byte)99, "success"),
    FAILED((byte)-1, "failed");

    private Byte value;
    private String name;

    private ModelCompareStatus(Byte value, String name) {
        this.value = value;
        this.name = name;
    }

    public Byte getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public static ModelCompareStatus parse(Byte value) {
        for (ModelCompareStatus e : ModelCompareStatus.values()) {
            if (!e.value.equals(value)) continue;
            return e;
        }
        return null;
    }

    public static ModelCompareStatus parse(String value) {
        for (ModelCompareStatus e : ModelCompareStatus.values()) {
            if (!e.getName().equalsIgnoreCase(value)) continue;
            return e;
        }
        return null;
    }

    public static Boolean isFinal(Byte value) {
        ModelCompareStatus status = ModelCompareStatus.parse(value);
        if (FAILED.equals((Object)status) || SUCCESS.equals((Object)status)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

