/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.api.enums;

public enum DerivativeStatus {
    PREPARE((byte)0, "prepare"),
    PROCESSING((byte)1, "processing"),
    SUCCESS((byte)99, "success"),
    FAILED((byte)-1, "failed");

    private Byte value;
    private String name;

    private DerivativeStatus(Byte value, String name) {
        this.value = value;
        this.name = name;
    }

    public Byte getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public static DerivativeStatus parse(Byte value) {
        for (DerivativeStatus e : DerivativeStatus.values()) {
            if (!e.value.equals(value)) continue;
            return e;
        }
        return null;
    }

    public static DerivativeStatus parse(String name) {
        for (DerivativeStatus e : DerivativeStatus.values()) {
            if (!e.name.equalsIgnoreCase(name)) continue;
            return e;
        }
        return null;
    }

    public static boolean isCompleted(String status) {
        return DerivativeStatus.isCompleted(DerivativeStatus.parse(status));
    }

    public static boolean isCompleted(DerivativeStatus status) {
        return status == SUCCESS || status == FAILED;
    }
}

