/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.api.enums;

public enum BusinessAssociationStatus {
    PREPARE((byte)0, "prepare"),
    PROCESSING((byte)1, "processing"),
    SUCCESS((byte)99, "success"),
    FAILED((byte)-1, "failed");

    private Byte value;
    private String name;

    private BusinessAssociationStatus(Byte value, String name) {
        this.value = value;
        this.name = name;
    }

    public Byte getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public static BusinessAssociationStatus parse(Byte value) {
        for (BusinessAssociationStatus e : BusinessAssociationStatus.values()) {
            if (!e.value.equals(value)) continue;
            return e;
        }
        return null;
    }

    public static BusinessAssociationStatus parse(String name) {
        for (BusinessAssociationStatus e : BusinessAssociationStatus.values()) {
            if (!e.name.equalsIgnoreCase(name)) continue;
            return e;
        }
        return null;
    }

    public static Boolean isFinal(Byte value) {
        BusinessAssociationStatus status = BusinessAssociationStatus.parse(value);
        if (FAILED.equals((Object)status) || SUCCESS.equals((Object)status)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

