/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.api.enums;

public enum ApiExceptionCode {
    MYSQL_INIT_FAILD("mysql.init.faild", "no database: [{0}] exists, and initialization faild"),
    NO_CLIENT_CREDENTIAL_PROVIDED("no.client.credential_provided", "client credential is not provided in authorization header"),
    FILE_IS_TRANSLATING("file.is.translating", "translate is in hand, fileId\uff1a[{0}]"),
    FILE_TRANSLATE_FAILED("file.translate.failed", "file.translate.failure, fileId: [{0}]"),
    FILE_HAS_NOT_TRANSLATED("file.has.not.translated", "translate not found, fileId: [{0}]"),
    FILE_HAS_NOT_TRANSLATED_TENANT("file.has.not.translated", "translate not found, fileId: [{0}], appKey: [{1}]"),
    FILE_NOT_FOUND("file.not.found", "file not found, fileId: [{0}]"),
    FILE_NOT_FOUND_TENANT("file.not.found", "file not found, fileId: [{0}], appKey: [{1}]"),
    FILE_HAS_UPGRADE("file.has.upgrade", "file has upgrade, fileId: [{0}]"),
    FILE_NOT_COMPLETE("file.not.complete", "file not complete, fileId: [{0}]"),
    FILE_TYPE_NOT_SUPPORT("file.type.not.support", "not support, worker type: [{0}], suffix: [{1}], config: [{2}]"),
    FILE_UPLOAD_FAILED("file.upload.failed", "file upload failed, fileId: [{0}]"),
    TRANSLATE_SEND_FAILED("translate.send.failed", "error :[{0}], error message:[{1}]"),
    FILE_INTEGRATE_FAILED("files.integrate.failed", "integrate failed, integrateId: [{0}]"),
    FILE_IS_INTEGRATING("files.is.integrating", "files is integrating, integrateId: [{0}]"),
    INTEGRATION_NOT_FOUND("integration.not.found", "integrate not found, integrateId: [{0}]"),
    INTEGRATION_NOT_FOUND_TENANT("integration.not.found", "integrate not found, integrateId: [{0}], appKey: [{1}]"),
    INVALID_INTEGRATION_ELEMENT_PROPERTY_OVERRIDE("invalid.integration.element.property.override", "One integration has more than one property override data in database, integrateId: [{0}]"),
    INVALID_FLOOR_MAPPING("invalid.floor.mapping", "files is integrating, integrateId: [{0}]"),
    FILE_FLOOR_TOO_LONG("file floor id too long", "file floorId: [{0}]"),
    PROJECT_FLOOR_TOO_LONG("project floor id too long", "project floorId: [{0}]"),
    PROJECT_FLOOR_NAME_TOO_LONG("project floor name too long", "project floorId: [{0}]"),
    FLOOR_MAPPING_DIFFERENT("file floor mapped to different project floor", "file floorId: [{0}], project floorId: [{1}]"),
    INVALID_RULE_FILE("invalid.rule.file", "invalid rule file, ruleFileId: [{0}]"),
    INVALID_TOKEN("invalid.token", "Invalid ViewToken, viewToken: [{0}]"),
    MODEL_COMPARE_FAILED("model.compare.failed", "compare failed, compareId: [{0}]"),
    MODEL_COMPARE_NOT_FINISHED("model.compare.not.finished", "model compare not finished, model compare id: [{0}]"),
    MODEL_COMPARE_NOT_FOUND("model.compare.not.found", "model compare not found, compare id: [{0}]"),
    MODEL_COMPARE_NOT_FOUND_TENANT("model.compare.not.found", "model compare not found, compare id: [{0}], appKey: [{1}]"),
    COMPARE_NOT_SUPPORTED("compare.not.supported", "compare of type: [{0}] not supported"),
    COMPARE_NOT_SUPPORTED_BETWEEN_NON_VECTOR_TRANSLATION("compare.not.supported.between.non.vector.translation.", "the non-vector translated file :{0}"),
    COMPARE_NOT_SUPPORTED_BETWEEN_VECTOR_AND_NON_VECTOR_TRANSLATION("compare.not.supported.between.vector.and.non-vector.translation", "the non-vector translated file :{0}, vector translated file: {1}"),
    COMPARE_NOT_SUPPORTED_BETWEEN_TWO_AND_THREE_DIMENSIONAL_TRANSLATION("compare.not.supported.between.two.and.three-dimensional.translation", "the two-dimensional translated file :{0}, three-dimensional translated file: {1}"),
    OFFLINE_DATABAG_FAILED("offline.databag.failed", "error message:[{0}]"),
    OFFLINE_DATABAG_NOT_COMPLETED("offline.databag.not.completed", "error message:[{0}]"),
    OFFLINE_DATABAG_NOT_FOUND("offline.databag.not.found", "error message:[{0}]"),
    ILLEGAL_JOB_REQUEST("illegal.job.request", "error message:[{0}]"),
    INPUT_PARAMETER_ERROR("input.parameter.error", "error message:[{0}]"),
    PRIORITY_NOT_SUPPORT("priority.not.support", "error message:[{0}]"),
    DATABAG_NOT_FOUND("databag.not.found", "error message:[{0}]"),
    VR_DATABAG_NOT_FOUND("vr.databag.not.found", "error message:[{0}]"),
    UNSUPPORTED_MODEL_TYPE("unsupported.model.type", "unsupported model type: [{0}]"),
    SHARELINK_EXPIRED("sharelink.expired", "sharelink expired, token: [{0}]"),
    SHARELINK_NOT_FOUND_BY_TOKEN("sharelink.not.found", "sharelink not exist, token: [{0}]"),
    SHARELINK_NOT_FOUND_BY_APP("sharelink.not.found", "sharelink not exist, appKey: [{0}]"),
    SHARELINK_NOT_FOUND_BY_SOURCE_ID("sharelink.not.found", "sharelink not exist, Id: [{0}]"),
    INPUT_SHARELINK_PASSWORD("input.share.link.password", "input share link password, token: [{0}]"),
    SHARELINK_PASSWORD_ERROR("share.link.password.error", "share link password error, token: [{0}]"),
    NONE_SHARELINK_FOUND("none.share.link.found", "none share exist, sourceIds: {0}"),
    DUPLICATE_SOURCEID_FOUND("duplicate.sourceId.found", "duplicate sourceId: [{0}]"),
    ASSOCIATION_NOT_FOUND("association.not.found", "associationId: [{0}]"),
    ASSOCIATION_NOT_FOUND_TENANT("association.not.found", "associationId: [{0}], appKey: [{1}]"),
    APP_NOT_FOUND("app.not.found", "no app found for appKey: [{0}]"),
    UNSUPPORTED_DATABAG_TYPE("databag.type.unsupported", "unsupported databag type [{0}]"),
    CALL_API_SERVICE_ERROR("call.api.service.error", "error message:[{0}]"),
    APPKEY_NOT_MATCH("app key not match", "resources not belong to appkey [{0}]"),
    UNSUPPORTED_WORKER_TYPE("unsupported.worker.type", "unsupported worker type: [{0}]"),
    NO_PERMISSION("no.permission", "no permission: [{0}]"),
    MODEL_TOO_LARGE_FOR_BAKE("model.to.large.for.bake", "element count: [{0}], triangle count: [{1}]"),
    EXCEPTION("exception", "error message:[{0}]"),
    AT_LEAST_ONE_MODEL_ID("at.least.one.model.id", "at least one model id(fileId, integrateId or compareId) should be specified"),
    MODEL_NOT_SUPPORT_PREVIEW("model.not.support.preview", "model id: [{0}], model type: [{1}], worker type: [{2}]"),
    PROJECT_NOT_FOUND("project.not.found", "project not found, projectId: [{0}]"),
    PROJECT_OPERATION_NOT_FOUND("project.operation.not.found", "project operation not found, projectOperationId: [{0}]"),
    PROJECT_OPERATION_SUCCESS("project.operation.success", "can not replace success operation, projectOperationId: [{0}]"),
    PROJECT_OPERATION_REPLACE_NOT_VALID("project.operation.replace.not.valid", "provided files for replacing not valid, projectOperationId: [{0}]");

    private String code;
    private String messageFormat;

    private ApiExceptionCode(String code, String messageFormat) {
        this.code = code;
        this.messageFormat = messageFormat;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessageFormat() {
        return this.messageFormat;
    }
}

