/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.common.util;

import java.security.Principal;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.UnavailableSecurityManagerException;
import org.apache.shiro.session.InvalidSessionException;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;

public class BaseUtil {
    public static Subject getSubject() {
        return SecurityUtils.getSubject();
    }

    public static Principal getPrincipal() {
        try {
            Subject subject = SecurityUtils.getSubject();
            Principal principal = (Principal)subject.getPrincipal();
            if (principal != null) {
                return principal;
            }
        }
        catch (UnavailableSecurityManagerException unavailableSecurityManagerException) {
        }
        catch (InvalidSessionException invalidSessionException) {
            // empty catch block
        }
        return null;
    }

    public static Session getSession() {
        try {
            Subject subject = BaseUtil.getSubject();
            Session session = subject.getSession(false);
            if (session == null) {
                session = subject.getSession();
            }
            if (session != null) {
                return session;
            }
        }
        catch (InvalidSessionException invalidSessionException) {
            // empty catch block
        }
        return null;
    }

    public static Object getCache(String key) {
        return BaseUtil.getCache(key, null);
    }

    public static Object getCache(String key, Object defaultValue) {
        Object obj = BaseUtil.getSession().getAttribute((Object)key);
        return obj == null ? defaultValue : obj;
    }

    public static void putCache(String key, Object value) {
        BaseUtil.getSession().setAttribute((Object)key, value);
    }

    public static void removeCache(String key) {
        BaseUtil.getSession().removeAttribute((Object)key);
    }
}

