package com.bcxin.risk.constant;

/**
 * @Classname ResultEnum
 * @Description 评估等级枚举类
 * @Date 2019/8/30 21:47
 * @Created by wangjianjun
 */
public enum CommonResultEnum {
    //这里是可以自己定义的，方便与前端交互即可
    PRIMARYSTATUS_CSZ(10, "提交初审"),
    PRIMARYSTATUS_CSXG(20, "初审退回"),
    PRIMARYSTATUS_CSTG(30, "初审通过"),
    ONE(1,"一级"),
    SECOND(2,"二级"),
    THIRD(3,"三级"),
    /** 请求失败 */
    FAIL(9999,"请求失败");

    private Integer code;
    private String msg;

    CommonResultEnum(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Integer getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }

    public static String getAlias(String key){
        for(CommonResultEnum e : CommonResultEnum.values()){
            if(e.getCode().toString().equals(key)){
                return e.getMsg();
            }
        }
        return "";
    }

}
