package com.bcxin.risk.common.webservice;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.constant.GlobalConst;
import com.bcxin.risk.sys.resources.ConfigResources;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

/**
 * web service 服务工具类 zhangye
 */
public class ClientUtil {
	private static Logger logger = LoggerFactory.getLogger(ClientUtil.class);

	/**
	 * <p>
	 * Description: 根据请求报文，请求服务地址获取 响应报文
	 *
	 * @param requestSoap
	 *            请求报文
	 * @param serviceAddress
	 *            响应报文
	 * @param charSet
	 *            字符集
	 * @param contentType
	 *            类型
	 * @return map封装的 服务器响应参数和返回报文.PS:statusCode :200 正常响应。responseSoap：响应报文
	 *         <p>
	 *         thinking:
	 *         </p>
	 *
	 * @author huoge </span>
	 * */
	public  static Map<String, Object> responseSoap(String requestSoap, String serviceAddress, String charSet, String contentType) {
		String responseSoap = "";
		Map<String, Object> resultmap = new HashMap<String, Object>();
		PostMethod postMethod = new PostMethod(serviceAddress);
		byte[] b = new byte[0];
		try {
			b = requestSoap.getBytes(charSet);
		} catch (UnsupportedEncodingException e) {
			logger.error(e.getMessage());
		}
		InputStream is = new ByteArrayInputStream(b, 0, b.length);
		RequestEntity re = new InputStreamRequestEntity(is, b.length, contentType);
		postMethod.setRequestEntity(re);

		HttpClient httpClient = new HttpClient();
		int statusCode = 0;
		try {
			httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(10000);
			httpClient.getHttpConnectionManager().getParams().setSoTimeout(10000);
			statusCode = httpClient.executeMethod(postMethod);
			resultmap.put("statusCode", statusCode);
		} catch (IOException e) {
			throw new RuntimeException("执行http请求失败", e);
		}
		if (statusCode == 200) {
			try {
				responseSoap = postMethod.getResponseBodyAsString();
				resultmap.put("responseSoap", responseSoap);
			} catch (IOException e) {
				throw new RuntimeException("获取请求返回报文失败", e);
			}
		} else {
			throw new RuntimeException("请求失败：" + statusCode);
		}
		return resultmap;
	}
	public static Result verifySXNW(String username, String pwd) {
		Result result = new Result();
		//拼接报文
		StringBuffer requestSoap = new StringBuffer();
		// 头部
		requestSoap.append("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:web=\"http://webservice.ahsga.linewell.com\">\n" +
				"   <soapenv:Header/>\n" +
				"   <soapenv:Body>\n" +
				"      <web:getUserinfo>\n");

		//添加code
		requestSoap.append("<web:in0>");
		requestSoap.append(ConfigResources.GX_NWCODE);
		requestSoap.append("</web:in0>\n");

		//添加用户名
		requestSoap.append("<web:in1>\n");
		requestSoap.append(username);
		requestSoap.append("</web:in1>\n");

		//添加密码
		requestSoap.append("<web:in2>\n");
		requestSoap.append(pwd);
		requestSoap.append("</web:in2>\n");

		//添加尾部
		requestSoap.append("</web:getUserinfo>\n" +
				"   </soapenv:Body>\n" +
				"</soapenv:Envelope>");


		String charSet = "utf-8";
		String contentType = "text/xml; charset=utf-8";
		ClientUtil clientUtil = new ClientUtil();
		SAXReader reader = new SAXReader();

		//webservies请求
		try {
			System.out.println(requestSoap.toString());
			Map<String, Object> responseSoapMap = responseSoap(requestSoap.toString(), ConfigResources.GX_NWADDRESS, charSet, contentType);
			int statusCode = (int) responseSoapMap.get("statusCode");
			String responseSoapxml = (String) responseSoapMap.get("responseSoap");
			//日志记录
			/*Sxlwlog sxlwlog = new Sxlwlog();
			sxlwlog.setCreateTime(new Date());
			sxlwlog.setUpdateTime(new Date());
			sxlwlog.setCode(SXNWCode);
			sxlwlog.setUserName(username);
			sxlwlog.setPwd(pwd);
			sxlwlog.setActive(true);
			sxlwlog.setRequestContext(requestSoap.toString());
			sxlwlog.setResponseContext(responseSoapxml);
			sxlwlog.setStatusCode(String.valueOf(statusCode));
			sxlwlogDao.save(sxlwlog);*/
			// 如果是200则调用成功，并且返回相应的信息
			if (StringUtil.equals(String.valueOf(statusCode),GlobalConst.MINISTRY_CODE_SUCCES_SXNW)) {
				System.out.println(responseSoapxml);
				org.dom4j.Document doc = reader.read(new ByteArrayInputStream(responseSoapxml.getBytes("UTF-8")));
				Element root = doc.getRootElement().element("Body").element("getUserinfoResponse").element("out");
				if (root != null ) {
					result.setDATE(root.getText());
					result.setCODE(GlobalConst.MINISTRY_CODE_SUCCES_SXNW);
				}
			} else {
				result.setCODE(statusCode + "");
				result.setMSG("调用接口接口出错");
				result.setERRORMSG("调用陕西南威公司登录验证出错");

			}
		} catch (Exception e) {
			result.setCODE(GlobalConst.MINISTRY_CODE_ERROR);
			result.setMSG(e.getMessage());
			result.setERRORMSG(e.getMessage());
			logger.error(e.getMessage());
		}

		return result;
	}
}
