package com.bcxin.risk.activity;

import com.bcxin.risk.activity.dto.data.ActivityDataDTO;
import com.bcxin.risk.activity.dto.data.ActivitySessionDTO;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.util.ConfigUtil;
import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.google.common.base.CharMatcher;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;


/**
 * <b>  </b>
 * @author ZXF
 * @create 2025/01/11 0011 14:37
 * @version
 * @注意事项 </b>
 */
@Repository
public class ActivitySessionDaoImpl extends DaoImpl<ActivitySession> implements ActivitySessionDao {

    @Override
    public List<ActivitySessionDTO> findActivitySessionByActivityId(Long activityId, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "SELECT  a.oid ," +
                "a.startDate, " +
                "a.endDate, " +
                "a.activityId, " +
                "a.contactName, " +
                "a.contactPosition, " +
                "a.contactPhone " +
                " FROM risk_activity_session a " +
                " where a.activityId = '" + activityId + "' ";

        wrapper.orderBy("a.startDate", true);
        List<ActivitySessionDTO> dtoList = Lists.newArrayList();
        Page<Map<String, Object>> pageList = queryMapsPage(sql, wrapper, page);
        List<Map<String, Object>> list = pageList.getRecords();
        list.forEach(result -> {
            ActivitySessionDTO dto = new ActivitySessionDTO(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }
    @Override
    public List<ActivitySession> activitySessionListByActivityId(Long activityId) {
        return selectList(SelectWrapper.instance().eq("activityId", activityId));
    }

    @Override
    public ActivitySession getActivitySession(Long oid) {
        return selectOne(SelectWrapper.instance().eq("oid", oid));
    }
}
