/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.user.dao.impl;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.condition.CriterionWrapper;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.condition.wrapper.Wrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.user.dao.MenuDao;
import com.bcxin.risk.user.domain.Menu;
import com.bcxin.risk.user.dto.data.MenuDataDto;
import com.bcxin.risk.user.dto.search.MenuSearchDto;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="menuDao")
public class MenuDaoImpl
extends DaoImpl<Menu>
implements MenuDao {
    public List<Menu> findMenuByOid(long oid) {
        List list = this.selectList(CriterionWrapper.instance().eq("oid", (Object)oid));
        if (list != null && list.size() > 0) {
            return list;
        }
        return null;
    }

    public Menu findMenuByOid(Long oid) {
        return (Menu)this.selectById(oid);
    }

    public List<Menu> findMenuList(MenuSearchDto searchDto, Page page) {
        ArrayList criterionList = Lists.newArrayList();
        if (searchDto.getParent() != null) {
            criterionList.add(Restrictions.eq((String)"parent_id", (Object)searchDto.getParent_id()));
        }
        if (StringUtil.isNotEmpty((String)searchDto.getMenuName())) {
            criterionList.add(Restrictions.eq((String)"menuName", (Object)searchDto.getMenuName()));
        }
        if (StringUtil.isNotEmpty((String)searchDto.getMenuCode())) {
            criterionList.add(Restrictions.eq((String)"menuCode", (Object)searchDto.getMenuCode()));
        }
        if (page == null) {
            return this.selectList(criterionList);
        }
        return this.selectPage(criterionList, page);
    }

    public List<MenuDataDto> queryMenu(Long oid) {
        String sql = "SELECT a.oid,a.menuDesc,a.menuName,a.parent_id,a.menuType,(CASE WHEN (SELECT COUNT(1) FROM base_role_menu WHERE menu_id = a.oid AND role_id = " + oid + ")>0 THEN 1 ELSE 0 END) AS xzbz  FROM base_menu a  ";
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.orderBy("a.oid", true);
        List list = this.queryMaps(sql, (Wrapper)wrapper);
        ArrayList dtoList = Lists.newArrayList();
        list.forEach(result -> {
            Map map = result;
            MenuDataDto dto = new MenuDataDto(map);
            dtoList.add(dto);
        });
        return dtoList;
    }
}

