/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.base.dao;

import com.bcxin.risk.base.dao.BaseDao;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Repository;

@Repository(value="baseDao")
public class BaseDaoImpl
implements BaseDao {
    @Autowired
    protected SessionFactory sessionFactory;

    protected Session getSession() {
        return this.sessionFactory.getCurrentSession();
    }

    public void evictObj(Object obj) {
        Session session = this.getSession();
        session.evict(obj);
    }

    public void mergeObj(Object obj) {
        Session session = this.getSession();
        session.merge(obj);
    }

    public boolean batchSave(List<Object> list) {
        Session session = this.getSession();
        session.beginTransaction().begin();
        int count = 0;
        for (Object object : list) {
            session.save(object);
            if (++count % 10 != 0) continue;
            session.flush();
            session.clear();
        }
        session.getTransaction().commit();
        session.close();
        return true;
    }

    public Criteria createCriteria(Class clazz) {
        return this.getSession().createCriteria(clazz);
    }

    public <T> T get(Class<T> clazz, Long oid) {
        return (T)this.getSession().get(clazz, (Serializable)oid);
    }

    public <T> T findByCriterionToUnique(Class<T> clazz, Criterion criterion) {
        Criteria criteria = this.createCriteria(clazz);
        if (criterion != null) {
            criteria.add(criterion);
        }
        return (T)criteria.uniqueResult();
    }

    public void save(Object obj) {
        this.getSession().saveOrUpdate(obj);
    }

    public void saveOrUpdate(Object obj) {
        this.getSession().saveOrUpdate(obj);
    }

    public void update(Object obj) {
        this.getSession().saveOrUpdate(obj);
    }

    public void delete(Object obj) {
        Session session = this.getSession();
        if (obj != null) {
            session.delete(obj);
        }
    }

    public <T> List findAll(Class<T> clazz) {
        Criteria criteria = this.createCriteria(clazz);
        return criteria.list();
    }

    public <T> List findByCriterion(Class<T> clazz, Criterion criterion) {
        Criteria criteria = this.createCriteria(clazz);
        if (criterion != null) {
            criteria.add(criterion);
        }
        return criteria.list();
    }

    public List findByHql(String queryString, Object value) throws DataAccessException {
        return this.findByHql(queryString, new Object[]{value});
    }

    public <T> List findByHql(String queryString, Object[] values) {
        Query queryObject = this.getSession().createQuery(queryString);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == null) continue;
                queryObject.setParameter(i, values[i]);
            }
        }
        return queryObject.list();
    }

    public List findByHql(String queryString) throws DataAccessException {
        return this.findByHql(queryString, null);
    }

    public List find(String queryString, Map paras) {
        Query queryObject = this.getSession().createQuery(queryString);
        for (Map.Entry entry : paras.entrySet()) {
            queryObject.setParameter((String)entry.getKey(), entry.getValue());
        }
        return queryObject.list();
    }

    public List findPageByHql(String queryString, Map paras, Page page) {
        Query query = this.getSession().createQuery(queryString);
        for (Map.Entry entry : paras.entrySet()) {
            query.setParameter((String)entry.getKey(), entry.getValue());
        }
        if (null != page) {
            page.setTotal(this.getCount(queryString, paras).intValue());
            query.setFirstResult((page.getCurrent() - 1) * page.getSize());
            query.setMaxResults(page.getSize());
        }
        return query.list();
    }

    public Integer getCount(String queryString, Map paras) {
        String hql = "select count(*) " + queryString;
        Query query = this.getSession().createQuery(hql);
        for (Map.Entry entry : paras.entrySet()) {
            query.setParameter((String)entry.getKey(), entry.getValue());
        }
        return ((Long)query.uniqueResult()).intValue();
    }

    public List getObejctByCollection(String queryString, String name, Collection collection) {
        return this.getSession().createQuery(queryString).setParameterList(name, collection).list();
    }

    public List getObejctByCollection(String queryString, String name, Collection collection, Type type) {
        return this.getSession().createQuery(queryString).setParameterList(name, collection, type).list();
    }

    public <T> List findByCriterionForPage(Class<T> clazz, List<Criterion> criterionList, DwzPage page) {
        Criteria criteria = this.createCriteria(clazz);
        if (criterionList != null) {
            for (int i = 0; i < criterionList.size(); ++i) {
                criteria.add(criterionList.get(i));
            }
        }
        criteria.addOrder(Order.desc((String)"oid"));
        if (page != null) {
            int totalCount = ((Long)criteria.setProjection(Projections.rowCount()).uniqueResult()).intValue();
            page.setTotalCount(totalCount);
            criteria.setProjection(null);
            criteria.setFirstResult((page.getPageNum() - 1) * page.getNumPerPage()).setMaxResults(page.getNumPerPage());
        }
        return criteria.list();
    }

    public <T> List findByCriterionForPage(Class<T> clazz, List<Criterion> criterionList, DwzPage page, Order order) {
        Criteria criteria = this.createCriteria(clazz);
        if (criterionList != null) {
            for (int i = 0; i < criterionList.size(); ++i) {
                criteria.add(criterionList.get(i));
            }
        }
        if (order != null) {
            criteria.addOrder(order);
        }
        if (page != null) {
            int totalCount = ((Long)criteria.setProjection(Projections.rowCount()).uniqueResult()).intValue();
            page.setTotalCount(totalCount);
            criteria.setProjection(null);
            criteria.setFirstResult((page.getPageNum() - 1) * page.getNumPerPage()).setMaxResults(page.getNumPerPage());
        }
        return criteria.list();
    }

    public <T> List findByCriterion(Class<T> clazz, List<Criterion> criterionList) {
        Criteria criteria = this.createCriteria(clazz);
        if (criterionList != null) {
            for (int i = 0; i < criterionList.size(); ++i) {
                criteria.add(criterionList.get(i));
            }
        }
        criteria.addOrder(Order.desc((String)"oid"));
        return criteria.list();
    }

    public <T> List findByCriterion(Class<T> clazz, List<Criterion> criterionList, List<Order> orderList) {
        Criteria criteria = this.createCriteria(clazz);
        if (criterionList != null) {
            for (int i = 0; i < criterionList.size(); ++i) {
                criteria.add(criterionList.get(i));
            }
        }
        if (orderList != null && orderList.size() > 0) {
            for (Order order : orderList) {
                criteria.addOrder(order);
            }
        }
        return criteria.list();
    }

    public <T> List findByCriterion(Class<T> clazz, List<Criterion> criterionList, Order order) {
        Criteria criteria = this.createCriteria(clazz);
        if (criterionList != null) {
            for (int i = 0; i < criterionList.size(); ++i) {
                criteria.add(criterionList.get(i));
            }
        }
        if (order != null) {
            criteria.addOrder(order);
        }
        return criteria.list();
    }

    public int executeUpdate(String sql) {
        NativeQuery query = this.getSession().createSQLQuery(sql);
        int result = query.executeUpdate();
        return result;
    }

    public List findBySQL(String sql, Object[] values) {
        Query query = this.getSession().createSQLQuery(sql).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == null) continue;
                query.setParameter(i, values[i]);
            }
        }
        return query.list();
    }

    public <T> List findByCriterionForPage(Class<T> clazz, List<Criterion> criterionList, DwzPage page, List<Order> orderList) {
        Criteria criteria = this.createCriteria(clazz);
        if (criterionList != null) {
            for (int i = 0; i < criterionList.size(); ++i) {
                criteria.add(criterionList.get(i));
            }
        }
        if (orderList != null && orderList.size() > 0) {
            for (Order order : orderList) {
                criteria.addOrder(order);
            }
        }
        if (page != null) {
            int totalCount = ((Long)criteria.setProjection(Projections.rowCount()).uniqueResult()).intValue();
            page.setTotalCount(totalCount);
            criteria.setProjection(null);
            criteria.setFirstResult((page.getPageNum() - 1) * page.getNumPerPage()).setMaxResults(page.getNumPerPage());
        }
        return criteria.list();
    }

    public <T> T load(Class<T> clazz, Long oid) {
        return (T)this.getSession().load(clazz, (Serializable)oid);
    }

    public <T> List findByCriterionForPage(Class<T> clazz, List<Criterion> criterionList, int pagesize, int offset) {
        Criteria criteria = this.createCriteria(clazz);
        if (criterionList != null) {
            for (int i = 0; i < criterionList.size(); ++i) {
                criteria.add(criterionList.get(i));
            }
        }
        if (offset >= 0) {
            int totalCount = ((Long)criteria.setProjection(Projections.rowCount()).uniqueResult()).intValue();
            criteria.setProjection(null);
            criteria.setFirstResult((offset - 1) * pagesize).setMaxResults(pagesize);
        }
        return criteria.list();
    }

    public <T> List findByCriterionForPage(Class<T> clazz, List<Criterion> criterionList, int pagesize, int offset, Order order) {
        Criteria criteria = this.createCriteria(clazz);
        if (criterionList != null) {
            for (int i = 0; i < criterionList.size(); ++i) {
                criteria.add(criterionList.get(i));
            }
        }
        if (order != null) {
            criteria.addOrder(order);
        }
        if (offset >= 0) {
            int totalCount = ((Long)criteria.setProjection(Projections.rowCount()).uniqueResult()).intValue();
            criteria.setProjection(null);
            criteria.setFirstResult((offset - 1) * pagesize).setMaxResults(pagesize);
        }
        return criteria.list();
    }
}

