/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.sync.apis.controllers;

import com.bcxin.runtime.domain.syncs.commands.CreateFtpDataSyncCommand;
import com.bcxin.runtime.domain.syncs.commands.results.CreateFtpDataSyncCommandResult;
import com.bcxin.runtime.domain.syncs.commands.results.CreateSyncViaFtpCallbackCommandResult;
import com.bcxin.runtime.domain.syncs.dtos.FtpConfigInfoDto;
import com.bcxin.runtime.domain.syncs.services.SyncViaFtpService;
import com.bcxin.saas.core.components.JsonProvider;
import com.bcxin.saas.core.utils.ExceptionUtils;
import com.bcxin.sync.apis.configs.FileModeConfig;
import com.bcxin.sync.apis.requests.SyncViaFtpCallbackRequest;
import com.bcxin.sync.apis.requests.SyncViaFtpDataImportRequest;
import com.bcxin.sync.apis.responses.SyncViaFtpCallbackResponse;
import com.bcxin.sync.apis.responses.SyncViaFtpDataImportResponse;
import com.bcxin.web.commons.responses.ErrorResponse;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v2/sync/ftp"})
public class SyncViaFtpController {
    private final SyncViaFtpService syncViaFtpService;
    private final JsonProvider jsonProvider;

    public SyncViaFtpController(SyncViaFtpService syncViaFtpService, JsonProvider jsonProvider) {
        this.syncViaFtpService = syncViaFtpService;
        this.jsonProvider = jsonProvider;
    }

    @PostMapping(value={"/data-import"})
    public ResponseEntity post(@RequestBody SyncViaFtpDataImportRequest request) {
        StringBuilder sb = new StringBuilder();
        try {
            request.validate();
            CreateFtpDataSyncCommand command = request.getCommand(this.jsonProvider);
            FtpConfigInfoDto ftpConfigInfoDto = new FtpConfigInfoDto();
            ftpConfigInfoDto.setUseFtp(FileModeConfig.getUseFtp());
            ftpConfigInfoDto.setUserName(FileModeConfig.getUserName());
            ftpConfigInfoDto.setHost(FileModeConfig.getHost());
            ftpConfigInfoDto.setFilePath(FileModeConfig.getFilePath());
            ftpConfigInfoDto.setPassword(FileModeConfig.getPassword());
            ftpConfigInfoDto.setPort(FileModeConfig.getPort());
            CreateFtpDataSyncCommandResult result = this.syncViaFtpService.create(command, ftpConfigInfoDto);
            String savedFileFlag = result.isSavedFileQueued() ? "\u4fdd\u5b58\u6587\u4ef6\u961f\u5217" : "\u65e0\u6587\u4ef6\u961f\u5217\u4fe1\u606f";
            String msg = String.format("\u540c\u6b65\u6210\u529f(%s)", savedFileFlag);
            sb.append(msg);
            SyncViaFtpDataImportResponse response = SyncViaFtpDataImportResponse.create(true, result.getDataSetResults(), msg);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception ex) {
            ErrorResponse error = ErrorResponse.create((String)sb.toString(), (Exception)ex);
            SyncViaFtpDataImportResponse errorResponse = SyncViaFtpDataImportResponse.create(false, error, error.getMessage());
            return ResponseEntity.badRequest().body((Object)errorResponse);
        }
    }

    @PostMapping(value={"/callback"}, consumes={"application/x-www-form-urlencoded"})
    public ResponseEntity callback(SyncViaFtpCallbackRequest request) {
        StringBuilder sb = new StringBuilder();
        try {
            CreateSyncViaFtpCallbackCommandResult result = this.syncViaFtpService.create(request.getCommand());
            sb.append("\u6267\u884c\u6210\u529f;");
            SyncViaFtpCallbackResponse response = SyncViaFtpCallbackResponse.create(true, result.getDataId(), "\u56de\u8c03\u6210\u529f");
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception ex) {
            sb.append(String.format("\u6570\u636e\u5bfc\u5165\u5f02\u5e38:%s;", ExceptionUtils.getStackMessage((Throwable)ex)));
            ErrorResponse error = ErrorResponse.create((String)sb.toString(), (Exception)ex);
            SyncViaFtpDataImportResponse errorResponse = SyncViaFtpDataImportResponse.create(false, error, error.getMessage());
            return ResponseEntity.badRequest().body((Object)errorResponse);
        }
    }
}

