/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.sync.apis.controllers;

import com.bcxin.runtime.domain.metas.commands.RefreshFormSyncTargetMetaCommand;
import com.bcxin.runtime.domain.metas.repositories.FormSyncTargetMetaRepository;
import com.bcxin.runtime.domain.metas.services.FormSyncTargetMetaService;
import com.bcxin.runtime.domain.snapshoots.FormSyncTargetConfigSnapshot;
import com.bcxin.saas.core.components.JsonProvider;
import com.bcxin.saas.core.utils.ExceptionUtils;
import com.bcxin.sync.apis.requests.FormSyncTargetRequest;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="com.bcxin.sync.apis.controllers.FormSyncTargetMetaController")
@RequestMapping(value={"/v2/sync/form-sync-targets"})
public class FormSyncTargetMetaController {
    private final FormSyncTargetMetaService formSyncTargetMetaService;
    private final FormSyncTargetMetaRepository formSyncTargetMetaRepository;
    private final JsonProvider jsonProvider;

    public FormSyncTargetMetaController(FormSyncTargetMetaService formSyncTargetMetaService, FormSyncTargetMetaRepository formSyncTargetMetaRepository, JsonProvider jsonProvider) {
        this.formSyncTargetMetaService = formSyncTargetMetaService;
        this.formSyncTargetMetaRepository = formSyncTargetMetaRepository;
        this.jsonProvider = jsonProvider;
    }

    @PostMapping
    public ResponseEntity post(@RequestBody FormSyncTargetRequest request) {
        try {
            RefreshFormSyncTargetMetaCommand command = request.getCommand();
            this.formSyncTargetMetaService.saveAll(command);
            return this.get();
        }
        catch (Exception ex) {
            return ResponseEntity.badRequest().body((Object)ex.toString());
        }
    }

    @PutMapping
    public ResponseEntity put(@RequestBody FormSyncTargetRequest request) {
        try {
            RefreshFormSyncTargetMetaCommand command = request.getCommand();
            this.formSyncTargetMetaService.update(command);
            return this.get();
        }
        catch (Exception ex) {
            return ResponseEntity.badRequest().body((Object)ex.toString());
        }
    }

    @GetMapping
    public ResponseEntity get() {
        try {
            List formSyncTargetMetaEntities = this.formSyncTargetMetaRepository.findAll();
            return ResponseEntity.ok(formSyncTargetMetaEntities.stream().map(ii -> {
                FormSyncTargetRequest.TargetItem item = new FormSyncTargetRequest.TargetItem();
                item.setCode(ii.getId());
                item.setMethod(ii.getMethod());
                FormSyncTargetConfigSnapshot targetConfigSnapshot = (FormSyncTargetConfigSnapshot)this.jsonProvider.getData(ii.getConfig(), FormSyncTargetConfigSnapshot.class);
                item.setTargetType(targetConfigSnapshot.getTargetType());
                item.setBodyAdditionalData(targetConfigSnapshot.getAdditionalData());
                item.setHeaders(targetConfigSnapshot.getHeaders());
                item.setFileUploadUrl(targetConfigSnapshot.getFileUploadUrl());
                item.setUrl(targetConfigSnapshot.getUrl());
                return item;
            }).collect(Collectors.toList()));
        }
        catch (Exception ex) {
            return ResponseEntity.badRequest().body((Object)ExceptionUtils.getStackMessage((Throwable)ex));
        }
    }

    @DeleteMapping(value={"/{code}"})
    public ResponseEntity delete(@PathVariable String code) {
        this.formSyncTargetMetaService.delete(code);
        return ResponseEntity.ok((Object)"\u6210\u529f!");
    }
}

