/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.sync.apis.controllers;

import com.bcxin.runtime.domain.snapshoots.JdbcMapSnapshot;
import com.bcxin.runtime.domain.syncs.commands.UpdateDataSyncMapCommand;
import com.bcxin.runtime.domain.syncs.repositories.DataSyncMapRepository;
import com.bcxin.runtime.domain.syncs.services.DataSyncMapService;
import com.bcxin.sync.apis.requests.DataMapRequest;
import com.bcxin.sync.apis.responses.DataSyncMapResponse;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v2/sync/data-maps"})
public class DataMapController {
    private final DataSyncMapService dataSyncMapService;
    private final DataSyncMapRepository dataSyncMapRepository;

    public DataMapController(DataSyncMapService dataSyncMapService, DataSyncMapRepository dataSyncMapRepository) {
        this.dataSyncMapService = dataSyncMapService;
        this.dataSyncMapRepository = dataSyncMapRepository;
    }

    @PostMapping
    public ResponseEntity post(@RequestBody DataMapRequest request) {
        this.dataSyncMapService.create(request.getCommand());
        return this.get();
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity put(@PathVariable String id, @RequestBody DataMapRequest request) {
        this.dataSyncMapService.update(UpdateDataSyncMapCommand.create((String)id, (String)request.getMapKey(), (JdbcMapSnapshot)request.getJdbcMap()));
        return this.get();
    }

    @GetMapping
    public ResponseEntity get() {
        List dataSyncMapEntities = this.dataSyncMapRepository.findAll();
        Collection responses = dataSyncMapEntities.stream().map(ii -> DataSyncMapResponse.create(ii.getId(), ii.getMapKey(), ii.getTargetConfig())).collect(Collectors.toList());
        return ResponseEntity.ok((Object)responses);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity delete(@PathVariable String id) {
        this.dataSyncMapService.delete(id);
        return this.get();
    }
}

