//用来配置每个元素的属性
class Graphics {
    constructor(ctx){
        this.ctx = ctx;
        this.ctx.translate(0.5, 0.5);
    }

    setColor(color){
        this.ctx.fillStyle = color;
        this.ctx.strokeStyle = color;
    }

    setFont(font){
        this.ctx.font = font;
    }
	
	setLineWidth(width) {
		this.ctx.lineWidth = width;
	}
	
	setShadow(color, x, y, blur) {
		this.ctx.shadowColor = color;
		this.ctx.shadowOffsetX = x;
		this.ctx.shadowOffsetY = y;
		this.ctx.shadowBlur = blur;
	}

    textAlign(align){
        this.ctx.textAlign = align; 
    }
	
	textBaseLine(pos) {
		this.ctx.textBaseline = pos;
	}

    stringWidth(txt){
        return this.ctx.measureText(txt).width;
    }

    strokeRect(x, y, width, height){
        this.ctx.strokeRect(x, y, width, height);
    }

    translate(x, y){
        this.ctx.translate(x, y)
    }

    fillText(text, x, y){
        this.ctx.fillText(text, x, y);
    }

    fillRect(x, y, width, height){
        this.ctx.fillRect(x, y, width, height);
    }

    fillPolygon(polygon){
        this.ctx.beginPath();
        for(let i = 0; i < polygon.points.length; i++){
            if(i == 0){
                this.ctx.moveTo(polygon.points[i].x,polygon.points[i].y);
            }else{
                this.ctx.lineTo(polygon.points[i].x,polygon.points[i].y);
            }
        }
        this.ctx.fill();
    }

    drawLine (x1, y1, x2, y2){     
        this.ctx.beginPath();
        this.ctx.moveTo(x1, y1);
        this.ctx.lineTo(x2, y2);
        this.ctx.closePath();
        this.ctx.stroke();
    }

    drawImage(image, x, y, width, height){
        this.ctx.drawImage(image, x, y, width, height);
    }

    drawRect(x, y, width, height){
        this.ctx.strokeRect(x, y, width, height);
    }

    drawString(text, x, y){
        this.ctx.strokeText(text, x, y);
    }
	
	drawTextWithRow(text, x, y, maxWidth, lineHeight) {
		if (typeof text != 'string' || typeof x != 'number' || typeof y != 'number') {
			return;
		}
		
		if (typeof maxWidth == 'undefined') {
			maxWidth = 142;
		}
		
		if(typeof lineHeight == 'undefined') {
			lineHeight = 12;
		}
		
		//将文本拆为单个字符数组
		let arrText = text.split('');
		let line = '';
		let textLine = '';
		
		for(let i = 0;i < arrText.length;i++) {
			textLine = line + arrText[i];
			let metrics = this.ctx.measureText(textLine);
			let textLen = metrics.width;
			
			if(textLen > maxWidth) {
				this.ctx.fillText(line, x, y);
				line = arrText[i];
				y += lineHeight;
			} else {
				line = textLine;
			}
		}
		
		this.ctx.fillText(line, x, y);
	}
	
    drawArc(x,y,r,color,borderColor,staAngle = 0,endAngle = Math.PI * 2,antiClockWise = false) {
		this.ctx.beginPath();
        this.ctx.arc(x,y,r,staAngle,endAngle,antiClockWise);
		this.ctx.closePath();
		this.setColor(borderColor);
		this.setLineWidth(1);
        this.ctx.stroke();
		this.setColor(color);
		this.ctx.fill();
    }
	
	drawEllipse(x, y, radiusX, radiusY, mode, color, rotation = 0, startAngle = 0, endAngle = Math.PI * 2, anticlockwise = false) {
		this.ctx.beginPath();
        this.ctx.ellipse(x, y, radiusX, radiusY, rotation, startAngle, endAngle, anticlockwise);
		this.ctx.closePath();
		
		if(mode == 'Opaque') {
			this.setColor(color.forecolor);
			this.ctx.fill();
		} else {
			this.setColor(color.backcolor);
			this.ctx.stroke();
		}
	}
	
	clearRect(x,y,width,height){
		this.ctx.clearRect(x,y,width,height);
	}
	
	getTextWidth(text) {
		const textLen = this.ctx.measureText(text).width;

		return textLen;
	}
	
	save() {
		this.ctx.save();
	}
	
	restore() {
		this.ctx.restore();
	}
}

export default Graphics;