class Api {
	
	constructor() {
		this.contextPath = "";
	}
	/**
     * 获取静态数据
     */
	getHtml(){
		
		return $.ajax({
			async: true,
			type: "GET",
			url: 'json/config.json',
			dataType: 'json',
            contentType: 'application/json'
		})
		
	}

	
	/**
     * 获取模板
     * @param tmlName 需要请求的模板名称
	 * @return 返回$.Deferred实例，用于后面调用done,fail方法
     */
	getTemplete(tmlName) {
		
		if(typeof tmlName == 'string' && tmlName.indexOf('.html') == -1) {
			tmlName += '.html';
		}
		
		return $.ajax({
			async: true,
			type: 'GET',
			url: 'tpl/' + tmlName
		});
	}
	
	/**
     * 获取json配置文件，主要是获取下拉列表的各项选择值
	 * @return 返回ajax异步实例，用于后面调用done,fail方法
     */
	getJSON() {
		return $.ajax({
			async: true,
			type: "GET",
			url: 'json/config.json',
			dataType: 'json',
            contentType: 'application/json'
		});
	}

	/**
	 * *获取树形结构所有模块列表**
	 * /designtime/applications/{applicationId}/allmodules
	 * @return 
	 */
	getModules(applicationId) {
		return $.ajax({
			async: false,
			type: "GET",
			url: this.contextPath+'/designtime/applications/'+applicationId+'/allmodules',
			dataType: 'json',
		});
	}
	/**
	 * *获取模块下的视图列表
	 * /designtime/applications/{applicationId}/modules/{moduleId}/views?searchword={searchword}
	 * @return 
	 */
	getModuleViews(moduleId) {
		return $.ajax({
			async: false,
			type: "GET",
			url: this.contextPath+'/designtime/applications/modules/'+moduleId+'/views?page=1&lines=10',
			dataType: 'json',
		});
	}
	/**
	 * *获取模块下的表单列表
	 * /designtime/applications/{applicationId}/modules/{moduleId}/forms?searchword={searchword}&type={type}
	 * @return 
	 */
	getModuleForms(moduleId,type){
		return $.ajax({
			async: false,
			type: "GET",
			url: this.contextPath+'/designtime/applications/modules/'+moduleId+'/forms?page=1&lines=10&type=',
			dataType: 'json',
		});
	}
}

export default Api;