import FormPanel from './FormPanel';
class Tree{
    static getInstance() {
		if(!Tree.instance || !(Tree.instance instanceof Tree)) {
			Tree.instance = new Tree();
		}
		//console.log(Tree.instance)
		return Tree.instance;
	}
    constructor(){
        this.form=null;
        this.container=null;
    }
    init(treeDiv,form){
        this.form=form;
        this.container=treeDiv;
        this.render();
    }
    render() {
		const form = this.form;
		const treeData=form.transformToTree();
		const $container = this.container;
		//console.log(treeData);
		if($container&&treeData) {
			//采用bootstrap-tree进行渲染

			$container.treeview({
				data: treeData
			});
			
			this.registerEvent($container);
		}
    }
    registerEvent(){

    }
}
export default Tree;