import {Api, Helper} from '../../utility';

class PropsPanel{
    static getInstance() {
		if(!PropsPanel.instance || !(PropsPanel.instance instanceof PropsPanel)) {
			PropsPanel.instance = new PropsPanel();
		}
		//console.log(Tree.instance)
		return PropsPanel.instance;
	}
    constructor(){
        this.form=null;
        this.container=null;
        this.api = new Api();
        this.api.contextPath=$('#contextPath', parent.document).val();
    }
    setProps(newProps) {
		Object.assign(this, newProps);
	}
	
	getProp(prop) {
		return this[prop];
	}
    init(params){
        this.setProps(params);
		this.render();
    }
    render() {
        const form = this.form;
		const api = this.api;
		const $container = $(this.container);
		let that=this;
        let $html = '';
        console.log("props")

        if(form){
            let currToEdit=form.getCurrToEdit();
            if(currToEdit==null){
            console.log("props,null")

                console.log("当前没有点击元素")
                $.when(api.getTemplete('editFormPanel-tmpl'), api.getJSON()).done((tml, json) => {
                            
                    $html =  Helper.getInstance().handleTemplete(tml[0], {},'editFormPanel-tmpl');
                    
                    $container.html($html);
                    
                });
            }else{
            console.log("props,have")

                const scope=currToEdit.scope;
                let allNameNow=[...form.allNameNow]
                
                allNameNow.forEach((elm,indx)=>{
                    if(elm.name==currToEdit.name){
                        allNameNow.splice(indx,1);
                    }
                })
                let h=`<div>
                <span class="input-group-addon d-inline">字段名称</span>
                <select id='refreshfields' name="refreshfields" class="form-control"><option>选择</option>`;
                if(form.allName.length>0){
                    for(let k=0;k<form.allName.length;k++){
                        h+=`<option value=${form.allName[k].value}>${form.allName[k].name}</option>`
                    }
                }
                h+=`</select>
                <button class="btn btn-primary d-block" id="delRefreshField">删除</button>
            </div>`;
                
                switch(scope){
                    case 'input':
                        $.when(api.getTemplete('editInput-tmpl'), api.getJSON()).done((tml, json) => {
                            let config=json[0];
                            config.inputType.forEach((val)=>{
                                if(val.value==currToEdit.getProp('fieldtype')){
                                    val.select="true";
                                }
                            })
                            config.texttypes.forEach((val)=>{
                                if(val.value==currToEdit.getProp('texttype')){
                                    val.select="true";
                                }
                            })
                            config.FocusSwitchKey.forEach((val)=>{
                                if(val.value==currToEdit.getProp('fieldkeyevent')){
                                    val.select="true";
                                }
                            })
                            config.validatelibsOption.forEach((val)=>{
                                if(val.value==currToEdit.getProp('validatelibs')){
                                    val.select="true";
                                }
                            })

                            let baseData={
                                name:currToEdit.getProp('name'),
                                fieldtype:currToEdit.getProp('fieldtype'),
                                numberpattern:currToEdit.getProp('numberpattern'),
                                value:currToEdit.getProp('value'),
                                valuescript:currToEdit.getProp('valuescript'),

                                readonlyshowvalonly:currToEdit.getProp('readonlyshowvalonly'),
                                refreshonchanged:currToEdit.getProp('refreshonchanged'),
                                calculateonrefresh:currToEdit.getProp('calculateonrefresh'),
                                mobile:currToEdit.getProp('mobile'),
                                discript:currToEdit.getProp('discript'),
                                refreshmode:currToEdit.getProp('refreshmode'),
                                isLimited:false,
                                editmode:currToEdit.getProp('editmode'),
                                validatelibs:currToEdit.getProp("validatelibs"),
                                validaterule:currToEdit.getProp("validaterule"),
                                hiddenscript:currToEdit.getProp("hiddenscript"),
                                hiddenvalue:currToEdit.getProp("hiddenvalue"),
                                hiddenprintscript:currToEdit.getProp("hiddenprintscript"),
                                printhiddenvalue:currToEdit.getProp("printhiddenvalue"),
                                readonlyscript:currToEdit.getProp("readonlyscript"),
                                isdefaultvalue:currToEdit.getProp("isdefaultvalue"),
                                allName:allNameNow,
                                allNameinSelf:form.allName,
                                processdescription:currToEdit.getProp("processdescription")=="[];[]"?"":currToEdit.getProp("processdescription"),
                                refreshfields:currToEdit.getProp("refreshfields"),
                                isshowlabel:currToEdit.getProp("isshowlabel"),
                                labelvalue:currToEdit.getProp("labelvalue"),
                                instantvalidate:currToEdit.getProp("instantvalidate"),
                            }
                            let inputData=$.extend({}, config, baseData);

                            $html =  Helper.getInstance().handleTemplete(tml[0], inputData,'editInput-tmpl');
                            
                            $container.html($html);

                            $container.find("input[type='radio'], input[type='checkbox'], select").on("change", function(){
                                that.changeEditContentPanel(this);
                            })
                            //局部刷新的添加字段和删除
                            $container.find("button[id='addRefreshField']").on("click", function(event){
                                $(event.currentTarget.parentElement).append(h);
                                $container.find("button[id='delRefreshField']").on("click", function(event){
                                    $(event.currentTarget.parentElement).remove();
                                    currToEdit.refreshfields.splice($(event.target.parentElement).index()-2,1)
                                })

                            })
                            $container.find("button[id='delRefreshField']").on("click", function(event){
                                $(event.currentTarget.parentElement).remove();
                                currToEdit.refreshfields.splice($(event.target.parentElement).index()-2,1)
                            })
                            
                        });
                    break;
                    case 'textarea':
                        $.when(api.getTemplete('editTextarea-tmpl'), api.getJSON()).done((tml, json) => {
                            let config=json[0];
                            config.validatelibsOption.forEach((val)=>{
                                if(val.value==currToEdit.getProp('validatelibs')){
                                    val.select="true";
                                }
                            })
                            let baseData={
                                name:currToEdit.getProp('name'),
                                value:currToEdit.getProp('value'),
                                valuescript:currToEdit.getProp('valuescript'),
                                refreshonchanged:currToEdit.getProp('refreshonchanged'),
                                calculateonrefresh:currToEdit.getProp('calculateonrefresh'),
                                mobile:currToEdit.getProp('mobile'),
                                discript:currToEdit.getProp('discript'),
                                refreshmode:currToEdit.getProp('refreshmode'),
                                isLimited:false,
                                editmode:currToEdit.getProp('editmode'),
                                validatelibs:currToEdit.getProp("validatelibs"),
                                validaterule:currToEdit.getProp("validaterule"),

                                hiddenscript:currToEdit.getProp("hiddenscript"),
                                hiddenvalue:currToEdit.getProp("hiddenvalue"),
                                hiddenprintscript:currToEdit.getProp("hiddenprintscript"),
                                printhiddenvalue:currToEdit.getProp("printhiddenvalue"),
                                readonlyscript:currToEdit.getProp("readonlyscript"),
                                isdefaultvalue:currToEdit.getProp("isdefaultvalue"),
                                allName:allNameNow,
                                allNameinSelf:form.allName,
                                processdescription:currToEdit.getProp("processdescription")=="[];[]"?"":currToEdit.getProp("processdescription"),
                                refreshfields:currToEdit.getProp("refreshfields"),
                                isshowlabel:currToEdit.getProp("isshowlabel"),
                                labelvalue:currToEdit.getProp("labelvalue"),
                                instantvalidate:currToEdit.getProp("instantvalidate"),

                            }
                            let textareaData=$.extend({},config, baseData);

                            $html =  Helper.getInstance().handleTemplete(tml[0],textareaData,'editTextarea-tmpl');
                            
                            $container.html($html);
                            $container.find("input[type='radio'], input[type='checkbox'], select").on("change", function(){
                                that.changeEditContentPanel(this);
                            })
                            //局部刷新的添加字段和删除
                            $container.find("button[id='addRefreshField']").on("click", function(event){
                                $(event.currentTarget.parentElement).append(h);
                                $container.find("button[id='delRefreshField']").on("click", function(event){
                                    $(event.currentTarget.parentElement).remove();
                                    currToEdit.refreshfields.splice($(event.target.parentElement).index()-2,1)
                                })
                            })
                            $container.find("button[id='delRefreshField']").on("click", function(event){
                                $(event.currentTarget.parentElement).remove();
                                currToEdit.refreshfields.splice($(event.target.parentElement).index()-2,1)
                            })
                        });
                    break;
                    case 'radio':
                        $.when(api.getTemplete('editRadio-tmpl'), api.getJSON()).done((tml, json) => {
                            let config=json[0];
                            // config.fontName[currToEdit.getProp('fontName')] = "true";
                            config.radiotexttypes.forEach((val)=>{
                                if(val.value==currToEdit.getProp('texttype')){
                                    val.select="true";
                                }
                            })
                            config.validatelibsOption.forEach((val)=>{
                                if(val.value==currToEdit.getProp('validatelibs')){
                                    val.select="true";
                                }
                            })
                            config.radioLayout.forEach((val)=>{
                                if(val.value==currToEdit.getProp('layout')){
                                    val.select="true";
                                }
                            })
                            config.modules[currToEdit.getProp('module')]="true";
                            config.dialogview[currToEdit.getProp('dialogview')]="true";
                            config.optionsvalue[currToEdit.getProp('optionsvalue')]="true";
                            config.optionstext[currToEdit.getProp('optionstext')]="true";


                            let baseData={
                                name:currToEdit.getProp('name'),
                                value:currToEdit.getProp('value'),
                                valuescript:currToEdit.getProp('valuescript'),
                                refreshonchanged:currToEdit.getProp('refreshonchanged'),
                                calculateonrefresh:currToEdit.getProp('calculateonrefresh'),
                                mobile:currToEdit.getProp('mobile'),
                                discript:currToEdit.getProp('discript'),
                                refreshmode:currToEdit.getProp('refreshmode'),
                                isLimited:false,
                                editmode:currToEdit.getProp('editmode'),
                                validatelibs:currToEdit.getProp("validatelibs"),
                                validaterule:currToEdit.getProp("validaterule"),
                                hiddenscript:currToEdit.getProp("hiddenscript"),
                                hiddenvalue:currToEdit.getProp("hiddenvalue"),
                                hiddenprintscript:currToEdit.getProp("hiddenprintscript"),
                                printhiddenvalue:currToEdit.getProp("printhiddenvalue"),
                                readonlyscript:currToEdit.getProp("readonlyscript"),
                                isdefaultvalue:currToEdit.getProp("isdefaultvalue"),
                                optionseditmode:currToEdit.getProp("optionseditmode"),
                                allName:allNameNow,
                                allNameinSelf:form.allName,
                                processdescription:currToEdit.getProp("processdescription")=="[];[]"?"":currToEdit.getProp("processdescription"),
                                refreshfields:currToEdit.getProp("refreshfields"),
                                isshowlabel:currToEdit.getProp("isshowlabel"),
                                labelvalue:currToEdit.getProp("labelvalue"),
                                optionsscript:currToEdit.getProp("optionsscript"),
                                instantvalidate:currToEdit.getProp("instantvalidate"),

                            }
                            let radioData=$.extend({}, config, baseData);

                            $html =  Helper.getInstance().handleTemplete(tml[0], radioData,'editRadio-tmpl');
                            
                            $container.html($html);
                            $container.find("input[type='radio'], input[type='checkbox'], select").on("change", function(){
                                that.changeEditContentPanel(this);
                            })
                            //局部刷新的添加字段和删除
                            $container.find("button[id='addRefreshField']").on("click", function(event){
                                $(event.currentTarget.parentElement).append(h);
                                $container.find("button[id='delRefreshField']").on("click", function(event){
                                    $(event.currentTarget.parentElement).remove();
                                    currToEdit.refreshfields.splice($(event.target.parentElement).index()-2,1)
                                })
                            })
                            $container.find("button[id='delRefreshField']").on("click", function(event){
                                $(event.currentTarget.parentElement).remove();
                                currToEdit.refreshfields.splice($(event.target.parentElement).index()-2,1)
                            })
                        });
                    break;
                    case 'checkbox':
                        $.when(api.getTemplete('editCheckbox-tmpl'), api.getJSON()).done((tml, json) => {
                            let config=json[0];
                            config.radiotexttypes.forEach((val)=>{
                                if(val.value==currToEdit.getProp('texttype')){
                                    val.select="true";
                                }
                            })
                            config.validatelibsOption.forEach((val)=>{
                                if(val.value==currToEdit.getProp('validatelibs')){
                                    val.select="true";
                                }
                            })
                            config.radioLayout.forEach((val)=>{
                                if(val.value==currToEdit.getProp('layout')){
                                    val.select="true";
                                }
                            })
                            // config.fontName[currToEdit.getProp('fontName')] = "true";
                            // config.radioLayout[currToEdit.getProp('layout')=="horizontal"?"水平":"垂直"]="true";
                            config.modules[currToEdit.getProp('module')]="true";
                            config.dialogview[currToEdit.getProp('dialogview')]="true";
                            config.optionsvalue[currToEdit.getProp('optionsvalue')]="true";
                            config.optionstext[currToEdit.getProp('optionstext')]="true";


                            let baseData={
                                name:currToEdit.getProp('name'),
                                value:currToEdit.getProp('value'),
                                valuescript:currToEdit.getProp('valuescript'),

                                refreshonchanged:currToEdit.getProp('refreshonchanged'),
                                calculateonrefresh:currToEdit.getProp('calculateonrefresh'),
                                mobile:currToEdit.getProp('mobile'),
                                discript:currToEdit.getProp('discript'),
                                refreshmode:currToEdit.getProp('refreshmode'),
                                isLimited:false,
                                editmode:currToEdit.getProp('editmode'),
                                validatelibs:currToEdit.getProp("validatelibs"),
                                validaterule:currToEdit.getProp("validaterule"),
                                hiddenscript:currToEdit.getProp("hiddenscript"),
                                hiddenvalue:currToEdit.getProp("hiddenvalue"),
                                hiddenprintscript:currToEdit.getProp("hiddenprintscript"),
                                printhiddenvalue:currToEdit.getProp("printhiddenvalue"),
                                readonlyscript:currToEdit.getProp("readonlyscript"),
                                isdefaultvalue:currToEdit.getProp("isdefaultvalue"),
                                optionseditmode:currToEdit.getProp("optionseditmode"),
                                allName:allNameNow,
                                allNameinSelf:form.allName,
                                processdescription:currToEdit.getProp("processdescription")=="[];[]"?"":currToEdit.getProp("processdescription"),
                                refreshfields:currToEdit.getProp("refreshfields"),
                                isshowlabel:currToEdit.getProp("isshowlabel"),
                                labelvalue:currToEdit.getProp("labelvalue"),
                                optionsscript:currToEdit.getProp("optionsscript"),
                                instantvalidate:currToEdit.getProp("instantvalidate"),
                            }
                            let checkboxData=$.extend({}, config, baseData);

                            $html =  Helper.getInstance().handleTemplete(tml[0], checkboxData,'editCheckbox-tmpl');
                            
                            $container.html($html);
                            $container.find("input[type='radio'], input[type='checkbox'], select").on("change", function(){
                                that.changeEditContentPanel(this);
                            })
                            //局部刷新的添加字段和删除
                            $container.find("button[id='addRefreshField']").on("click", function(event){
                                $(event.currentTarget.parentElement).append(h);
                                $container.find("button[id='delRefreshField']").on("click", function(event){
                                    $(event.currentTarget.parentElement).remove();
                                    currToEdit.refreshfields.splice($(event.target.parentElement).index()-2,1)
                                })
                            })
                            $container.find("button[id='delRefreshField']").on("click", function(event){
                                $(event.currentTarget.parentElement).remove();
                                currToEdit.refreshfields.splice($(event.target.parentElement).index()-2,1)
                            })
                        });
                    break;
                    case 'data':
                        $.when(api.getTemplete('editData-tmpl'), api.getJSON()).done((tml, json) => {
                            let config=json[0];
                            // config.fontName[currToEdit.getProp('fontName')] = "true";
                            config.datatexttypes.forEach((val)=>{
                                if(val.value==currToEdit.getProp('texttype')){
                                    val.select="true";
                                }
                            })
                            config.validatelibsOption.forEach((val)=>{
                                if(val.value==currToEdit.getProp('validatelibs')){
                                    val.select="true";
                                }
                            })
                            config.dataformat.forEach((val)=>{
                                if(val.value==currToEdit.getProp('datepattern')){
                                    val.select="true";
                                }
                            })
                            config.limitoption[currToEdit.getProp('prev_name')] = "true";

                            let baseData={
                                name:currToEdit.getProp('name'),
                                value:currToEdit.getProp('value'),
                                valuescript:currToEdit.getProp('valuescript'),

                                readonlyshowvalonly:currToEdit.getProp('readonlyshowvalonly'),
                                refreshonchanged:currToEdit.getProp('refreshonchanged'),
                                calculateonrefresh:currToEdit.getProp('calculateonrefresh'),
                                mobile:currToEdit.getProp('mobile'),
                                discript:currToEdit.getProp('discript'),
                                refreshmode:currToEdit.getProp('refreshmode'),
                                isLimited:false,
                                editmode:currToEdit.getProp('editmode'),
                                validatelibs:currToEdit.getProp("validatelibs"),
                                validaterule:currToEdit.getProp("validaterule"),
                                hiddenscript:currToEdit.getProp("hiddenscript"),
                                hiddenvalue:currToEdit.getProp("hiddenvalue"),
                                hiddenprintscript:currToEdit.getProp("hiddenprintscript"),
                                printhiddenvalue:currToEdit.getProp("printhiddenvalue"),
                                readonlyscript:currToEdit.getProp("readonlyscript"),
                                isdefaultvalue:currToEdit.getProp("isdefaultvalue"),
                                limit:currToEdit.getProp("limit"),
                                allName:allNameNow,
                                allNameinSelf:form.allName,
                                processdescription:currToEdit.getProp("processdescription")=="[];[]"?"":currToEdit.getProp("processdescription"),
                                refreshfields:currToEdit.getProp("refreshfields"),
                                isshowlabel:currToEdit.getProp("isshowlabel"),
                                labelvalue:currToEdit.getProp("labelvalue"),
                                instantvalidate:currToEdit.getProp("instantvalidate"),
                            }
                            let dataData=$.extend({}, config, baseData);

                            $html =  Helper.getInstance().handleTemplete(tml[0], dataData,'editData-tmpl');
                            
                            $container.html($html);
                            $container.find("input[type='radio'], input[type='checkbox'], select").on("change", function(){
                                that.changeEditContentPanel(this);
                            })
                            //局部刷新的添加字段和删除
                            $container.find("button[id='addRefreshField']").on("click", function(event){
                                $(event.currentTarget.parentElement).append(h);
                                $container.find("button[id='delRefreshField']").on("click", function(event){
                                    $(event.currentTarget.parentElement).remove();
                                    currToEdit.refreshfields.splice($(event.target.parentElement).index()-2,1)
                                })
                            })
                            $container.find("button[id='delRefreshField']").on("click", function(event){
                                $(event.currentTarget.parentElement).remove();
                                currToEdit.refreshfields.splice($(event.target.parentElement).index()-2,1)
                            })
                        });
                    break;
                    case 'select':
                        $.when(api.getTemplete('editSelect-tmpl'), api.getJSON()).done((tml, json) => {
                            let config=json[0];
                            config.datatexttypes.forEach((val)=>{
                                if(val.value==currToEdit.getProp('texttype')){
                                    val.select="true";
                                }
                            })
                            config.validatelibsOption.forEach((val)=>{
                                if(val.value==currToEdit.getProp('validatelibs')){
                                    val.select="true";
                                }
                            })
                            config.modules[currToEdit.getProp('module')]="true";
                            config.dialogview[currToEdit.getProp('dialogview')]="true";
                            config.optionsvalue[currToEdit.getProp('optionsvalue')]="true";
                            config.optionstext[currToEdit.getProp('optionstext')]="true";

                            let baseData={
                                name:currToEdit.getProp('name'),
                                value:currToEdit.getProp('value'),
                                valuescript:currToEdit.getProp('valuescript'),

                                readonlyshowvalonly:currToEdit.getProp('readonlyshowvalonly'),

                                refreshonchanged:currToEdit.getProp('refreshonchanged'),
                                calculateonrefresh:currToEdit.getProp('calculateonrefresh'),
                                mobile:currToEdit.getProp('mobile'),
                                discript:currToEdit.getProp('discript'),
                                refreshmode:currToEdit.getProp('refreshmode'),
                                isLimited:false,
                                editmode:currToEdit.getProp('editmode'),
                                validatelibs:currToEdit.getProp("validatelibs"),
                                validaterule:currToEdit.getProp("validaterule"),
                                hiddenscript:currToEdit.getProp("hiddenscript"),
                                hiddenvalue:currToEdit.getProp("hiddenvalue"),
                                hiddenprintscript:currToEdit.getProp("hiddenprintscript"),
                                printhiddenvalue:currToEdit.getProp("printhiddenvalue"),
                                readonlyscript:currToEdit.getProp("readonlyscript"),
                                isdefaultvalue:currToEdit.getProp("isdefaultvalue"),
                                allName:allNameNow,
                                allNameinSelf:form.allName,
                                processdescription:currToEdit.getProp("processdescription")=="[];[]"?"":currToEdit.getProp("processdescription"),
                                refreshfields:currToEdit.getProp("refreshfields"),
                                optionseditmode:currToEdit.getProp("optionseditmode"),
                                isshowlabel:currToEdit.getProp("isshowlabel"),
                                labelvalue:currToEdit.getProp("labelvalue"),
                                optionsscript:currToEdit.getProp("optionsscript"),
                                instantvalidate:currToEdit.getProp("instantvalidate"),
                            }
                            let selectData=$.extend({},config, baseData);

                            $html =  Helper.getInstance().handleTemplete(tml[0],selectData,'editSelect-tmpl');
                            
                            $container.html($html);
                            $container.find("input[type='radio'], input[type='checkbox'], select").on("change", function(){
                                that.changeEditContentPanel(this);
                            })
                            //局部刷新的添加字段和删除
                            $container.find("button[id='addRefreshField']").on("click", function(event){
                                $(event.currentTarget.parentElement).append(h);
                                $container.find("button[id='delRefreshField']").on("click", function(event){
                                    $(event.currentTarget.parentElement).remove();
                                    currToEdit.refreshfields.splice($(event.target.parentElement).index()-2,1)
                                })
                            })
                            $container.find("button[id='delRefreshField']").on("click", function(event){
                                $(event.currentTarget.parentElement).remove();
                                currToEdit.refreshfields.splice($(event.target.parentElement).index()-2,1)
                            })
                        });
                    break;
                    case 'dept':
                        
                        $.when(api.getTemplete('editDept-tmpl'), api.getJSON()).done((tml, json) => {
                            let config=json[0];
                            
                            config.datatexttypes.forEach((val)=>{
                                if(val.value==currToEdit.getProp('texttype')){
                                    val.select="true";
                                }
                            })
                            config.validatelibsOption.forEach((val)=>{
                                if(val.value==currToEdit.getProp('validatelibs')){
                                    val.select="true";
                                }
                            })
                            config.defaultOptionTypeOptions.forEach((val)=>{
                                if(val.value==currToEdit.getProp('defaultoptiontype')){
                                    val.select="true";
                                }
                            })
                            config.departmentLevelOptions.forEach((val)=>{
                                if(val.value==currToEdit.getProp('departmentlevel')){
                                    val.select="true";
                                }
                            })
                            let relatedFieldOptions = form.getallDeptName(currToEdit.getProp('name'));
                            relatedFieldOptions[currToEdit.getProp('relatedfield')] = "true";
                            let baseData={
                                name:currToEdit.getProp('name'),
                                value:currToEdit.getProp('value'),
                                valuescript:currToEdit.getProp('valuescript'),
                                readonlyshowvalonly:currToEdit.getProp('readonlyshowvalonly'),
                                refreshonchanged:currToEdit.getProp('refreshonchanged'),
                                calculateonrefresh:currToEdit.getProp('calculateonrefresh'),
                                mobile:currToEdit.getProp('mobile'),
                                discript:currToEdit.getProp('discript'),
                                refreshmode:currToEdit.getProp('refreshmode'),
                                isLimited:false,
                                editmode:currToEdit.getProp('editmode'),
                                validatelibs:currToEdit.getProp("validatelibs"),
                                validaterule:currToEdit.getProp("validaterule"),
                                hiddenscript:currToEdit.getProp("hiddenscript"),
                                hiddenvalue:currToEdit.getProp("hiddenvalue"),
                                hiddenprintscript:currToEdit.getProp("hiddenprintscript"),
                                printhiddenvalue:currToEdit.getProp("printhiddenvalue"),
                                readonlyscript:currToEdit.getProp("readonlyscript"),
                                isdefaultvalue:currToEdit.getProp("isdefaultvalue"),
                                allName:allNameNow,
                                allNameinSelf:form.allName,
                                allDeptName:form.allDeptName,
                                processdescription:currToEdit.getProp("processdescription")=="[];[]"?"":currToEdit.getProp("processdescription"),
                                relatedFieldOptions:relatedFieldOptions,
                                limitbyuser:currToEdit.getProp("limitbyuser"),
                                allowempty:currToEdit.getProp("allowempty"),
                                refreshfields:currToEdit.getProp("refreshfields"),
                                isshowlabel:currToEdit.getProp("isshowlabel"),
                                labelvalue:currToEdit.getProp("labelvalue"),
                                instantvalidate:currToEdit.getProp("instantvalidate"),
                            }
//                            relatedField:currToEdit.getProp("relatedField"),

                            let deptData=$.extend({},config, baseData);

                            $html =  Helper.getInstance().handleTemplete(tml[0],deptData,'editDept-tmpl');
                            
                            $container.html($html);
                            $container.find("input[type='radio'], input[type='checkbox'], select").on("change", function(){
                                that.changeEditContentPanel(this);
                            })
                            //局部刷新的添加字段和删除
                            $container.find("button[id='addRefreshField']").on("click", function(event){
                                $(event.currentTarget.parentElement).append(h);
                                $container.find("button[id='delRefreshField']").on("click", function(event){
                                    $(event.currentTarget.parentElement).remove();
                                    currToEdit.refreshfields.splice($(event.target.parentElement).index()-2,1)
                                })
                            })
                            $container.find("button[id='delRefreshField']").on("click", function(event){
                                $(event.currentTarget.parentElement).remove();
                                currToEdit.refreshfields.splice($(event.target.parentElement).index()-2,1)
                            })
                        });
                    break;
                    case 'selectaboutfield':
                        $.when(api.getTemplete('editSelectaboutfield-tmpl'), api.getJSON()).done((tml, json) => {
                            let config=json[0];
                            config.validatelibsOption.forEach((val)=>{
                                if(val.value==currToEdit.getProp('validatelibs')){
                                    val.select="true";
                                }
                            })
                            config.modules[currToEdit.getProp('module')]="true";
                            config.dialogview[currToEdit.getProp('dialogview')]="true";
                            config.optionsvalue[currToEdit.getProp('optionsvalue')]="true";
                            config.optionstext[currToEdit.getProp('optionstext')]="true";


                            let baseData={
                                name:currToEdit.getProp('name'),
                                value:currToEdit.getProp('value'),
                                valuescript:currToEdit.getProp('valuescript'),

                                refreshonchanged:currToEdit.getProp('refreshonchanged'),
                                calculateonrefresh:currToEdit.getProp('calculateonrefresh'),
                                discript:currToEdit.getProp('discript'),
                                refreshmode:currToEdit.getProp('refreshmode'),
                                isLimited:false,
                                editmode:currToEdit.getProp('editmode'),
                                validatelibs:currToEdit.getProp("validatelibs"),
                                validaterule:currToEdit.getProp("validaterule"),
                                hiddenscript:currToEdit.getProp("hiddenscript"),
                                hiddenvalue:currToEdit.getProp("hiddenvalue"),
                                hiddenprintscript:currToEdit.getProp("hiddenprintscript"),
                                printhiddenvalue:currToEdit.getProp("printhiddenvalue"),
                                readonlyscript:currToEdit.getProp("readonlyscript"),
                                isdefaultvalue:currToEdit.getProp("isdefaultvalue"),
                                optionseditmode:currToEdit.getProp("optionseditmode"),
                                allName:allNameNow,
                                allNameinSelf:form.allName,
                                processdescription:currToEdit.getProp("processdescription")=="[];[]"?"":currToEdit.getProp("processdescription"),
                                refreshfields:currToEdit.getProp("refreshfields"),
                                isshowlabel:currToEdit.getProp("isshowlabel"),
                                labelvalue:currToEdit.getProp("labelvalue"),
                                optionsscript:currToEdit.getProp("optionsscript"),
                                instantvalidate:currToEdit.getProp("instantvalidate"),
                            }
                            let selectaboutfieldData=$.extend({}, config, baseData);

                            $html =  Helper.getInstance().handleTemplete(tml[0], selectaboutfieldData,'editSelectaboutfield-tmpl');
                            
                            $container.html($html);
                            $container.find("input[type='radio'], input[type='checkbox'], select").on("change", function(){
                                that.changeEditContentPanel(this);
                            })
                            //局部刷新的添加字段和删除
                            $container.find("button[id='addRefreshField']").on("click", function(event){
                                $(event.currentTarget.parentElement).append(h);
                                $container.find("button[id='delRefreshField']").on("click", function(event){
                                    $(event.currentTarget.parentElement).remove();
                                    currToEdit.refreshfields.splice($(event.target.parentElement).index()-2,1)
                                })
                            })
                            $container.find("button[id='delRefreshField']").on("click", function(event){
                                $(event.currentTarget.parentElement).remove();
                                currToEdit.refreshfields.splice($(event.target.parentElement).index()-2,1)
                            })
                        });
                    break;
                    case 'treedepartmentfield':
                        
                        $.when(api.getTemplete('editTreedepartmentfield-tmpl'), api.getJSON()).done((tml, json) => {
                            let config=json[0];
                            config.datatexttypes.forEach((val)=>{
                                if(val.value==currToEdit.getProp('texttype')){
                                    val.select="true";
                                }
                            })
                            config.validatelibsOption.forEach((val)=>{
                                if(val.value==currToEdit.getProp('validatelibs')){
                                    val.select="true";
                                }
                            })
                            let baseData={
                                name:currToEdit.getProp('name'),
                                value:currToEdit.getProp('value'),
                                valuescript:currToEdit.getProp('valuescript'),

                                readonlyshowvalonly:currToEdit.getProp('readonlyshowvalonly'),

                                refreshonchanged:currToEdit.getProp('refreshonchanged'),
                                calculateonrefresh:currToEdit.getProp('calculateonrefresh'),
                                mobile:currToEdit.getProp('mobile'),
                                discript:currToEdit.getProp('discript'),
                                refreshmode:currToEdit.getProp('refreshmode'),
                                isLimited:false,
                                validatelibs:currToEdit.getProp("validatelibs"),
                                validaterule:currToEdit.getProp("validaterule"),
                                hiddenscript:currToEdit.getProp("hiddenscript"),
                                hiddenvalue:currToEdit.getProp("hiddenvalue"),
                                hiddenprintscript:currToEdit.getProp("hiddenprintscript"),
                                printhiddenvalue:currToEdit.getProp("printhiddenvalue"),
                                readonlyscript:currToEdit.getProp("readonlyscript"),
                                isdefaultvalue:currToEdit.getProp("isdefaultvalue"),
                                limit:currToEdit.getProp("limit"),
                                allName:allNameNow,
                                allNameinSelf:form.allName,
                                refreshfields:currToEdit.getProp("refreshfields"),
                                isshowlabel:currToEdit.getProp("isshowlabel"),
                                labelvalue:currToEdit.getProp("labelvalue"),
                                instantvalidate:currToEdit.getProp("instantvalidate"),
                            }

                            let treedepartmentfieldData=$.extend({}, baseData,config);

                            $html =  Helper.getInstance().handleTemplete(tml[0],treedepartmentfieldData,'editTreedepartmentfield-tmpl');
                            
                            $container.html($html);
                            $container.find("input[type='radio'], input[type='checkbox'], select").on("change", function(){
                                that.changeEditContentPanel(this);
                            })
                            //局部刷新的添加字段和删除
                            $container.find("button[id='addRefreshField']").on("click", function(event){
                                $(event.currentTarget.parentElement).append(h);
                                $container.find("button[id='delRefreshField']").on("click", function(event){
                                    $(event.currentTarget.parentElement).remove();
                                    currToEdit.refreshfields.splice($(event.target.parentElement).index()-2,1)
                                })
                            })
                            $container.find("button[id='delRefreshField']").on("click", function(event){
                                $(event.currentTarget.parentElement).remove();
                                currToEdit.refreshfields.splice($(event.target.parentElement).index()-2,1)
                            })
                        });
                    break;
                    case 'userfield':
                        $.when(api.getTemplete('editUserfield-tmpl'), api.getJSON()).done((tml, json) => {
                            let config=json[0];

                            config.datatexttypes.forEach((val)=>{
                                if(val.value==currToEdit.getProp('texttype')){
                                    val.select="true";
                                }
                            })
                            config.selectModeOption.forEach((val)=>{
                                if(val.value==currToEdit.getProp('selectmode')){
                                    val.select="true";
                                }
                            })
                            config.validatelibsOption.forEach((val)=>{
                                if(val.value==currToEdit.getProp('validatelibs')){
                                    val.select="true";
                                }
                            })
                            // config.datatexttypes[currToEdit.getProp('texttype')] = "true";
                            // config.selectModeOption[currToEdit.getProp('selectmode')=="multiselect"?'多选':'单选'] = "true";

                            let baseData={
                                name:currToEdit.getProp('name'),
                                value:currToEdit.getProp('value'),
                                valuescript:currToEdit.getProp('valuescript'),

                                readonlyshowvalonly:currToEdit.getProp('readonlyshowvalonly'),
                                refreshonchanged:currToEdit.getProp('refreshonchanged'),
                                calculateonrefresh:currToEdit.getProp('calculateonrefresh'),
                                mobile:currToEdit.getProp('mobile'),
                                discript:currToEdit.getProp('discript'),
                                refreshmode:currToEdit.getProp('refreshmode'),
                                isLimited:false,
                                editmode:currToEdit.getProp('editmode'),
                                validatelibs:currToEdit.getProp("validatelibs"),
                                validaterule:currToEdit.getProp("validaterule"),
                                hiddenscript:currToEdit.getProp("hiddenscript"),
                                hiddenvalue:currToEdit.getProp("hiddenvalue"),
                                hiddenprintscript:currToEdit.getProp("hiddenprintscript"),
                                printhiddenvalue:currToEdit.getProp("printhiddenvalue"),
                                readonlyscript:currToEdit.getProp("readonlyscript"),
                                isdefaultvalue:currToEdit.getProp("isdefaultvalue"),
                                allName:allNameNow,
                                allNameinSelf:form.allName,
                                processdescription:currToEdit.getProp("processdescription")=="[];[]"?"":currToEdit.getProp("processdescription"),
                                refreshfields:currToEdit.getProp("refreshfields"),
                                isshowlabel:currToEdit.getProp("isshowlabel"),
                                labelvalue:currToEdit.getProp("labelvalue"),
                                instantvalidate:currToEdit.getProp("instantvalidate"),
                            }
                            let userfieldData=$.extend({}, config, baseData);

                            $html =  Helper.getInstance().handleTemplete(tml[0], userfieldData,'editUserfield-tmpl');
                            
                            $container.html($html);
                            $container.find("input[type='radio'], input[type='checkbox'], select").on("change", function(){
                                that.changeEditContentPanel(this);
                            })
                            //局部刷新的添加字段和删除
                            $container.find("button[id='addRefreshField']").on("click", function(event){
                                $(event.currentTarget.parentElement).append(h);
                                $container.find("button[id='delRefreshField']").on("click", function(event){
                                    $(event.currentTarget.parentElement).remove();
                                    currToEdit.refreshfields.splice($(event.target.parentElement).index()-2,1)
                                })
                            })
                            $container.find("button[id='delRefreshField']").on("click", function(event){
                                $(event.currentTarget.parentElement).remove();
                                currToEdit.refreshfields.splice($(event.target.parentElement).index()-2,1)
                            })
                        });
                    break;
                    case 'suggestfield':
                        $.when(api.getTemplete('editSuggestfield-tmpl'), api.getJSON()).done((tml, json) => {
                            let config=json[0];
                            config.datatexttypes.forEach((val)=>{
                                if(val.value==currToEdit.getProp('texttype')){
                                    val.select="true";
                                }
                            })
                            config.validatelibsOption.forEach((val)=>{
                                if(val.value==currToEdit.getProp('validatelibs')){
                                    val.select="true";
                                }
                            })
                            config.modules[currToEdit.getProp('module')]="true";
                            config.dialogview[currToEdit.getProp('dialogview')]="true";
                            config.optionsvalue[currToEdit.getProp('optionsvalue')]="true";
                            config.optionstext[currToEdit.getProp('optionstext')]="true";
                            

                            
                            let baseData={
                                name:currToEdit.getProp('name'),
                                value:currToEdit.getProp('value'),
                                valuescript:currToEdit.getProp('valuescript'),

                                readonlyshowvalonly:currToEdit.getProp('readonlyshowvalonly'),
                                refreshonchanged:currToEdit.getProp('refreshonchanged'),
                                calculateonrefresh:currToEdit.getProp('calculateonrefresh'),
                                mobile:currToEdit.getProp('mobile'),
                                discript:currToEdit.getProp('discript'),
                                refreshmode:currToEdit.getProp('refreshmode'),
                                isLimited:false,
                                editmode:currToEdit.getProp('editmode'),
                                validatelibs:currToEdit.getProp("validatelibs"),
                                validaterule:currToEdit.getProp("validaterule"),
                                hiddenscript:currToEdit.getProp("hiddenscript"),
                                hiddenvalue:currToEdit.getProp("hiddenvalue"),
                                hiddenprintscript:currToEdit.getProp("hiddenprintscript"),
                                printhiddenvalue:currToEdit.getProp("printhiddenvalue"),
                                readonlyscript:currToEdit.getProp("readonlyscript"),
                                isdefaultvalue:currToEdit.getProp("isdefaultvalue"),
                                allName:allNameNow,
                                allNameinSelf:form.allName,
                                processdescription:currToEdit.getProp("processdescription")=="[];[]"?"":currToEdit.getProp("processdescription"),
                                refreshfields:currToEdit.getProp("refreshfields"),
                                optionseditmode:currToEdit.getProp("optionseditmode"),
                                isshowlabel:currToEdit.getProp("isshowlabel"),
                                labelvalue:currToEdit.getProp("labelvalue"),
                                datamode:currToEdit.getProp('datamode'),
                                optionsscript:currToEdit.getProp('optionsscript'),
                            }
                            let suggestfieldData=$.extend({}, baseData,config);

                            $html =  Helper.getInstance().handleTemplete(tml[0],suggestfieldData,'editSuggestfield-tmpl');
                            
                            $container.html($html);
                            $container.find("input[type='radio'], input[type='checkbox'], select").on("change", function(){
                                that.changeEditContentPanel(this);
                            })
                            //局部刷新的添加字段和删除
                            $container.find("button[id='addRefreshField']").off("click").on("click", function(event){
                                $(event.currentTarget.parentElement).append(h);
                                $container.find("button[id='delRefreshField']").on("click", function(event){
                                    $(event.currentTarget.parentElement).remove();
                                    currToEdit.refreshfields.splice($(event.target.parentElement).index()-2,1)
                                })
                            })
                            $container.find("button[id='delRefreshField']").off("click").on("click", function(event){
                                $(event.currentTarget.parentElement).remove();
                                currToEdit.refreshfields.splice($(event.target.parentElement).index()-2,1)
                            })
                        });
                        break;
                    case 'button':
                        $.when(api.getTemplete('editButton-tmpl'), api.getJSON()).done((tml, json) => {
                            let config=json[0];
                            config.actTypeOption.forEach((val)=>{
                                if(val.value==currToEdit.getProp('acttype')){
                                    val.select="true";
                                }
                            })
                            // config.actTypeOption[currToEdit.getProp('acttype')]="true";

                            let baseData={
                                name:currToEdit.getProp('name'),
                                value:currToEdit.getProp('value'),
                                refreshonchanged:currToEdit.getProp('refreshonchanged'),
                                calculateonrefresh:currToEdit.getProp('calculateonrefresh'),
                                refreshmode:currToEdit.getProp('refreshmode'),
                                isLimited:false,
                                hiddenscript:currToEdit.getProp("hiddenscript"),
                                hiddenvalue:currToEdit.getProp("hiddenvalue"),
                                hiddenprintscript:currToEdit.getProp("hiddenprintscript"),
                                printhiddenvalue:currToEdit.getProp("printhiddenvalue"),
                                readonlyscript:currToEdit.getProp("readonlyscript"),
                                isdefaultvalue:currToEdit.getProp("isdefaultvalue"),
                                allName:allNameNow,
                                allNameinSelf:form.allName,
                                refreshfields:currToEdit.getProp("refreshfields"),
                                isshowlabel:currToEdit.getProp("isshowlabel"),
                                labelvalue:currToEdit.getProp("labelvalue"),
                                acttype:currToEdit.getProp("acttype"),
                                beforeactionscript:currToEdit.getProp("beforeactionscript"),
                                afteractionscript:currToEdit.getProp("afteractionscript"),
                                statetoshow:currToEdit.getProp("statetoshow"),
                                filenamescript:currToEdit.getProp("filenamescript"),
                            }
                            let buttonData=$.extend({}, config, baseData);

                            $html =  Helper.getInstance().handleTemplete(tml[0], buttonData,'editButton-tmpl');
                            
                            $container.html($html);

                            $container.find("input[type='radio'], input[type='checkbox'], select").on("change", function(){
                                that.changeEditContentPanel(this);
                            })
                            
                            
                            //局部刷新的添加字段和删除
                            $container.find("button[id='addRefreshField']").on("click", function(event){
                                $(event.currentTarget.parentElement).append(h);
                                $container.find("button[id='delRefreshField']").on("click", function(event){
                                    $(event.currentTarget.parentElement).remove();
                                    currToEdit.refreshfields.splice($(event.target.parentElement).index()-2,1)
                                })

                            })
                            $container.find("button[id='delRefreshField']").on("click", function(event){
                                $(event.currentTarget.parentElement).remove();
                                currToEdit.refreshfields.splice($(event.target.parentElement).index()-2,1)
                            })
                            
                        });
                    break;
                    case 'viewdialogfield':
                        $.when(api.getTemplete('editViewdialogfield-tmpl'), api.getJSON(),api.getModules(form.applicationId)).done((tml, json,data) => {
                            let config=json[0];
                            let addMap=`<div style="display:flex;">
                                从
                                <select id='colname' name="colname" class="form-control"  style="width:100px">`
                                    
                                config.colnameOption.forEach((val)=>{
                                    addMap+=`<option value=${val.value}>${val.name}</option>`
                                })
                                addMap+=`</select>
                                至
                                <select id='fldname' name="fldname" class="form-control"  style="width:140px">`
                                form.allName.forEach((val)=>{
                                    addMap+=`<option value=${val.name}>${val.name}</option>`
                                })
                                addMap+=`</select>
                                <button class="btn btn-primary d-block" id="delmapping">删除</button>
                            </div>`;
                            let modules=[];
                            for(let key in data[0].data){
                                let obj={name:data[0].data[key],value:key,select:false};
                                if(key==currToEdit.getProp("module"))obj.select=true;
                                modules.push(obj);
                            }
                            let views=[{name:"选择",value:"",select:false}];
                            if(currToEdit.getProp("module")!=""){
                                let data = api.getModuleViews(currToEdit.getProp("module")).responseJSON.data.datas
                                data.forEach(el=>{
                                    let obj={name:el.name,value:el.id,select:false};
                                    if(el.id==currToEdit.getProp("dialogview"))obj.select=true;
                                    views.push(obj);
                                })
                            }
                            config.maximizationOption.forEach((val)=>{
                                if(val.value==currToEdit.getProp('maximization')){
                                    val.select="true";
                                }
                            })
                            let baseData={
                                name:currToEdit.getProp('name'),
                                value:currToEdit.getProp('value'),
                                refreshonchanged:currToEdit.getProp('refreshonchanged'),
                                calculateonrefresh:currToEdit.getProp('calculateonrefresh'),
                                mobile:currToEdit.getProp('mobile'),
                                refreshmode:currToEdit.getProp('refreshmode'),
                                isLimited:false,
                                hiddenscript:currToEdit.getProp("hiddenscript"),
                                hiddenvalue:currToEdit.getProp("hiddenvalue"),
                                hiddenprintscript:currToEdit.getProp("hiddenprintscript"),
                                printhiddenvalue:currToEdit.getProp("printhiddenvalue"),
                                readonlyscript:currToEdit.getProp("readonlyscript"),
                                allName:form.allName,
                                refreshfields:currToEdit.getProp("refreshfields"),
                                isshowlabel:currToEdit.getProp("isshowlabel"),
                                labelvalue:currToEdit.getProp("labelvalue"),
                                caption:currToEdit.getProp("caption"),
                                opentype:currToEdit.getProp("opentype"),
                                selectone:currToEdit.getProp("selectone"),
                                mutilselect:currToEdit.getProp("mutilselect"),
                                allowviewdoc:currToEdit.getProp("allowviewdoc"),
                                mapping:currToEdit.getProp("mapping"),
                                okscript:currToEdit.getProp("okscript"),
                                callbackscript:currToEdit.getProp("callbackscript"),
                                divheight:currToEdit.getProp("divheight"),
                                divwidth:currToEdit.getProp("divwidth"),
                                modules:modules,
                                views:views

                            }
                            let viewdialogfieldData=$.extend({}, config, baseData);

                            $html =  Helper.getInstance().handleTemplete(tml[0], viewdialogfieldData,'editViewdialogfield-tmpl');
                            
                            $container.html($html);

                            $container.find("input[type='radio'], input[type='checkbox'], select").on("change", function(){
                                that.changeEditContentPanel(this);
                            })
                            //局部刷新的添加字段和删除
                            $container.find("button[id='addRefreshField']").on("click", function(event){
                                $(event.currentTarget.parentElement).append(h);
                                $container.find("button[id='delRefreshField']").on("click", function(event){
                                    $(event.currentTarget.parentElement).remove();
                                    currToEdit.refreshfields.splice($(event.target.parentElement).index()-2,1)
                                })

                            })
                            $container.find("button[id='delRefreshField']").on("click", function(event){
                                $(event.currentTarget.parentElement).remove();
                                currToEdit.refreshfields.splice($(event.target.parentElement).index()-2,1)
                            })
                            //映射的添加字段和删除
                            $container.find("button[id='addmapping']").on("click", function(event){
                                $(event.currentTarget.parentElement).append(addMap);
                                $container.find("button[id='delmapping']").on("click", function(event){
                                    $(event.currentTarget.parentElement).remove();
                                    currToEdit.mapping.splice($(event.target.parentElement).index()-3,1)
                                })

                            })
                            $container.find("button[id='delmapping']").on("click", function(event){
                                $(event.currentTarget.parentElement).remove();
                                currToEdit.mapping.splice($(event.target.parentElement).index()-3,1)
                            })
                            
                        });
                        break;
                    case 'tabfield':
                        $.when(api.getTemplete('editTabfield-tmpl'), api.getJSON(),api.getModules(form.applicationId)).done((tml, json,data) => {
                            let config=json[0];
                            config.showmodes.forEach((val)=>{
                                if(val.value==currToEdit.getProp('showmode')){
                                    val.select="true";
                                }
                            })
                            let modules=[];
                            for(let key in data[0].data){
                                let obj={name:data[0].data[key],value:key,select:false};
                                modules.push(obj);
                            }
                            let arr=[...currToEdit.getProp("relstr")]
                            let num=0;
                            for(let rel=0;rel<arr.length;rel++){
                                if(arr[rel].name==""){
                                    currToEdit.getProp("relstr").splice(rel-num,1)
                                    num++;
                                }
                            }
                            currToEdit.getProp("relstr").forEach(elm=>{
                                if(elm.moduleId!=""){
                                    let data;
                                    if(elm.type==2){
                                        data = api.getModuleForms(elm.moduleId,elm.type).responseJSON.data.datas;
                                    }else{
                                        data = api.getModuleViews(elm.moduleId).responseJSON.data.datas;
                                    }
                                    // let data = api.getModuleViews(elm.moduleId).responseJSON.data.datas;
                                    elm.formIds=[{name:"选择",value:"",select:false}];
                                    data.forEach(el=>{
                                        let obj={name:el.name,value:el.id,select:false};
                                        if(el.id==elm.formId)obj.select=true;
                                        elm.formIds.push(obj);
                                    })
                                }
                            })
                            let baseData={
                                name:currToEdit.getProp('name'),
                                value:currToEdit.getProp('value'),
                                isshowlabel:currToEdit.getProp("isshowlabel"),
                                labelvalue:currToEdit.getProp("labelvalue"),
                                showmode:currToEdit.getProp("showmode"),
                                allowsamename:currToEdit.getProp("allowsamename"),
                                relstr:currToEdit.getProp("relstr"),
                                selectedscript:currToEdit.getProp("selectedscript"),
                                modules:modules,
                            }
                            let tabfieldData=$.extend({}, config, baseData);

                            $html =  Helper.getInstance().handleTemplete(tml[0], tabfieldData,'editTabfield-tmpl');
                            
                            $container.html($html);
                            $container.find("button[id='addTabfield']").on("click", function(event){
                                let relstrLength=currToEdit.relstr.length;
                                let tabfieldCon=`<div class="input-group">
                                    <input type='text' name="name" id="name${relstrLength}" class="form-control d-block widthAuto"   />
                                    <select id='type${relstrLength}' name="type" class="form-control">`
                                    
                                    for(let a=0;a<config.tabfieldtype.length;a++){
                                        tabfieldCon+=`<option value=${config.tabfieldtype[a].value}>${config.tabfieldtype[a].name}</option>`
                                    } 
                                    tabfieldCon+= `</select>
                                    <select id='moduleId${relstrLength}' name="module" class="form-control">`
                                    for(let b=0;b<modules.length;b++){
                                        tabfieldCon+=`<option value=${modules[b].value}>${modules[b].name}</option>`
                                    } 
                                    tabfieldCon+=`</select>	
                                    <select id='formId${relstrLength}' name="formId" class="form-control"><option value>选择</option>`
                                    // for(let c=0;c<config.tabfieldtest.length;c++){
                                    //     tabfieldCon+=`<option value=${config.tabfieldtest[c].value}>${config.tabfieldtest[c].name}</option>`
                                    // } 
                                    tabfieldCon+=`</select>
                                    <input type="checkbox" style="height:34px;" name="calculateOnRefresh" id="calculateOnRefresh${relstrLength}" class="checkbox" checked/>
                                    <input type="checkbox" style="height:34px;" name="relate" id="relate${relstrLength}" class="checkbox"  />
                                    <textarea id="hiddenScript${relstrLength}" style="height:34px;" name="hiddenScript"></textarea>
                                    <textarea id="readOnlyScript${relstrLength}" style="height:34px;" name="readOnlyScript"></textarea>
                                    <textarea id="hiddenPrintScript${relstrLength}" style="height:34px;" name="hiddenPrintScript"></textarea>
                                    <button class="btn btn-primary d-block" id="delTabfield">删除</button>
                                </div>`;
                                $(event.currentTarget).next().append(tabfieldCon);
                                currToEdit.relstr.push({
                                    name:"",
                                    type:2,
                                    moduleId:"",
                                    formId:"",
                                    formIds:[],
                                    hiddenScript:"",
                                    readOnlyScript:"",
                                    hiddenPrintScript:"",
                                    refreshOnChanged:false,
                                    calculateOnRefresh:false,
                                    relate:false,
                                })
                                $container.find("button[id='delTabfield']").on("click", function(event){
                                    $(event.currentTarget.parentElement).remove();
                                    currToEdit.relstr.splice($(event.target.parentElement).index()-1,1)
                                })

                            })
                            $container.find("button[id='delTabfield']").on("click", function(event){
                                $(event.currentTarget.parentElement).remove();
                                currToEdit.relstr.splice($(event.target.parentElement).index()-1,1)
                            })
                        });
                        break;
                    case 'calctextfield':
                        $.when(api.getTemplete('editCalctextfield-tmpl'), api.getJSON()).done((tml, json) => {
                            
                            let baseData={
                                name:currToEdit.getProp('name'),
                                value:currToEdit.getProp('value'),
                                isshowlabel:currToEdit.getProp("isshowlabel"),
                                labelvalue:currToEdit.getProp("labelvalue"),
                                calculateonrefresh:currToEdit.getProp("calculateonrefresh"),
                                valuescript:currToEdit.getProp("valuescript"),

                            }
                            let calctextfieldData=$.extend({}, baseData);

                            $html =  Helper.getInstance().handleTemplete(tml[0], calctextfieldData,'editCalctextfield-tmpl');
                            
                            $container.html($html);
                        });
                        break;
                    case 'includefield':
                        $.when(api.getTemplete('editIncludefield-tmpl'), api.getJSON(),api.getModules(form.applicationId)).done((tml, json,data) => {
                            let config=json[0];
                            config.includetypes.forEach((val)=>{
                                if(val.value==currToEdit.getProp('includetype')){
                                    val.select="true";
                                }
                            })
                            let include_modules=[];
                            for(let key in data[0].data){
                                let obj={name:data[0].data[key],value:key,select:false};
                                if(key==currToEdit.getProp("module"))obj.select=true;
                                include_modules.push(obj);
                            }
                            let include_views=[{name:"选择",value:"",select:false}];
                            if(currToEdit.getProp("module")!=""){
                                let data = api.getModuleViews(currToEdit.getProp("module")).responseJSON.data.datas
                                data.forEach(el=>{
                                    let obj={name:el.name,value:el.id,select:false};
                                    if(el.id==currToEdit.getProp("dialogview"))obj.select=true;
                                    include_views.push(obj);
                                })
                            }
                            let baseData={
                                name:currToEdit.getProp('name'),
                                value:currToEdit.getProp('value'),
                                valuescript:currToEdit.getProp('valuescript'),
                                refreshonchanged:currToEdit.getProp('refreshonchanged'),
                                calculateonrefresh:currToEdit.getProp('calculateonrefresh'),
                                refreshmode:currToEdit.getProp('refreshmode'),
                                isLimited:false,
                                hiddenscript:currToEdit.getProp("hiddenscript"),
                                hiddenvalue:currToEdit.getProp("hiddenvalue"),
                                hiddenprintscript:currToEdit.getProp("hiddenprintscript"),
                                printhiddenvalue:currToEdit.getProp("printhiddenvalue"),
                                isdefaultvalue:currToEdit.getProp("isdefaultvalue"),
                                allName:allNameNow,
                                allNameinSelf:form.allName,
                                processdescription:currToEdit.getProp("processdescription")=="[];[]"?"":currToEdit.getProp("processdescription"),
                                refreshfields:currToEdit.getProp("refreshfields"),
                                isshowlabel:currToEdit.getProp("isshowlabel"),
                                labelvalue:currToEdit.getProp("labelvalue"),
                                relate:currToEdit.getProp("relate"),
                                fixation:currToEdit.getProp("fixation"),
                                fixationheight:currToEdit.getProp("fixationheight"),
                                editmode:currToEdit.getProp("editmode"),
                                modules:include_modules,
                                views:include_views,
                            }
                            let includefieldData=$.extend({}, config, baseData);

                            $html =  Helper.getInstance().handleTemplete(tml[0], includefieldData,'editIncludefield-tmpl');
                            
                            $container.html($html);

                            $container.find("input[type='radio'], input[type='checkbox'], select").on("change", function(){
                                that.changeEditContentPanel(this);
                            })
                            //局部刷新的添加字段和删除
                            $container.find("button[id='addRefreshField']").on("click", function(event){
                                $(event.currentTarget.parentElement).append(h);
                                $container.find("button[id='delRefreshField']").on("click", function(event){
                                    $(event.currentTarget.parentElement).remove();
                                    currToEdit.refreshfields.splice($(event.target.parentElement).index()-2,1)
                                })

                            })
                            $container.find("button[id='delRefreshField']").on("click", function(event){
                                $(event.currentTarget.parentElement).remove();
                                currToEdit.refreshfields.splice($(event.target.parentElement).index()-2,1)
                            })
                            
                        });
                        break;
                    case 'surveyfield':
                        $.when(api.getTemplete('editSurveyfield-tmpl'), api.getJSON()).done((tml, json) => {
                            let config=json[0];
                            
                            let baseData={
                                name:currToEdit.getProp('name'),
                                value:currToEdit.getProp('value'),
                                calculateonrefresh:currToEdit.getProp('calculateonrefresh'),
                                hiddenscript:currToEdit.getProp("hiddenscript"),
                                hiddenvalue:currToEdit.getProp("hiddenvalue"),
                                hiddenprintscript:currToEdit.getProp("hiddenprintscript"),
                                printhiddenvalue:currToEdit.getProp("printhiddenvalue"),
                                isshowlabel:currToEdit.getProp("isshowlabel"),
                                labelvalue:currToEdit.getProp("labelvalue"),

                                mobile:currToEdit.getProp("mobile"),
                                discript:currToEdit.getProp("discript"),
                                questionscript:currToEdit.getProp("questionscript"),
                                readonlyscript:currToEdit.getProp("readonlyscript"),
                            }
                            let surveyfieldData=$.extend({}, config, baseData);

                            $html =  Helper.getInstance().handleTemplete(tml[0], surveyfieldData,'editSurveyfield-tmpl');
                            
                            $container.html($html);

                            $container.find("input[type='radio'], input[type='checkbox'], select").on("change", function(){
                                that.changeEditContentPanel(this);
                            })
                            
                            
                        });
                        break;
                    case 'attachment':
                        $.when(api.getTemplete('editAttachment-tmpl'), api.getJSON()).done((tml, json) => {
                            let config=json[0];
                            
                            config.validatelibsOption.forEach((val)=>{
                                if(val.value==currToEdit.getProp('validatelibs')){
                                    val.select="true";
                                }
                            })
                            
                            let baseData={
                                name:currToEdit.getProp('name'),
                                value:currToEdit.getProp('value'),
                                valuescript:currToEdit.getProp('valuescript'),

                                readonlyshowvalonly:currToEdit.getProp('readonlyshowvalonly'),
                                refreshonchanged:currToEdit.getProp('refreshonchanged'),
                                calculateonrefresh:currToEdit.getProp('calculateonrefresh'),
                                mobile:currToEdit.getProp('mobile'),
                                discript:currToEdit.getProp('discript'),
                                refreshmode:currToEdit.getProp('refreshmode'),
                                isLimited:false,
                                validatelibs:currToEdit.getProp("validatelibs"),
                                validaterule:currToEdit.getProp("validaterule"),
                                hiddenscript:currToEdit.getProp("hiddenscript"),
                                hiddenvalue:currToEdit.getProp("hiddenvalue"),
                                hiddenprintscript:currToEdit.getProp("hiddenprintscript"),
                                printhiddenvalue:currToEdit.getProp("printhiddenvalue"),
                                readonlyscript:currToEdit.getProp("readonlyscript"),
                                allName:allNameNow,
                                allNameinSelf:form.allName,
                                refreshfields:currToEdit.getProp("refreshfields"),
                                isshowlabel:currToEdit.getProp("isshowlabel"),
                                labelvalue:currToEdit.getProp("labelvalue"),
                                instantvalidate:currToEdit.getProp("instantvalidate"),
                                filetype:currToEdit.getProp("filetype"),
                                customizetype:currToEdit.getProp("customizetype"),
                                limitsize:currToEdit.getProp("limitsize"),
                                limitnumber:currToEdit.getProp("limitnumber"),
                                filepattern:currToEdit.getProp("filepattern"),
                                filecatalog:currToEdit.getProp("filecatalog"),
                                previewedit:currToEdit.getProp("previewedit"),
                                openwatermark:currToEdit.getProp("openwatermark"),
                                supportsorting:currToEdit.getProp("supportsorting"),
                                watermarksupportmode:currToEdit.getProp("watermarksupportmode"),
                                watermarkscript:currToEdit.getProp("watermarkscript"),
                            }
                            let attachmentData=$.extend({}, config, baseData);

                            $html =  Helper.getInstance().handleTemplete(tml[0], attachmentData,'editAttachment-tmpl');
                            
                            $container.html($html);

                            $container.find("input[type='radio'], input[type='checkbox'], select").on("change", function(){
                                that.changeEditContentPanel(this);
                            })
                            //局部刷新的添加字段和删除
                            $container.find("button[id='addRefreshField']").on("click", function(event){
                                $(event.currentTarget.parentElement).append(h);
                                $container.find("button[id='delRefreshField']").on("click", function(event){
                                    $(event.currentTarget.parentElement).remove();
                                    currToEdit.refreshfields.splice($(event.target.parentElement).index()-2,1)
                                })

                            })
                            $container.find("button[id='delRefreshField']").on("click", function(event){
                                $(event.currentTarget.parentElement).remove();
                                currToEdit.refreshfields.splice($(event.target.parentElement).index()-2,1)
                            })
                            
                        });
                        break;
                    case 'imageuploadfield':
                        $.when(api.getTemplete('editImageuploadfield-tmpl'), api.getJSON()).done((tml, json) => {
                            let config=json[0];
                            
                            let baseData={
                                name:currToEdit.getProp('name'),
                                value:currToEdit.getProp('value'),
                                valuescript:currToEdit.getProp('valuescript'),

                                readonlyshowvalonly:currToEdit.getProp('readonlyshowvalonly'),
                                refreshonchanged:currToEdit.getProp('refreshonchanged'),
                                calculateonrefresh:currToEdit.getProp('calculateonrefresh'),
                                mobile:currToEdit.getProp('mobile'),
                                discript:currToEdit.getProp('discript'),
                                refreshmode:currToEdit.getProp('refreshmode'),
                                isLimited:false,
                                hiddenscript:currToEdit.getProp("hiddenscript"),
                                hiddenvalue:currToEdit.getProp("hiddenvalue"),
                                hiddenprintscript:currToEdit.getProp("hiddenprintscript"),
                                printhiddenvalue:currToEdit.getProp("printhiddenvalue"),
                                readonlyscript:currToEdit.getProp("readonlyscript"),
                                allName:allNameNow,
                                allNameinSelf:form.allName,
                                refreshfields:currToEdit.getProp("refreshfields"),
                                isshowlabel:currToEdit.getProp("isshowlabel"),
                                labelvalue:currToEdit.getProp("labelvalue"),
                                limitsize:currToEdit.getProp("limitsize"),
                                limitnumber:currToEdit.getProp("limitnumber"),
                                filepattern:currToEdit.getProp("filepattern"),
                                filecatalog:currToEdit.getProp("filecatalog"),
                                imgh:currToEdit.getProp("imgh"),
                                imgw:currToEdit.getProp("imgw"),
                                
                            }
                            let imageuploadfieldData=$.extend({}, config, baseData);

                            $html =  Helper.getInstance().handleTemplete(tml[0], imageuploadfieldData,'editImageuploadfield-tmpl');
                            
                            $container.html($html);

                            $container.find("input[type='radio'], input[type='checkbox'], select").on("change", function(){
                                that.changeEditContentPanel(this);
                            })
                            //局部刷新的添加字段和删除
                            $container.find("button[id='addRefreshField']").on("click", function(event){
                                $(event.currentTarget.parentElement).append(h);
                                $container.find("button[id='delRefreshField']").on("click", function(event){
                                    $(event.currentTarget.parentElement).remove();
                                    currToEdit.refreshfields.splice($(event.target.parentElement).index()-2,1)
                                })

                            })
                            $container.find("button[id='delRefreshField']").on("click", function(event){
                                $(event.currentTarget.parentElement).remove();
                                currToEdit.refreshfields.splice($(event.target.parentElement).index()-2,1)
                            })
                            
                        });
                        break;
                    case 'onlinetakephotofield':
                        $.when(api.getTemplete('editOnlinetakephotofield-tmpl'), api.getJSON()).done((tml, json) => {
                            let config=json[0];
                            
                            let baseData={
                                name:currToEdit.getProp('name'),
                                value:currToEdit.getProp('value'),
                                valuescript:currToEdit.getProp('valuescript'),
                                calculateonrefresh:currToEdit.getProp('calculateonrefresh'),
                                discript:currToEdit.getProp('discript'),
                                isLimited:false,
                                hiddenscript:currToEdit.getProp("hiddenscript"),
                                hiddenvalue:currToEdit.getProp("hiddenvalue"),
                                hiddenprintscript:currToEdit.getProp("hiddenprintscript"),
                                printhiddenvalue:currToEdit.getProp("printhiddenvalue"),
                                readonlyscript:currToEdit.getProp("readonlyscript"),
                                allName:allNameNow,
                                allNameinSelf:form.allName,
                                isshowlabel:currToEdit.getProp("isshowlabel"),
                                labelvalue:currToEdit.getProp("labelvalue"),
                                imgh:currToEdit.getProp("imgh"),
                                imgw:currToEdit.getProp("imgw"),
                                album:currToEdit.getProp("album"),
                            }
                            let onlinetakephotofieldData=$.extend({}, config, baseData);

                            $html =  Helper.getInstance().handleTemplete(tml[0], onlinetakephotofieldData,'editOnlinetakephotofield-tmpl');
                            
                            $container.html($html);

                            $container.find("input[type='radio'], input[type='checkbox'], select").on("change", function(){
                                that.changeEditContentPanel(this);
                            })
                           
                            
                        });
                        break;
                    case 'weixingpsfield':
                        $.when(api.getTemplete('editWeixingpsfield-tmpl'), api.getJSON()).done((tml, json) => {
                            let config=json[0];
                            
                            let baseData={
                                name:currToEdit.getProp('name'),
                                value:currToEdit.getProp('value'),
                                discript:currToEdit.getProp('discript'),
                                isLimited:false,
                                hiddenscript:currToEdit.getProp("hiddenscript"),
                                hiddenvalue:currToEdit.getProp("hiddenvalue"),
                                hiddenprintscript:currToEdit.getProp("hiddenprintscript"),
                                printhiddenvalue:currToEdit.getProp("printhiddenvalue"),
                                isshowlabel:currToEdit.getProp("isshowlabel"),
                                labelvalue:currToEdit.getProp("labelvalue"),
                                refreshonchanged:currToEdit.getProp("refreshonchanged")
                            }
                            let weixingpsfieldData=$.extend({}, config, baseData);

                            $html =  Helper.getInstance().handleTemplete(tml[0], weixingpsfieldData,'editWeixingpsfield-tmpl');
                            
                            $container.html($html);

                            $container.find("input[type='radio'], input[type='checkbox'], select").on("change", function(){
                                that.changeEditContentPanel(this);
                            })
                            
                            
                        });
                        break;
                    case 'weixinrecordfield':
                        $.when(api.getTemplete('editWeixinrecordfield-tmpl'), api.getJSON()).done((tml, json) => {
                            let config=json[0];
                            
                            let baseData={
                                name:currToEdit.getProp('name'),
                                value:currToEdit.getProp('value'),
                                discript:currToEdit.getProp('discript'),
                                isLimited:false,
                                hiddenscript:currToEdit.getProp("hiddenscript"),
                                hiddenvalue:currToEdit.getProp("hiddenvalue"),
                                hiddenprintscript:currToEdit.getProp("hiddenprintscript"),
                                printhiddenvalue:currToEdit.getProp("printhiddenvalue"),
                                isshowlabel:currToEdit.getProp("isshowlabel"),
                                labelvalue:currToEdit.getProp("labelvalue"),
                                mobile:currToEdit.getProp("mobile"),
                                readonlyscript:currToEdit.getProp("readonlyscript")
                            }
                            let weixinrecordfieldData=$.extend({}, config, baseData);

                            $html =  Helper.getInstance().handleTemplete(tml[0], weixinrecordfieldData,'editWeixinrecordfield-tmpl');
                            
                            $container.html($html);

                            $container.find("input[type='radio'], input[type='checkbox'], select").on("change", function(){
                                that.changeEditContentPanel(this);
                            })
                            
                            
                        });
                        break;
                    case 'qrcodefield':
                        $.when(api.getTemplete('editQrcodefield-tmpl'), api.getJSON()).done((tml, json) => {
                            let config=json[0];
                            
                            let baseData={
                                name:currToEdit.getProp('name'),
                                value:currToEdit.getProp('value'),
                                discript:currToEdit.getProp('discript'),
                                isLimited:false,
                                hiddenscript:currToEdit.getProp("hiddenscript"),
                                hiddenvalue:currToEdit.getProp("hiddenvalue"),
                                hiddenprintscript:currToEdit.getProp("hiddenprintscript"),
                                printhiddenvalue:currToEdit.getProp("printhiddenvalue"),
                                isshowlabel:currToEdit.getProp("isshowlabel"),
                                labelvalue:currToEdit.getProp("labelvalue"),
                                mobile:currToEdit.getProp("mobile"),
                                readonlyscript:currToEdit.getProp("readonlyscript"),
                                valuescript:currToEdit.getProp("valuescript"),
                                calculateonrefresh:currToEdit.getProp("calculateonrefresh"),
                                size:currToEdit.getProp("size"),
                                handletype:currToEdit.getProp("handletype"),

                            }
                            let qrcodefieldData=$.extend({}, config, baseData);

                            $html =  Helper.getInstance().handleTemplete(tml[0], qrcodefieldData,'editQrcodefield-tmpl');
                            
                            $container.html($html);

                            $container.find("input[type='radio'], input[type='checkbox'], select").on("change", function(){
                                that.changeEditContentPanel(this);
                            })
                            
                            
                        });
                        break;
                    case 'mapfield':
                        $.when(api.getTemplete('editMapfield-tmpl'), api.getJSON()).done((tml, json) => {
                            let config=json[0];
                            config.maptypes.forEach((val)=>{
                                if(val.value==currToEdit.getProp('maptype')){
                                    val.select="true";
                                }
                            })
                            config.opentypes.forEach((val)=>{
                                if(val.value==currToEdit.getProp('opentype')){
                                    val.select="true";
                                }
                            })
                            let baseData={
                                name:currToEdit.getProp('name'),
                                value:currToEdit.getProp('value'),
                                discript:currToEdit.getProp('discript'),
                                isLimited:false,
                                hiddenscript:currToEdit.getProp("hiddenscript"),
                                hiddenvalue:currToEdit.getProp("hiddenvalue"),
                                hiddenprintscript:currToEdit.getProp("hiddenprintscript"),
                                printhiddenvalue:currToEdit.getProp("printhiddenvalue"),
                                isshowlabel:currToEdit.getProp("isshowlabel"),
                                labelvalue:currToEdit.getProp("labelvalue"),
                                calculateonrefresh:currToEdit.getProp("calculateonrefresh")
                            }
                            let mapfieldData=$.extend({}, config, baseData);

                            $html =  Helper.getInstance().handleTemplete(tml[0], mapfieldData,'editMapfield-tmpl');
                            
                            $container.html($html);

                            $container.find("input[type='radio'], input[type='checkbox'], select").on("change", function(){
                                that.changeEditContentPanel(this);
                            })
                            
                            
                        });
                        break;
                    case 'genericwordfield':
                        $.when(api.getTemplete('editGenericwordfield-tmpl'), api.getJSON()).done((tml, json) => {
                            let config=json[0];
                            config.wordopentypes.forEach((val)=>{
                                if(val.value==currToEdit.getProp('opentype')){
                                    val.select="true";
                                }
                            })
                            let baseData={
                                name:currToEdit.getProp('name'),
                                value:currToEdit.getProp('value'),
                                discript:currToEdit.getProp('discript'),
                                isLimited:false,
                                hiddenscript:currToEdit.getProp("hiddenscript"),
                                hiddenvalue:currToEdit.getProp("hiddenvalue"),
                                hiddenprintscript:currToEdit.getProp("hiddenprintscript"),
                                printhiddenvalue:currToEdit.getProp("printhiddenvalue"),
                                isshowlabel:currToEdit.getProp("isshowlabel"),
                                labelvalue:currToEdit.getProp("labelvalue"),
                                calculateonrefresh:currToEdit.getProp("calculateonrefresh"),
                                readonlyscript:currToEdit.getProp("readonlyscript")
                            }
                            let genericwordfieldData=$.extend({}, config, baseData);

                            $html =  Helper.getInstance().handleTemplete(tml[0], genericwordfieldData,'editGenericwordfield-tmpl');
                            
                            $container.html($html);

                            $container.find("input[type='radio'], input[type='checkbox'], select").on("change", function(){
                                that.changeEditContentPanel(this);
                            })
                            
                            
                        });
                        break;
                    case 'htmleditorfield':
                        $.when(api.getTemplete('editHtmleditorfield-tmpl'), api.getJSON()).done((tml, json) => {
                            let config=json[0];
                            
                            let baseData={
                                name:currToEdit.getProp('name'),
                                value:currToEdit.getProp('value'),
                                discript:currToEdit.getProp('discript'),
                                isLimited:false,
                                hiddenscript:currToEdit.getProp("hiddenscript"),
                                hiddenvalue:currToEdit.getProp("hiddenvalue"),
                                hiddenprintscript:currToEdit.getProp("hiddenprintscript"),
                                printhiddenvalue:currToEdit.getProp("printhiddenvalue"),
                                isshowlabel:currToEdit.getProp("isshowlabel"),
                                labelvalue:currToEdit.getProp("labelvalue"),
                                calculateonrefresh:currToEdit.getProp("calculateonrefresh"),
                                readonlyscript:currToEdit.getProp("readonlyscript"),
                                mobile:currToEdit.getProp("mobile"),
                                areawidth:currToEdit.getProp("areawidth"),
                                areaheight:currToEdit.getProp("areaheight"),

                                editmode:currToEdit.getProp("editmode"),
                                processdescription:currToEdit.getProp("processdescription"),
                                valuescript:currToEdit.getProp("valuescript"),
                                isdefaultvalue:currToEdit.getProp("isdefaultvalue"),

                            }
                            let htmleditorfieldData=$.extend({}, config, baseData);

                            $html =  Helper.getInstance().handleTemplete(tml[0], htmleditorfieldData,'editHtmleditorfield-tmpl');
                            
                            $container.html($html);

                            $container.find("input[type='radio'], input[type='checkbox'], select").on("change", function(){
                                that.changeEditContentPanel(this);
                            })
                            
                            
                        });
                        break;
                    case 'flowhistoryfield':
                        $.when(api.getTemplete('editFlowhistoryfield-tmpl'), api.getJSON()).done((tml, json) => {
                            let config=json[0];
                            
                            let baseData={
                                name:currToEdit.getProp('name'),
                                value:currToEdit.getProp('value'),
                                discript:currToEdit.getProp('discript'),
                                isLimited:false,
                                hiddenscript:currToEdit.getProp("hiddenscript"),
                                hiddenvalue:currToEdit.getProp("hiddenvalue"),
                                hiddenprintscript:currToEdit.getProp("hiddenprintscript"),
                                printhiddenvalue:currToEdit.getProp("printhiddenvalue"),
                                isshowlabel:currToEdit.getProp("isshowlabel"),
                                labelvalue:currToEdit.getProp("labelvalue"),
                                mobile:currToEdit.getProp("mobile"),
                                showmode:currToEdit.getProp("showmode"),

                            }
                            let flowhistoryfieldData=$.extend({}, config, baseData);

                            $html =  Helper.getInstance().handleTemplete(tml[0], flowhistoryfieldData,'editFlowhistoryfield-tmpl');
                            
                            $container.html($html);

                            $container.find("input[type='radio'], input[type='checkbox'], select").on("change", function(){
                                that.changeEditContentPanel(this);
                            })
                            
                        });
                        break;
                    case 'flowreminderhistoryfield':
                        $.when(api.getTemplete('editFlowreminderhistoryfield-tmpl'), api.getJSON()).done((tml, json) => {
                            let config=json[0];
                            
                            let baseData={
                                name:currToEdit.getProp('name'),
                                value:currToEdit.getProp('value'),
                                discript:currToEdit.getProp('discript'),
                                isLimited:false,
                                hiddenscript:currToEdit.getProp("hiddenscript"),
                                hiddenvalue:currToEdit.getProp("hiddenvalue"),
                                hiddenprintscript:currToEdit.getProp("hiddenprintscript"),
                                printhiddenvalue:currToEdit.getProp("printhiddenvalue"),
                                isshowlabel:currToEdit.getProp("isshowlabel"),
                                labelvalue:currToEdit.getProp("labelvalue"),
                            }
                            let flowreminderhistoryfieldData=$.extend({}, config, baseData);

                            $html =  Helper.getInstance().handleTemplete(tml[0], flowreminderhistoryfieldData,'editFlowreminderhistoryfield-tmpl');
                            
                            $container.html($html);

                            $container.find("input[type='radio'], input[type='checkbox'], select").on("change", function(){
                                that.changeEditContentPanel(this);
                            })
                            
                            
                        });
                        break;
                    case 'informationfeedbackfield':
                        $.when(api.getTemplete('editInformationfeedbackfield-tmpl'), api.getJSON()).done((tml, json) => {
                            let config=json[0];
                            
                            let baseData={
                                name:currToEdit.getProp('name'),
                                value:currToEdit.getProp('value'),
                                discript:currToEdit.getProp('discript'),
                                isLimited:false,
                                hiddenscript:currToEdit.getProp("hiddenscript"),
                                hiddenvalue:currToEdit.getProp("hiddenvalue"),
                                hiddenprintscript:currToEdit.getProp("hiddenprintscript"),
                                printhiddenvalue:currToEdit.getProp("printhiddenvalue"),
                                isshowlabel:currToEdit.getProp("isshowlabel"),
                                labelvalue:currToEdit.getProp("labelvalue"),
                                areawidth:currToEdit.getProp("areawidth"),
                                areaheight:currToEdit.getProp("areaheight"),
                            }
                            let informationfeedbackfieldData=$.extend({}, config, baseData);

                            $html =  Helper.getInstance().handleTemplete(tml[0], informationfeedbackfieldData,'editInformationfeedbackfield-tmpl');
                            
                            $container.html($html);

                            $container.find("input[type='radio'], input[type='checkbox'], select").on("change", function(){
                                that.changeEditContentPanel(this);
                            })
                            
                            
                        });
                        break;
                    default:
                        $.when(api.getTemplete('editFormPanel-tmpl'), api.getJSON()).done((tml, json) => {
                            
                            $html =  Helper.getInstance().handleTemplete(tml[0], {},'editFormPanel-tmpl');
                            
                            $container.html($html);
                            
                        });
                    break;
                    

                }
                
            }
            this.registerEvent($container);
        }
		
    }
    changeEditContentPanel(dom){
        var $this = $(dom);
        var name = $this.attr("name");
        var value = $this.val();

        var $panels = $("div[data-componentName='"+name+"']");

        $panels.each(function(){
            var dataValue = $(this).data("value");
            if(typeof dataValue == "boolean"){
                dataValue = dataValue ? "true" : "false";
            }
            if(dataValue == value && $(this).hasClass("d-none")){
                $(this).removeClass("d-none");
            }else{
                $(this).addClass("d-none");
            }
        })
    }
    registerEvent(container){
        const $container = $(container);
        const form = this.form;
		const api = this.api;        
		const currToEdit = form.getCurrToEdit();
        // const tree = Tree.getInstance();
        let need=false;
        $container.off('input change').on('input change', (e) => {
            // 属性面板的文本框事件
            
			const target = $(e.target);
			const key = target.attr('id')?target.attr('id'):target.attr('name');
			const type = target.attr('type');
            let prop = {};
            if(type=='number'){
                prop[key] = parseInt(target.val());
            }else if(type=='checkbox'){
                prop[key] = target.prop('checked');
            }else{
                prop[key] = target.val();
            }
            if(key=="refreshfields"){
                // if(currToEdit.refreshfields.indexOf(target.val())==-1){
                    currToEdit.refreshfields[$(event.target.parentElement).index()-2]=target.val();
                    
                // }

                prop={};
            }else if(key=="labelvalue"){
                let id;
                if(currToEdit)
                id="#"+currToEdit.id;

                console.log($(form.panel).find(id))
                let width=$(form.panel).find(id).width();
                let smallwidth=$(form.panel).find(id).children().eq(1).width();
                let changewidth=currToEdit.smallwidth-smallwidth;
                width+=changewidth;
                if(width && smallwidth){
                    prop.width=width;
                    // prop.smallwidth=smallwidth;
                    need=true;
                }
                
            }else if(key=="isshowlabel"){
                if(target.prop("checked")==false){
                    let id2;
                    if(currToEdit)
                    id2="#"+currToEdit.id;

                    console.log($(form.panel).find(id2))
                    let smallwidth2=$(form.panel).find(id2).children().eq(1).width();
                    if(smallwidth2){
                        prop.width=smallwidth2;
                        prop.smallwidth=smallwidth2;
                        need=true;
                    }
                    
                }
                
            }else if(key=="statetoshows"){
                if($(e.target).prop('checked')){
                    if($(e.target).siblings("input[name='statetoshow']").val()!=""){
                        let arr=$(e.target).siblings("input[name='statetoshow']").val().split(";");
                        let index=-1;
                        arr.forEach((val,ind)=>{
                            if(val==target.val()){
                                index=ind;
                            }
                        })
                        if(index==-1)
                        $(e.target).siblings("input[name='statetoshow']").val(target.val()+";"+$(e.target).siblings("input[name='statetoshow']").val());
                    }else{
                        $(e.target).siblings("input[name='statetoshow']").val(target.val());
                    }
                    // if($(e.target).siblings("input[name='statetoshow']").val().indexOf(target.val())==-1)
                    // $(e.target).siblings("input[name='statetoshow']").val($(e.target).siblings("input[name='statetoshow']").val()+target.val())
                }else{
                    let arr2=$(e.target).siblings("input[name='statetoshow']").val().split(";");
                    let index2=-1;
                    arr2.forEach((val,ind)=>{
                        if(val==target.val()){
                            index2=ind;
                        }
                    })
                    if(index2!=-1)
                    arr2.splice(index2,1)
                    $(e.target).siblings("input[name='statetoshow']").val(arr2.join(";"))
                    // $(e.target).siblings("input[name='statetoshow']").val($(e.target).siblings("input[name='statetoshow']").val().replace(target.val(),""))
                }
            }else if(key=="colname" || key=="fldname"){
                if(target.siblings("select").val()){
                    prop={}
                    prop["mapping"]=[];
                    if(key=="colname"){
                        let a={};
                        a[target.val()]=target.siblings("select").val()
                        prop["mapping"].push(a)

                    }else{
                        let a2={};
                        a2[target.siblings("select").val()]=target.val()
                        prop["mapping"].push(a2)

                    }
                }
            }else if(key=="selectone"){
                if($(e.target).prop('checked'))
                target.parent().next().next().children("input").prop("disabled","disabled")
                else
                target.parent().next().next().children("input").prop("disabled",false)
            }else if(key=="mutilselect"){
                if($(e.target).prop('checked'))
                target.parent().prev().prev().children("input").prop("disabled","disabled")
                else
                target.parent().prev().prev().children("input").prop("disabled",false)
            }else if(key == "watermarksupportmode"){
                // if($(e.target).prop('checked')){
                let watermarksupportmodevalue="";
                for(let b=0;b<$(e.target).parent().parent().children("label").length;b++){
                    if($(e.target).parent().parent().children("label").eq(b).children("input").prop("checked")){
                        if(b!=0){
                            watermarksupportmodevalue+=","
                        }
                        watermarksupportmodevalue+=$(e.target).parent().parent().children("label").eq(b).children("input").val();
                        
                    }
                }
                prop[key]=watermarksupportmodevalue;
            }else if(key.indexOf("module")!=-1){
                if(target.val()!=""){
                    let views=api.getModuleViews(target.val()).responseJSON.data.datas;
                    let h='<option select value>选择</option>';
                    views.forEach(el=>{
                        let add=`<option value="${el.id}">${el.name}</option>`
                        h+=add;
                    })
                    target.parent().next().next().children("select").length>0?target.parent().next().next().children("select").html(h):target.next().html(h)
                }
            }else if(key !== "type"&&key.indexOf("type")!=-1){

            }
            
            
			if(currToEdit != null ) {
                if(currToEdit.scope=="tabfield" && (key.indexOf("name")==0||key.indexOf("type")!=-1||key.indexOf("module")!=-1||key.indexOf("moduleId")!=-1||key.indexOf("formId")!=-1||key.indexOf("hiddenScript")!=-1||key.indexOf("readOnlyScript")!=-1||key.indexOf("hiddenPrintScript")!=-1||key.indexOf("refreshOnChanged")!=-1||key.indexOf("calculateOnRefresh")!=-1||key.indexOf("relate")!=-1)){
                    let relstrInd=parseInt(key.replace(/[a-z|A-Z]*/g,""));
                    let relstrId=key.replace(/[0-9]*/g,"");
                    
                    if(type=="checkbox"){
                        currToEdit.relstr[relstrInd][relstrId]=target.prop('checked');
                    }else{
                        if(key.indexOf("type")!=-1){
                            let data;
                            if(target.val()==2){
                                data = api.getModuleForms(currToEdit.relstr[relstrInd].moduleId).responseJSON.data.datas;
                                let h='<option select value>选择</option>';
                                data.forEach(el=>{
                                    let add=`<option value="${el.id}">${el.name}</option>`
                                    h+=add;
                                })
                                debugger
                                target.next().next().html(h)
                         
                            }else{
                                data=api.getModuleViews(currToEdit.relstr[relstrInd].moduleId).responseJSON.data.datas;
                                let h='<option select value>选择</option>';
                                data.forEach(el=>{
                                    let add=`<option value="${el.id}">${el.name}</option>`
                                    h+=add;
                                })
                                target.next().next().html(h)
                         
                            }
                            
                        }
                        currToEdit.relstr[relstrInd][relstrId]=target.val();
                    }
                }
				currToEdit.setProps(prop);
			} else{
				form.setProps(prop);
			}
            if(need){
                form.resetChunkPosition();
            }
            form.repaint();
            e.preventDefault()
            e.stopPropagation()
			// tree.render();
        });
        $container.off('select click').on('select click', (e) => {
            const target = $(e.target);
            const key = target.parent().attr('id')?target.parent().attr('id'):target.parent().attr('name');
			// const key2 = target.attr('id')?target.attr('id'):target.attr('name');
            
            const val = target.val();
            //值设计脚本的内容
            if(key=="field" || key=="fieldOption"){
                //值-设计脚本的问题
                target.parent().siblings("textarea").val(target.parent().siblings("textarea").val()+target.parent().val())
                //currToEdit.processdescription=target.parent().siblings("textarea").val();
				currToEdit.setProps({"processdescription":target.parent().siblings("textarea").val()});

            }
            if(val=="clear"){
                target.parent().siblings("textarea").val("")
                currToEdit.processdescription="";

            }
            // //局部刷新的
            // if(key2=="refreshfields"){
            //     currToEdit.refreshfields+=val;
            // }
			form.repaint();
            

        });        
    }
}
export default PropsPanel;