import {Api, Helper} from '../../utility';
import {TdLayout} from '../Layout/index';
import {PropsPanel} from '../view';

class Menu{
    static getInstance() {
		if(!Menu.instance || !(Menu.instance instanceof Menu)) {
			Menu.instance = new Menu();
		}
		//console.log(Tree.instance)
		return Menu.instance;
	}
    constructor(){
        this.target = null;
		this.container = null;
		this.form = null;
		this.hasMenu = false;
		this.isShowMenu = false;
		this.api = new Api();
	}
	
	//对象方法注册
	registerFunc(signature, callback) {

		//签名唯一性判断
		if(this.func[signature] == 'undefined') {
			this.func[signature] = callback;
		} else {
			throw new Error('signature already exists');
		}
	}

	//对象方法调用
	trigger(signature, params) {
		if(this.func[signature] != 'undefined') {
			if(params != "undefined") {
				if(typeof params != 'array' && !(params instanceof Array)) {
					this.func[signature](params);
				} else {
					this.func[signature](...params);
				}
			} else {
				this.func[signature]();
			}
		} else {
			throw new Error('signature not registered');
		}
	}

	setProps(newProps) {
		Object.assign(this, newProps);
	}
	
	getProp(prop) {
		return this[prop];
	}

	//获取鼠标坐标位置
	getMouseCoordinate() {
		return {x: this.target.clientX, y: this.target.clientY};
	}

	showMenu(type) {
		if(!this.hasMenu) {
			this.createMenu(type);
		} else {
			this.updateMenu();
		}
	}
	
	createMenu(type) {
		console.log("menu")
		const {x, y} = this.getMouseCoordinate();
		const api = this.api;
		const that = this;
		const $container = $(this.container);

		let menu = "";

		api.getTemplete('menu-tmpl').done((tml) => {
			menu = Helper.getInstance().handleTemplete(tml, {style: 'position:absolute;left:'+x+'px;top:'+y+'px;display:block',type:type}, 'menu-tmpl');
            $('body').append(menu);
			that.setProps({hasMenu: true, isShowMenu: true, container: $('#menu')});
			that.registerEvent();
		});
	}
    registerEvent() {
		const $container = $(this.container);

        $container.off('click', 'a').on('click', 'a', function(e) {
			const $this = $(this);
			const type = $this.text();
			
			switch(type) {
				case '增加一行':
					Menu.getInstance().insertRow();
					$this.parents('#menu').css('display', 'none');
					break;
				case '删除一行':
					Menu.getInstance().deleteRow();
					$this.parents('#menu').css('display', 'none');
					break;
				case '新增一列':
					Menu.getInstance().insertCol();
					$this.parents('#menu').css('display', 'none');
					break;
				case '删除一列':
					Menu.getInstance().deleteCol();
					$this.parents('#menu').css('display', 'none');
					break;
				case '向右合并单元格':
					Menu.getInstance().mergeCells("right");
					$this.parents('#menu').css('display', 'none');
					break;
				case '向下合并单元格':
					Menu.getInstance().mergeCells("bottom");
					$this.parents('#menu').css('display', 'none');
					break;
				case '删除':
					Menu.getInstance().delete()
					$this.parents('#menu').css('display', 'none');

					break;
				default:
					break;
			}	
			// $this.css('outline-style', 'none');
		});
	}
	hideMenu() {
		const menu = $('#menu');
		
		if(menu) {
			menu.css('display', 'none');
			this.setProps({isShowMenu: false});
		}
	}
	updateMenu(){
		const {x, y} = this.getMouseCoordinate();
		const menu = $('#menu');
		
		if(menu) {
			menu.css({left: x, top: y, display: 'block'});
			this.setProps({isShowMenu: true});
		}
	}
	insertRow(){
		console.log("menuinsertRow"+this.form._currentChunk);
		this.form._currentChunk.insertRow(this.form.nowRowIndex,this.form.realRowIndex,this.form.nowColIndex,this.form.cellHaveRowspan);
		this.form.repaint()
	}
	deleteRow(){
		console.log("menudeleteRow"+this.form._currentChunk);
		this.form._currentChunk.deleteRow(this.form.nowRowIndex,this.form.realRowIndex,this.form.nowColIndex,this.form.cellHaveRowspan);
		this.form.repaint()
	}
	insertCol(){
		console.log("menuinsertCol"+this.form._currentChunk);
		this.form._currentChunk.insertCol(this.form.nowRowIndex,this.form.nowColIndex);
		this.form.repaint()
	}
	deleteCol(){
		console.log("menudeleteCol"+this.form._currentChunk);
		this.form._currentChunk.deleteCol(this.form.nowColIndex);
		this.form.repaint()
	}
	mergeCells(mergeCellsDirection){
		console.log("menumergeCells"+this.form._currentChunk);
		this.form._currentChunk.mergeCells(mergeCellsDirection,this.form.nowRowIndex,this.form.nowColIndex);
		this.form.repaint()
	}
	delete(){
		//删除控件
		if(this.form._currentChunk && !this.form._currentElem){
			//删除最外层的元素
			console.log("menu,1")
			this.form.deleteChunk(this.form._currentChunk.id);
			this.form.repaint();
			const propsPanel = PropsPanel.getInstance();
			propsPanel.render();
			debugger
			this.form.refreshTreeList();

		}else if(this.form._currentChunk && this.form._currentElem){
			console.log("menu,2");
			this.form.deleteElem(this.form._currentChunk.id,this.form._currentElem.id);
			this.form.repaint();
			const propsPanel = PropsPanel.getInstance();
			propsPanel.render();
			debugger
			this.form.refreshTreeList();
			
		}
	}
}
export default Menu;