import {Input,Textarea,Radio,Checkbox,Data,Select,Dept,Selectaboutfield,Treedepartmentfield,Userfield,Suggestfield,Button,Viewdialogfield,Tabfield,Calctextfield,Surveyfield,Attachment,Imageuploadfield,Onlinetakephotofield,Weixingpsfield,Weixinrecordfield,Qrcodefield,Mapfield,Genericwordfield,Htmleditorfield,Flowhistoryfield,Flowreminderhistoryfield,Informationfeedbackfield} from '../component/index';
import {Includefield} from '../component/index';


import {TableLayout,FlowLayout,CellLayout} from '../Layout/index'
import Tree from './Tree';
import Menu from './Menu';
import { Api } from '../../utility/index';

class FormPanel {
    constructor(panel){
        this.panel=panel;
        this.chunk=[];
        this.elem=null;
        this.width=null;
        this.isAllowDraw=false;
        this._currentElem=null;
        this._currentChunk=null;
        this._currentElemId=null;//拖拽的时候用来保存元素id
        this._currentChunkId=null;//拖拽的时候保存之后放置的区域id
        this._currentOnline=null;//当前在那个元素的子元素的边线上
        this._statues=FormPanel.ACTION_NORMAL;
        this.cells=[];//当前鼠标所在table布局元素的td的组合
        this.insertBefore=true;//在上方还是下方插入
        this.table=[];//当前鼠标所在的table的信息
        this.rows=[];//当前鼠标所在的table的信息
        this.nowRowIndex=null;//当前鼠标坐在的td的tr
        this.nowColIndex=null;//当前鼠标所在的td的列数
        this.realRowIndex=null;//当前鼠标所在的tr
        this.cellHaveRowspan=false;//当前鼠标所在单元格是否有行合并单元格
        this._currentPropElem=null;//给属性面板用的，当前的鼠标所在元素
        this.changeChunk=[];//多行文本框移动的时候应该跟着移动的布局元素

        this.allName=[];//值设计的部分用来获取所有已保存的非布局控件的名字和fieldtype
        this.allNameNow=[];//获取所有控件的名字，实时
        this.num=0;//用来计数
        this.modules={};//模块的数据
        this.api = new Api();
        this.applicationId="";//软件id
        this.contextPath="";//项目路径
    }
    //添加单行文本框
    addInput(){
        let elem = new Input();
        this.num++;
        elem.name="单行文本框"+this.num;
        elem.processprevalue=this.getAllNameScript();
        this.elem=elem;
        this.setElemPosition(elem)
        this.isAllowDraw = true;
    }
    addTextarea(){
        let elem = new Textarea();
        this.num++;
        elem.name="多行文本框"+this.num;
        elem.processprevalue=this.getAllNameScript();
        this.elem=elem;
        this.setElemPosition(elem)
        this.isAllowDraw = true;
    }
    addRadio(){
        let elem = new Radio();
        this.num++;
        elem.name="单选框"+this.num;
        elem.processprevalue=this.getAllNameScript();
        this.elem=elem;
        this.setElemPosition(elem)
        this.isAllowDraw = true;
    }
    addCheckbox(){
        let elem = new Checkbox();
        this.num++;
        elem.name="复选框"+this.num;
        elem.processprevalue=this.getAllNameScript();
        this.elem=elem;
        this.setElemPosition(elem)
        this.isAllowDraw = true;
    }
    addData(){
        let elem = new Data();
        this.num++;
        elem.name="日期选择框"+this.num;
        elem.processprevalue=this.getAllNameScript();
        this.elem=elem;
        this.setElemPosition(elem)
        this.isAllowDraw = true;
    }
    addSelect(){
        let elem = new Select();
        this.num++;
        elem.name="下拉框"+this.num;
        elem.processprevalue=this.getAllNameScript();
        this.elem=elem;
        this.setElemPosition(elem)
        this.isAllowDraw = true;
    }
    addDept(){
        let elem = new Dept();
        this.num++;
        elem.name="部门选择框"+this.num;
        elem.processprevalue=this.getAllNameScript();
        this.elem=elem;
        this.setElemPosition(elem)
        this.isAllowDraw = true;
    }
    addSelectaboutfield(){
        let elem = new Selectaboutfield();
        this.num++;
        elem.name="左右选择框"+this.num;
        elem.processprevalue=this.getAllNameScript();
        this.elem=elem;
        this.setElemPosition(elem)
        this.isAllowDraw = true;
    }
    addTreedepartmentfield(){
        let elem = new Treedepartmentfield();
        this.num++;
        elem.name="树形部门选择框"+this.num;
        elem.processprevalue=this.getAllNameScript();
        this.elem=elem;
        this.setElemPosition(elem)
        this.isAllowDraw = true;
    }
    addUserfield(){
        let elem = new Userfield();
        this.num++;
        elem.name="用户选择框"+this.num;
        elem.processprevalue=this.getAllNameScript();
        this.elem=elem;
        this.setElemPosition(elem)
        this.isAllowDraw = true;
    }
    addSuggestfield(){
        let elem = new Suggestfield();
        this.num++;
        elem.name="智能搜索提示框"+this.num;
        elem.processprevalue=this.getAllNameScript();
        this.elem=elem;
        this.setElemPosition(elem)
        this.isAllowDraw = true;
    }
    addButton(){
        let elem = new Button();
        this.num++;
        elem.name="按钮"+this.num;
        elem.processprevalue=this.getAllNameScript();
        this.elem=elem;
        this.setElemPosition(elem)
        this.isAllowDraw = true;
    }
    addViewdialogfield(){
        let elem = new Viewdialogfield();
        this.num++;
        elem.name="视图选择框"+this.num;
        elem.processprevalue=this.getAllNameScript();
        this.elem=elem;
        this.setElemPosition(elem)
        this.isAllowDraw = true;
    }
    addTabfield(){
        let elem = new Tabfield();
        this.num++;
        elem.name="选项卡"+this.num;
        elem.processprevalue=this.getAllNameScript();
        this.elem=elem;
        this.setElemPosition(elem)
        this.isAllowDraw = true;
    }
    addCalctextfield(){
        let elem = new Calctextfield();
        this.num++;
        elem.name="计算脚本"+this.num;
        elem.processprevalue=this.getAllNameScript();
        this.elem=elem;
        this.setElemPosition(elem)
        this.isAllowDraw = true;
    }
    addIncludefield(){
        let elem = new Includefield();
        this.num++;
        elem.name="包含元素"+this.num;
        elem.processprevalue=this.getAllNameScript();
        this.elem=elem;
        this.setElemPosition(elem)
        this.isAllowDraw = true;
    }
    addSurveyfield(){
        let elem = new Surveyfield();
        this.num++;
        elem.name="调查控件"+this.num;
        elem.processprevalue=this.getAllNameScript();
        this.elem=elem;
        this.setElemPosition(elem)
        this.isAllowDraw = true;
    }
    
    addAttachment(){
        let elem = new Attachment();
        this.num++;
        elem.name="文件上传"+this.num;
        elem.processprevalue=this.getAllNameScript();
        this.elem=elem;
        this.setElemPosition(elem)
        this.isAllowDraw = true;
    }
    addImageuploadfield(){
        let elem = new Imageuploadfield();
        this.num++;
        elem.name="图片上传"+this.num;
        elem.processprevalue=this.getAllNameScript();
        this.elem=elem;
        this.setElemPosition(elem)
        this.isAllowDraw = true;
    }
    addOnlinetakephotofield(){
        let elem = new Onlinetakephotofield();
        this.num++;
        elem.name="在线拍照"+this.num;
        elem.processprevalue=this.getAllNameScript();
        this.elem=elem;
        this.setElemPosition(elem)
        this.isAllowDraw = true;
    }
    addWeixingpsfield(){
        let elem = new Weixingpsfield();
        this.num++;
        elem.name="微信gps定位"+this.num;
        elem.processprevalue=this.getAllNameScript();
        this.elem=elem;
        this.setElemPosition(elem)
        this.isAllowDraw = true;
    }
    addWeixinrecordfield(){
        let elem = new Weixinrecordfield();
        this.num++;
        elem.name="微信录音控件"+this.num;
        elem.processprevalue=this.getAllNameScript();
        this.elem=elem;
        this.setElemPosition(elem)
        this.isAllowDraw = true;
    }
    addQrcodefield(){
        let elem = new Qrcodefield();
        this.num++;
        elem.name="二维码控件"+this.num;
        elem.processprevalue=this.getAllNameScript();
        this.elem=elem;
        this.setElemPosition(elem)
        this.isAllowDraw = true;
    }
    addMapfield(){
        let elem = new Mapfield();
        this.num++;
        elem.name="地图"+this.num;
        elem.processprevalue=this.getAllNameScript();
        this.elem=elem;
        this.setElemPosition(elem)
        this.isAllowDraw = true;
    }
    addGenericwordfield(){
        let elem = new Genericwordfield();
        this.num++;
        elem.name="通用WORD编辑器"+this.num;
        elem.processprevalue=this.getAllNameScript();
        this.elem=elem;
        this.setElemPosition(elem)
        this.isAllowDraw = true;
    }
    addHtmleditorfield(){
        let elem = new Htmleditorfield();
        this.num++;
        elem.name="HTML编辑器"+this.num;
        elem.processprevalue=this.getAllNameScript();
        this.elem=elem;
        this.setElemPosition(elem)
        this.isAllowDraw = true;
    }
    addFlowhistoryfield(){
        let elem = new Flowhistoryfield();
        this.num++;
        elem.name="流程历史"+this.num;
        elem.processprevalue=this.getAllNameScript();
        this.elem=elem;
        this.setElemPosition(elem)
        this.isAllowDraw = true;
    }
    addFlowreminderhistoryfield(){
        let elem = new Flowreminderhistoryfield();
        this.num++;
        elem.name="流程催办历史"+this.num;
        elem.processprevalue=this.getAllNameScript();
        this.elem=elem;
        this.setElemPosition(elem)
        this.isAllowDraw = true;
    }
    addInformationfeedbackfield(){
        let elem = new Informationfeedbackfield();
        this.num++;
        elem.name="信息反馈"+this.num;
        elem.processprevalue=this.getAllNameScript();
        this.elem=elem;
        this.setElemPosition(elem)
        this.isAllowDraw = true;
    }



    addTableLayout(){
        let elem = new TableLayout();
        this.elem=elem;
        this.setElemPosition(elem)
        elem.init();
        this.isAllowDraw = true;
    }
    addFlowLayout(){
        let elem = new FlowLayout();
        this.elem=elem;
        // this.elem.panelWidth=parseInt(this.width);
        this.elem.width=parseInt(this.width);
        this.setElemPosition(elem)
        elem.init();
        this.isAllowDraw = true;
    }
    addCellLayout(){
        let elem = new CellLayout();
        this.elem=elem;
        this.elem.width=parseInt(this.width);
        this.setElemPosition(elem)
        elem.init();
        this.isAllowDraw = true;
    }
    init(){
        this.panel.onmousemove = (e) => {
            this.handleMouseMove(e);
        };
    
        this.panel.onmousedown = (e) => {
            this.clearCurrToEdit();
            this.handleMouseDown(e);
        };
        
        this.panel.onmouseup = (e) => {
            this.handleMouseUp(e);
        };
    
        // this.api.contextPath=$('#contextPath', parent.document).val();
        // this.modules=this.api.getModules(this.applicationId);


         
    }
    
    parseHtml(html){
        let root=html[0];
        let that=this;
        const traversalNode = (htmlNode) => {
            const {tagName}=htmlNode;
            switch(tagName){

                case 'P':
                    let p=htmlNode;
                    const traversalNode3 = (htmlNode2) => {
                        const type=htmlNode2.getAttribute("type");
                        switch(type){
                            case 'TABLE':
                                let tablelayout = new TableLayout();
                                tablelayout.width=parseFloat(htmlNode2.getAttribute("width"));
                                tablelayout.height=parseFloat(htmlNode2.getAttribute("height"));
                                tablelayout.x=parseFloat(htmlNode2.getAttribute("panelx"));
                                tablelayout.y=parseFloat(htmlNode2.getAttribute("panely"));
                                tablelayout.parseHtml(htmlNode2);
                                that.chunk.push(tablelayout);
                                console.log(that.chunk)
                                break;
                            case 'F-FLAYOUT':
                                let flowLayout = new FlowLayout();
                                flowLayout.width=parseFloat(htmlNode2.getAttribute("width"));
                                flowLayout.height=parseFloat(htmlNode2.getAttribute("height"));
                                flowLayout.parseHtml(htmlNode2);
                                that.num+=flowLayout.getElementLength();
                                that.chunk.push(flowLayout);
                                console.log(that.chunk)
                                that.allName=[...that.allName,...flowLayout.getAllName()]
                                break;
                            case 'F-CLAYOUT':
                                let cellLayout = new CellLayout();
                                cellLayout.width=parseFloat(htmlNode2.getAttribute("width"));
                                cellLayout.height=parseFloat(htmlNode2.getAttribute("height"));
                                cellLayout.parseHtml(htmlNode2);
                                that.num+=cellLayout.getElementLength();

                                that.chunk.push(cellLayout);
                                console.log(that.chunk)
                                that.allName=[...that.allName,...cellLayout.getAllName()]
                                break;
                            case 'f-input':
                                let inputtype=htmlNode2.getAttribute("classname")
                                switch(inputtype){
                                    case "cn.myapps.runtime.dynaform.form.ejb.DateField":
                                        let data = new Data();
                                        data.parseHtml(htmlNode2);
                                        data.isblock="false";
                                        that.chunk.push(data);
                                        that.allName.push({"name":data.name,"value":data.fieldtype})
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.RadioField":
                                        let radio = new Radio();
                                        radio.parseHtml(htmlNode2);
                                        radio.isblock="false";
                                        that.chunk.push(radio);
                                        that.allName.push({"name":radio.name,"value":radio.fieldtype})
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.CheckboxField":
                                        let checkbox = new Checkbox();
                                        checkbox.parseHtml(htmlNode2);
                                        checkbox.isblock="false";
                                        this.chunk.push(checkbox);
                                        that.allName.push({"name":checkbox.name,"value":checkbox.fieldtype})
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.SuggestField":
                                        let suggestfield = new Suggestfield();
                                        suggestfield.parseHtml(htmlNode2);
                                        suggestfield.isblock="false";
                                        that.chunk.push(suggestfield);
                                        that.allName.push({"name":suggestfield.name,"value":suggestfield.fieldtype})
                                        break; 
                                    case "cn.myapps.runtime.dynaform.form.ejb.ButtonField":
                                        let button = new Button();
                                        button.parseHtml(htmlNode2);
                                        button.isblock="false";
                                        that.chunk.push(button);
                                        that.allName.push({"name":button.name,"value":button.fieldtype})
                                        break;
                                    default:
                                        let input = new Input();
                                        input.parseHtml(htmlNode2);
                                        input.isblock="false";
                                        that.chunk.push(input);
                                        that.allName.push({"name":input.name,"value":input.fieldtype})
                                        break;
                                        
                                }
                                that.num++;
                                break;
                            case 'f-textarea':
                                let textarea = new Textarea();
                                textarea.parseHtml(htmlNode2);
                                textarea.isblock="false";

                                that.chunk.push(textarea);
                                that.num++;

                                that.allName.push({"name":textarea.name,"value":textarea.fieldtype})

                                break;
                            
                            case 'f-select':
                                let selecttype=htmlNode2.getAttribute("classname")
                                switch(selecttype){
                                    case "cn.myapps.runtime.dynaform.form.ejb.DepartmentField":
                                        let dept = new Dept();
                                        dept.parseHtml(htmlNode2);
                                        dept.isblock="false";
        
                                        that.chunk.push(dept);
        
                                        this.allName.push({"name":dept.name,"value":dept.fieldtype})
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.SelectAboutField":
                                        let selectaboutfield = new Selectaboutfield();
                                        selectaboutfield.parseHtml(htmlNode2);
                                        selectaboutfield.isblock="false";
        
                                        that.chunk.push(selectaboutfield);
        
                                        this.allName.push({"name":selectaboutfield.name,"value":selectaboutfield.fieldtype})            
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.TreeDepartmentField":
                                        let treedepartmentfield = new Treedepartmentfield();
                                        treedepartmentfield.parseHtml(htmlNode2);
                                        treedepartmentfield.isblock="false";
        
                                        that.chunk.push(treedepartmentfield);
        
                                        this.allName.push({"name":treedepartmentfield.name,"value":treedepartmentfield.fieldtype})                    
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.UserField":
                                        let userfield = new Userfield();
                                        userfield.parseHtml(htmlNode2);
                                        userfield.isblock="false";
                                        that.chunk.push(userfield);
        
                                        that.allName.push({"name":userfield.name,"value":userfield.fieldtype})                    
                                        break;
                                    default:
                                        let select = new Select();
                                        select.parseHtml(htmlNode2);
                                        select.isblock="false";
        
                                        that.chunk.push(select);
        
                                        that.allName.push({"name":select.name,"value":select.fieldtype})
            
                                        break;
                                }
                                this.num++;
                                break;
                            case 'f-img':
                                let imgtype=htmlNode2.getAttribute("classname")                                
                                switch(imgtype){
                                    case "cn.myapps.runtime.dynaform.form.ejb.TabField":
                                        let tabfield = new Tabfield();
                                        tabfield.parseHtml(htmlNode2);
                                        tabfield.isblock="false";
                                        that.chunk.push(tabfield);
                                        that.allName.push({"name":tabfield.name,"value":tabfield.fieldtype?tabfield.fieldtype:""})
            
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.ViewDialogField":
                                        let viewdialogfield = new Viewdialogfield();
                                        viewdialogfield.parseHtml(htmlNode2);
                                        viewdialogfield.isblock="false";
                                        that.chunk.push(viewdialogfield);
                                        that.allName.push({"name":viewdialogfield.name,"value":viewdialogfield.fieldtype})
            
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.CalctextField":
                                        let calctextField = new Calctextfield();
                                        calctextField.parseHtml(htmlNode2);
                                        calctextField.isblock="false";
                                        that.chunk.push(calctextField);
                                        that.allName.push({"name":calctextField.name,"value":calctextField.fieldtype})
            
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.IncludeField":
                                        let includeField = new Includefield();
                                        includeField.parseHtml(htmlNode2);
                                        includeField.isblock="false";
                                        that.chunk.push(includeField);
                                        that.allName.push({"name":includeField.name,"value":includeField.fieldtype})
            
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.SurveyField":
                                        let surveyfield = new Surveyfield();
                                        surveyfield.parseHtml(htmlNode2);
                                        surveyfield.isblock="false";
                                        that.chunk.push(surveyfield);
                                        that.allName.push({"name":surveyfield.name,"value":surveyfield.fieldtype})
            
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.AttachmentUploadField":
                                        let attachment = new Attachment();
                                        attachment.parseHtml(htmlNode2);
                                        attachment.isblock="false";
                                        that.chunk.push(attachment);
                                        that.allName.push({"name":attachment.name,"value":attachment.fieldtype})
            
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.ImageUploadField":
                                        let imageuploadfield = new Imageuploadfield();
                                        imageuploadfield.parseHtml(htmlNode2);
                                        imageuploadfield.isblock="false";
                                        that.chunk.push(imageuploadfield);
                                        that.allName.push({"name":imageuploadfield.name,"value":imageuploadfield.fieldtype})
            
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.OnLineTakePhotoField":
                                        let onlinetakephotofield = new Onlinetakephotofield();
                                        onlinetakephotofield.parseHtml(htmlNode2);
                                        onlinetakephotofield.isblock="false";
                                        that.chunk.push(onlinetakephotofield);
                                        that.allName.push({"name":onlinetakephotofield.name,"value":onlinetakephotofield.fieldtype})
            
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.WeixinGpsField":
                                        let weixingpsfield = new Weixingpsfield();
                                        weixingpsfield.parseHtml(htmlNode2);
                                        weixingpsfield.isblock="false";
                                        that.chunk.push(weixingpsfield);
                                        that.allName.push({"name":weixingpsfield.name,"value":weixingpsfield.fieldtype})
            
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.WeixinRecordField":
                                        let weixinrecordfield = new Weixinrecordfield();
                                        weixinrecordfield.parseHtml(htmlNode2);
                                        weixinrecordfield.isblock="false";
                                        that.chunk.push(weixinrecordfield);
                                        that.allName.push({"name":weixinrecordfield.name,"value":weixinrecordfield.fieldtype})
            
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.QRCodeField":
                                        let qrcodefield = new Qrcodefield();
                                        qrcodefield.parseHtml(htmlNode2);
                                        qrcodefield.isblock="false";
                                        that.chunk.push(qrcodefield);
                                        that.allName.push({"name":qrcodefield.name,"value":qrcodefield.fieldtype})
            
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.MapField":
                                        let mapfield = new Mapfield();
                                        mapfield.parseHtml(htmlNode2);
                                        mapfield.isblock="false";
                                        that.chunk.push(mapfield);
                                        that.allName.push({"name":mapfield.name,"value":mapfield.fieldtype})
            
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.GenericWordField":
                                        let genericwordfield = new Genericwordfield();
                                        genericwordfield.parseHtml(htmlNode2);
                                        genericwordfield.isblock="false";
                                        that.chunk.push(genericwordfield);
                                        that.allName.push({"name":genericwordfield.name,"value":genericwordfield.fieldtype})
            
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.HTMLEditorField":
                                        let htmleditorfield = new Htmleditorfield();
                                        htmleditorfield.parseHtml(htmlNode2);
                                        htmleditorfield.isblock="false";
                                        that.chunk.push(htmleditorfield);
                                        that.allName.push({"name":htmleditorfield.name,"value":htmleditorfield.fieldtype})
            
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.FlowHistoryField":
                                        let flowhistoryfield = new Flowhistoryfield();
                                        flowhistoryfield.parseHtml(htmlNode2);
                                        flowhistoryfield.isblock="false";
                                        that.chunk.push(flowhistoryfield);
                                        that.allName.push({"name":flowhistoryfield.name,"value":flowhistoryfield.fieldtype})
            
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.FlowReminderHistoryField":
                                        let flowreminderhistoryfield = new Flowreminderhistoryfield();
                                        flowreminderhistoryfield.parseHtml(htmlNode2);
                                        flowreminderhistoryfield.isblock="false";
                                        that.chunk.push(flowreminderhistoryfield);
                                        that.allName.push({"name":flowreminderhistoryfield.name,"value":flowreminderhistoryfield.fieldtype})
            
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.InformationFeedbackField":
                                        let informationfeedbackfield = new Informationfeedbackfield();
                                        informationfeedbackfield.parseHtml(htmlNode2);
                                        informationfeedbackfield.isblock="false";
                                        that.chunk.push(informationfeedbackfield);
                                        that.allName.push({"name":informationfeedbackfield.name,"value":informationfeedbackfield.fieldtype})
            
                                        break;
                                    default:
                                        break;
                                }
                                that.num++;
                                break;
                            default:
                                console.log("no2");
                                break;

                        }
                    }
                    if(p.hasChildNodes()) {
                        for(let i = 0;i < p.children.length;i++) {
                            traversalNode3(p.children[i]);
                        }
                    }
                    break;

                case 'DIV':
                    let root2=htmlNode;
                    const traversalNode2 = (htmlNode2) => {
                        const {tagName}=htmlNode2;
                        switch(tagName){
                            case 'TABLE':
                                let tablelayout = new TableLayout();
                                tablelayout.width=parseFloat(htmlNode2.getAttribute("width"));
                                tablelayout.height=parseFloat(htmlNode2.getAttribute("height"));
                                tablelayout.x=parseFloat(htmlNode2.getAttribute("panelx"));
                                tablelayout.y=parseFloat(htmlNode2.getAttribute("panely"));
                                tablelayout.parseHtml(htmlNode2);
                                that.chunk.push(tablelayout);
                                console.log(that.chunk)
                                break;
                            case 'F-FLAYOUT':
                                let flowLayout = new FlowLayout();
                                flowLayout.width=parseFloat(htmlNode2.getAttribute("width"));
                                flowLayout.height=parseFloat(htmlNode2.getAttribute("height"));
                                flowLayout.parseHtml(htmlNode2);
                                that.num+=flowLayout.getElementLength();
                                that.chunk.push(flowLayout);
                                console.log(that.chunk)
                                that.allName=[...that.allName,...flowLayout.getAllName()]
                                break;
                            case 'F-CLAYOUT':
                                let cellLayout = new CellLayout();
                                cellLayout.width=parseFloat(htmlNode2.getAttribute("width"));
                                cellLayout.height=parseFloat(htmlNode2.getAttribute("height"));
                                cellLayout.parseHtml(htmlNode2);
                                that.num+=cellLayout.getElementLength();

                                that.chunk.push(cellLayout);
                                console.log(that.chunk)
                                that.allName=[...that.allName,...cellLayout.getAllName()]
                                break;
                            case 'F-INPUT':
                                let inputtype=htmlNode2.getAttribute("classname")
                                switch(inputtype){
                                    case "cn.myapps.runtime.dynaform.form.ejb.DateField":
                                        let data = new Data();
                                        data.parseHtml(htmlNode2);
                                        data.isblock="false";
                                        that.chunk.push(data);
                                        that.allName.push({"name":data.name,"value":data.fieldtype})
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.RadioField":
                                        let radio = new Radio();
                                        radio.parseHtml(htmlNode2);
                                        radio.isblock="false";
                                        that.chunk.push(radio);
                                        that.allName.push({"name":radio.name,"value":radio.fieldtype})
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.CheckboxField":
                                        let checkbox = new Checkbox();
                                        checkbox.parseHtml(htmlNode2);
                                        checkbox.isblock="false";
                                        this.chunk.push(checkbox);
                                        that.allName.push({"name":checkbox.name,"value":checkbox.fieldtype})
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.SuggestField":
                                        let suggestfield = new Suggestfield();
                                        suggestfield.parseHtml(htmlNode2);
                                        suggestfield.isblock="false";
                                        that.chunk.push(suggestfield);
                                        that.allName.push({"name":suggestfield.name,"value":suggestfield.fieldtype})
                                        break; 
                                    case "cn.myapps.runtime.dynaform.form.ejb.ButtonField":
                                        let button = new Button();
                                        button.parseHtml(htmlNode2);
                                        button.isblock="false";
                                        that.chunk.push(button);
                                        that.allName.push({"name":button.name,"value":button.fieldtype})
                                        break;
                                    default:
                                        let input = new Input();
                                        input.parseHtml(htmlNode2);
                                        input.isblock="false";
                                        that.chunk.push(input);
                                        that.allName.push({"name":input.name,"value":input.fieldtype})
                                        break;
                                        
                                }
                                that.num++;
                                break;
                            case 'F-TEXTAREA':
                                let textarea = new Textarea();
                                textarea.parseHtml(htmlNode2);
                                textarea.isblock="false";

                                that.chunk.push(textarea);
                                that.num++;

                                that.allName.push({"name":textarea.name,"value":textarea.fieldtype})

                                break;
                            
                            case 'F-SELECT':
                                let selecttype=htmlNode2.getAttribute("classname")
                                switch(selecttype){
                                    case "cn.myapps.runtime.dynaform.form.ejb.DepartmentField":
                                        let dept = new Dept();
                                        dept.parseHtml(htmlNode2);
                                        dept.isblock="false";
        
                                        that.chunk.push(dept);
        
                                        this.allName.push({"name":dept.name,"value":dept.fieldtype})
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.SelectAboutField":
                                        let selectaboutfield = new Selectaboutfield();
                                        selectaboutfield.parseHtml(htmlNode2);
                                        selectaboutfield.isblock="false";
        
                                        that.chunk.push(selectaboutfield);
        
                                        this.allName.push({"name":selectaboutfield.name,"value":selectaboutfield.fieldtype})            
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.TreeDepartmentField":
                                        let treedepartmentfield = new Treedepartmentfield();
                                        treedepartmentfield.parseHtml(htmlNode2);
                                        treedepartmentfield.isblock="false";
        
                                        that.chunk.push(treedepartmentfield);
        
                                        this.allName.push({"name":treedepartmentfield.name,"value":treedepartmentfield.fieldtype})                    
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.UserField":
                                        let userfield = new Userfield();
                                        userfield.parseHtml(htmlNode2);
                                        userfield.isblock="false";
                                        that.chunk.push(userfield);
        
                                        that.allName.push({"name":userfield.name,"value":userfield.fieldtype})                    
                                        break;
                                    default:
                                        let select = new Select();
                                        select.parseHtml(htmlNode2);
                                        select.isblock="false";
        
                                        that.chunk.push(select);
        
                                        that.allName.push({"name":select.name,"value":select.fieldtype})
            
                                        break;
                                }
                                this.num++;
                                break;
                            
                            case 'F-VIEWDIALOGFIELD':
                                let viewdialogfield = new Viewdialogfield();
                                viewdialogfield.parseHtml(htmlNode2);
                                viewdialogfield.isblock="false";
                                that.chunk.push(viewdialogfield);
                                that.num++;
                                that.allName.push({"name":viewdialogfield.name,"value":viewdialogfield.fieldtype})

                                break;
                            case 'F-IMG':
                                let imgtype=htmlNode2.getAttribute("classname")                                
                                switch(imgtype){
                                    case "cn.myapps.runtime.dynaform.form.ejb.TabField":
                                        let tabfield = new Tabfield();
                                        tabfield.parseHtml(htmlNode2);
                                        tabfield.isblock="false";
                                        that.chunk.push(tabfield);
                                        that.allName.push({"name":tabfield.name,"value":tabfield.fieldtype?tabfield.fieldtype:""})
            
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.ViewDialogField":
                                        let viewdialogfield = new Viewdialogfield();
                                        viewdialogfield.parseHtml(htmlNode2);
                                        viewdialogfield.isblock="false";
                                        that.chunk.push(viewdialogfield);
                                        that.allName.push({"name":viewdialogfield.name,"value":viewdialogfield.fieldtype})
            
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.CalctextField":
                                        let calctextField = new Calctextfield();
                                        calctextField.parseHtml(htmlNode2);
                                        calctextField.isblock="false";
                                        that.chunk.push(calctextField);
                                        that.allName.push({"name":calctextField.name,"value":calctextField.fieldtype})
            
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.IncludeField":
                                        let includeField = new Includefield();
                                        includeField.parseHtml(htmlNode2);
                                        includeField.isblock="false";
                                        that.chunk.push(includeField);
                                        that.allName.push({"name":includeField.name,"value":includeField.fieldtype})
            
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.SurveyField":
                                        let surveyfield = new Surveyfield();
                                        surveyfield.parseHtml(htmlNode2);
                                        surveyfield.isblock="false";
                                        that.chunk.push(surveyfield);
                                        that.allName.push({"name":surveyfield.name,"value":surveyfield.fieldtype})
            
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.AttachmentUploadField":
                                        let attachment = new Attachment();
                                        attachment.parseHtml(htmlNode2);
                                        attachment.isblock="false";
                                        that.chunk.push(attachment);
                                        that.allName.push({"name":attachment.name,"value":attachment.fieldtype})
            
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.ImageUploadField":
                                        let imageuploadfield = new Imageuploadfield();
                                        imageuploadfield.parseHtml(htmlNode2);
                                        imageuploadfield.isblock="false";
                                        that.chunk.push(imageuploadfield);
                                        that.allName.push({"name":imageuploadfield.name,"value":imageuploadfield.fieldtype})
            
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.OnLineTakePhotoField":
                                        let onlinetakephotofield = new Onlinetakephotofield();
                                        onlinetakephotofield.parseHtml(htmlNode2);
                                        onlinetakephotofield.isblock="false";
                                        that.chunk.push(onlinetakephotofield);
                                        that.allName.push({"name":onlinetakephotofield.name,"value":onlinetakephotofield.fieldtype})
            
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.WeixinGpsField":
                                        let weixingpsfield = new Weixingpsfield();
                                        weixingpsfield.parseHtml(htmlNode2);
                                        weixingpsfield.isblock="false";
                                        that.chunk.push(weixingpsfield);
                                        that.allName.push({"name":weixingpsfield.name,"value":weixingpsfield.fieldtype})
            
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.WeixinRecordField":
                                        let weixinrecordfield = new Weixinrecordfield();
                                        weixinrecordfield.parseHtml(htmlNode2);
                                        weixinrecordfield.isblock="false";
                                        that.chunk.push(weixinrecordfield);
                                        that.allName.push({"name":weixinrecordfield.name,"value":weixinrecordfield.fieldtype})
            
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.QRCodeField":
                                        let qrcodefield = new Qrcodefield();
                                        qrcodefield.parseHtml(htmlNode2);
                                        qrcodefield.isblock="false";
                                        that.chunk.push(qrcodefield);
                                        that.allName.push({"name":qrcodefield.name,"value":qrcodefield.fieldtype})
            
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.MapField":
                                        let mapfield = new Mapfield();
                                        mapfield.parseHtml(htmlNode2);
                                        mapfield.isblock="false";
                                        that.chunk.push(mapfield);
                                        that.allName.push({"name":mapfield.name,"value":mapfield.fieldtype})
            
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.GenericWordField":
                                        let genericwordfield = new Genericwordfield();
                                        genericwordfield.parseHtml(htmlNode2);
                                        genericwordfield.isblock="false";
                                        that.chunk.push(genericwordfield);
                                        that.allName.push({"name":genericwordfield.name,"value":genericwordfield.fieldtype})
            
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.HTMLEditorField":
                                        let htmleditorfield = new Htmleditorfield();
                                        htmleditorfield.parseHtml(htmlNode2);
                                        htmleditorfield.isblock="false";
                                        that.chunk.push(htmleditorfield);
                                        that.allName.push({"name":htmleditorfield.name,"value":htmleditorfield.fieldtype})
            
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.FlowHistoryField":
                                        let flowhistoryfield = new Flowhistoryfield();
                                        flowhistoryfield.parseHtml(htmlNode2);
                                        flowhistoryfield.isblock="false";
                                        that.chunk.push(flowhistoryfield);
                                        that.allName.push({"name":flowhistoryfield.name,"value":flowhistoryfield.fieldtype})
            
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.FlowReminderHistoryField":
                                        let flowreminderhistoryfield = new Flowreminderhistoryfield();
                                        flowreminderhistoryfield.parseHtml(htmlNode2);
                                        flowreminderhistoryfield.isblock="false";
                                        that.chunk.push(flowreminderhistoryfield);
                                        that.allName.push({"name":flowreminderhistoryfield.name,"value":flowreminderhistoryfield.fieldtype})
            
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.InformationFeedbackField":
                                        let informationfeedbackfield = new Informationfeedbackfield();
                                        informationfeedbackfield.parseHtml(htmlNode2);
                                        informationfeedbackfield.isblock="false";
                                        that.chunk.push(informationfeedbackfield);
                                        that.allName.push({"name":informationfeedbackfield.name,"value":informationfeedbackfield.fieldtype})
            
                                        break;
                                    default:
                                        break;
                                }
                                that.num++;
                                break;
                            default:
                                console.log("no2");
                                break;

                        }
                    }
                    if(root2.hasChildNodes()) {
                        for(let i = 0;i < root2.children.length;i++) {
                            traversalNode2(root2.children[i]);
                        }
                    }
                    break;
                default:
                    console.log("no");
                    break;

            }
        }
        if(root.hasChildNodes()) {
            for(let i = 0;i < root.children.length;i++) {
                traversalNode(root.children[i]);
            }
        }
        this.allNameNow=[...this.allName];
        console.log("this.allNameNow",this.allNameNow)
        this.resetChunkPosition();
        this.setAllProcesspreValue();
    }
    paint(){
        $(this.panel).html("");
        const chunk = this.chunk;
        let h="";
        let have=false;
        let havebegin=false;
        for(let i=0;i<chunk.length;i++){
            if(i==0 && (chunk[i].scope !="CellLayout" && chunk[i].scope!="FlowLayout" )){
                havebegin=true;
                h +="<p>";
            }
            if((chunk[i].scope=="CellLayout" || chunk[i].scope=="FlowLayout")&& havebegin ){
                havebegin=false;
                have=true;
                 h+="</p>"
            }
            h += chunk[i].paint();
            if(i!=chunk.length-1 && have && (chunk[i+1].scope !="CellLayout" && chunk[i+1].scope!="FlowLayout" )){
                have=false
                h+="<p>"
            }
            
            
        }
        if(!have){
            h+="</p>"    
        }
        $(this.panel).html(h);
        
        if($(this.panel).find("span[class='inlineBlock']").length>0){
            $(this.panel).find("span[class='inlineBlock']").each((ind,elm)=>{
                $(elm).off("dragstart").on("dragstart",()=>{
                    let ev = window.event || arguments.callee.caller.arguments[0]
                    ev.dataTransfer.setData("Text",ev.target.id);
                    this._currentElemId=ev.target.id;
                })
            })
        }
        if($(this.panel).find("span[class='block']").length>0){
            $(this.panel).find("span[class='block']").each((ind,elm)=>{
                $(elm).off("dragstart").on("dragstart",()=>{
                    let ev = window.event || arguments.callee.caller.arguments[0]
                    ev.dataTransfer.setData("Text",ev.target.id);
                    this._currentElemId=ev.target.id;
                })
            })
        }
        
        if($(this.panel).find("f-flayout").length>0){
            $(this.panel).find("f-flayout").each((ind,elm)=>{
                $(elm).off("drop").on("drop",()=>{
                    let ev = window.event || arguments.callee.caller.arguments[0]
                    ev.preventDefault();
                    ev.stopPropagation();
                    var data=ev.dataTransfer.getData("Text");
                    ev.target.appendChild(document.getElementById(data));
                    //
                    this._currentChunkId=ev.target.id;
                    this.resetElementChunk();
                    this.repaint();

                })
            })
        }
        if($(this.panel).find("f-clayout").length>0){
            $(this.panel).find("f-clayout").each((ind,elm)=>{
                $(elm).off("drop").on("drop",()=>{
                    let ev = window.event || arguments.callee.caller.arguments[0]
                    ev.preventDefault();
                    ev.stopPropagation();
                    var data=ev.dataTransfer.getData("Text");
                    ev.target.appendChild(document.getElementById(data));
                    //
                    this._currentChunkId=ev.target.id;
                    this.resetElementChunk();
                    this.repaint();


                })
            })
        }
        
    }
    repaint(){
        this.paint();
    }
    //改变鼠标状态
    changeStatues(statues) {

		this._statues = statues;
		switch (this._statues) {
			case FormPanel.ACTION_NORMAL:
                this.panel.style.cursor = "default";
				break;
			case FormPanel.ACTION_IN_ELEMENT:
                this.panel.style.cursor = "move";
				break;
			case FormPanel.ACTION_IN_BASELINE:
				this.panel.style.cursor = "n-resize";
				break;
			case FormPanel.ACTION_ARCHOR_UPPER_LEFT:
				this.panel.style.cursor = 'nw-resize';
				break;
			case FormPanel.ACTION_ARCHOR_UPPER_RIGHT:
				this.panel.style.cursor = 'ne-resize';
				break;
			case FormPanel.ACTION_ARCHOR_LOWER_LEFT:
				this.panel.style.cursor = 'sw-resize';
				break;
			case FormPanel.ACTION_ARCHOR_LOWER_RIGHT:
				this.panel.style.cursor = 'se-resize';
				break;
			default:
				this.panel.style.cursor = "initial";
				break;
		}
	}
    handleMouseMove(e) {
        let that=this;
        let {x,y}=that.getPositionByPanel2(that.panel,e.clientX,e.clientY);
        if(that.isAllowDraw){
            console.log("1，move")
            //允许绘画，当前看应该是有元素需要加进panel中的情况
            let currentChunk=that.selectedChunk(x,y);
            if(currentChunk){
                if(currentChunk.scope=="FlowLayout" || currentChunk.scope=="CellLayout"){
                    //当前鼠标下面有布局元素，那就继续往下查找，是否有下一层的布局元素，找到最后一层，然后将currentchunk替换成底层的布局
                    if(currentChunk.element.length>0){
                        console.log("11,move")
                        let selectChunk = currentChunk.getSelectedElem(x,y);//当前的
                        if(selectChunk){
                            that._currentChunk = selectChunk;
                        }else{
                            this._currentChunk = currentChunk;
                        }
                        // that.getSelectedElem(currentChunk.element.length,x,y);
                    }else{
                        that._currentChunk=currentChunk;
                    }
                }else{
                    that._currentChunk=currentChunk;
                }
            }else{
                that._currentChunk=null;
            }
            if(that.elem && !that._currentChunk){
                console.log(2,"move");
                //有新元素需要画，并且当前鼠标位置下面没有区域元素；
                // console.log(x,y)
                let {x,y}=that.getPositionByPanel(that.panel,e.clientX,e.clientY);

                that.elem.setProps({x:x,y:y});
            }else if(that.elem && that._currentChunk){
                //有新元素需要加进布局元素中
                console.log(3,'move')
                
            }
            // else if(that._currentChunk&&that._currentElem){
            //     //重新调整布局中的某个元素位置
            //     that._currentElem.setProps({_handlePointX:x,_handlePointY:y});
            // }
        }else{
            //不允许绘画，拖拽元素的情况
            console.log("4,move")
            if(that._currentChunk&&!that._currentElem && !that._currentOnline){
                //拖拽元素的情况
                console.log("7,move")

                that.changeStatues(FormPanel.ACTION_IN_ELEMENT);
                that._currentChunk.cursor="move";
                // if(that._currentOnline !== null){
                //     //console.log(3)
                //     that.changeStatues(FormPanel.ACTION_IN_BASELINE);
                //     if(this._currentChunk.scope=="tablelayout"){
                //         that._currentChunk.trs[that._currentOnline].height = that._currentChunk.trs[that._currentOnline].heightPre + y - that._currentChunk._handlePointY;
                //     }else if(this._currentChunk.scope=="FlowLayout"){
                //         this._currentChunk.height=that._currentChunk.heightPre + y - that._currentChunk._handlePointY
                //     }

                //     //console.log(x,y)
                // }
                that.repaint();
            }else if(that._currentChunk&&that._currentElem && !that._currentOnline){
                console.log(5,"move")

                //拖拽布局元素下的元素
                that.changeStatues(FormPanel.ACTION_IN_ELEMENT);
                that._currentElem.cursor="move";
                console.log(this._currentOnline)
                // if(that._currentOnline !== null){
                //     //console.log(3)
                //     that.changeStatues(FormPanel.ACTION_IN_BASELINE);
                //     if(this._currentChunk.scope=="tablelayout"){
                //         that._currentChunk.trs[that._currentOnline].height = that._currentChunk.trs[that._currentOnline].heightPre + y - that._currentChunk._handlePointY;
                //     }else if(this._currentChunk.scope=="FlowLayout"){
                //         this._currentChunk.height = this._currentChunk.heightPre+ y - that._currentChunk._handlePointY;

                //         this._currentElem.height=that._currentElem.heightPre + y - that._currentElem._handlePointY;
                //     }

                //     //console.log(x,y)
                //     that.repaint();

                // }
            }else if(that._currentChunk && !that._currentElem &&that._currentOnline){
                console.log("6,move")

                that.changeStatues(FormPanel.ACTION_IN_BASELINE);
                if(that._currentOnline.scope=="tablelayout"){
                    // that._currentChunk.trs[that._currentOnline].height = that._currentChunk.trs[that._currentOnline].heightPre + y - that._currentChunk._handlePointY;
                }else if(that._currentOnline.scope=="FlowLayout" || that._currentOnline.scope=="CellLayout"){
                    that._currentOnline.height = that._currentOnline.heightPre+ y - that._currentOnline._handlePointY;

                    this._currentChunk.height=that._currentChunk.heightPre + y - that._currentChunk._handlePointY;
                }else if(that._currentOnline.scope=="textarea"){
                    
                    that.changeStatues(FormPanel.ACTION_ARCHOR_LOWER_RIGHT);
                    // console.log(x,y)
                    that._currentOnline.width = that._currentOnline.widthPre+ x - that._currentOnline._handlePointX;
                    that._currentOnline.smallwidth = that._currentOnline.smallwidthPre+(that._currentOnline.width-that._currentOnline.widthPre);
                    that._currentOnline.height = that._currentOnline.heightPre+ y - that._currentOnline._handlePointY;
                    this._currentChunk.height=that._currentChunk.heightPre + y - that._currentChunk._handlePointY;

                }

                //console.log(x,y)
                this.resetChunkPosition();
                that.repaint();
            }else{
                console.log("move,8")
            }
        }
		
    }
    //拖拽元素的边线时，重新确认各边线的位置
    resetChunkChildren(x,y){
        //改变同一个布局元素的各边线位置
        if(this._currentChunk.scope=="tableLayout"){
            let currentChunkChildren=this._currentChunk.trs;
            let length=currentChunkChildren.length;
            let moveY=y - this._currentChunk._handlePointY;
            let height=0;
            let i=this._currentOnline+1;
            currentChunkChildren[this._currentOnline].resetTdLayout(moveY)
            if(i==length){
                height=currentChunkChildren[i-1].y-currentChunkChildren[0].y+currentChunkChildren[i-1].height+currentChunkChildren[i-1].margintop+currentChunkChildren[i-1].marginbottom;
                
            }
            // this._currentOnline._currentOnline.height = this._currentOnline._currentOnline.heightPre + y - this._currentChunk._handlePointY;
            for(;i<length;i++){
                currentChunkChildren[i].y =currentChunkChildren[i].yPre + moveY;//修改每个tr的y
                // currentChunkChildren[i].height += moveY;
                // currentChunkChildren[i].resetTdLayout(moveY)
                console.log(i)
                if(i==length-1){
                    height=currentChunkChildren[i].y-currentChunkChildren[0].y+currentChunkChildren[i].height+currentChunkChildren[i].margintop+currentChunkChildren[i].marginbottom;
                }
            }
            this._currentChunk.height=height;
            //改变因此元素改变的其他元素的坐标问题
            let index=null;
            this.chunk.forEach((elm,ind)=>{
                if(elm.id==this._currentChunk.id){
                    index=ind;
                }
            })
            this.chunk.forEach((el,i)=>{
                if(el.id!==this._currentChunk.id && i>index){
                    el.y += moveY;
                    el.resetTrLayout(moveY);
                }
            })
        }else if(this._currentChunk.scope=="FlowLayout" || this._currentChunk.scope=="CellLayout"){
            // let moveY=y - this._currentChunk._handlePointY;
            // this._currentChunk.height
        }
    }
    //获得鼠标基于panel的坐标值
    //用于新画进panel的元素的相对于panel的坐标值,1.6之所以直接拿元素的width，是因为在chunk中记录的width没有边框的据里，所以算上这个
	getPositionByPanel(panel){
        let panelWidth=$(panel).width();
        let panelHeight=$(panel).height();
        let width=0;
        let height=0;
        let currentHeight=0;
        let that=this;
        if(this.chunk.length>0){
            let length=this.chunk.length;
            height=this.chunk[0].height+this.chunk[0].marginbottom;
            for(let i=0;i<length;i++){
                width += this.chunk[i].width;
                if(width>=panelWidth-5 && width<=2*panelWidth && i!=0){
                    width=0;
                    i-=1;
                    currentHeight+=height;
                    height=0;
                    continue;
                }
                if(height==0){
                    height=this.chunk[i].height+this.chunk[i].marginbottom+this.chunk[i].margintop;
                }else if(height<this.chunk[i].height){
                    height=this.chunk[i].height+this.chunk[i].marginbottom+this.chunk[i].margintop;
                }
            }
            if(width+this.elem.width>panelWidth){
                width=0;
                currentHeight+=height;
                if(currentHeight+this.elem.height>panelHeight-20){
                    let h=panelHeight*1.2<currentHeight+this.elem.height?currentHeight+this.elem.height+panelHeight*0.2:panelHeight*1.2
                    $(panel).height(h);
                }
            }
        }
        // if($(panel)[0].children.length>0){
        //     let length=$(panel)[0].children.length;
        //     height=$($(panel)[0].children[0]).height()+parseInt($($(panel)[0].children[0]).css('marginBottom'))+parseInt($($(panel)[0].children[0]).css('marginTop'));
        //     for(let i=0;i<length;i++){
        //         // if($($(panel)[0].children[i]).tagName=="p"){
        //         //     width+=$($(panel)[0].children[0]).width();
        //         // }
        //         width+=$($(panel)[0].children[i]).width();
        //         if(width>=panelWidth-5 && width<=2*panelWidth && i!=0){
        //             width=0;
        //             i-=1;
        //             currentHeight+=height;
        //             height=0;
        //             continue;
        //         }
        //         if(height==0){
        //             height=$($(panel)[0].children[i]).height()+parseInt($($(panel)[0].children[i]).css('marginBottom'))+parseInt($($(panel)[0].children[i]).css('marginTop'));
        //         }else if(height<$($(panel)[0].children[i]).height()){
        //             height=$($(panel)[0].children[i]).height()+parseInt($($(panel)[0].children[i]).css('marginBottom'))+parseInt($($(panel)[0].children[i]).css('marginTop'));
        //         }
                
                
                
                
                
        //     }
        //     //将现有的元素的宽高循环了之后，取到最高和最长的，再拿elem的算上去
        //     if(width+this.elem.width>panelWidth){
        //         width=0;
        //         currentHeight+=height;
        //         if(currentHeight+this.elem.height>panelHeight-20){
        //             let h=panelHeight*1.2<currentHeight+this.elem.height?currentHeight+this.elem.height+panelHeight*0.2:panelHeight*1.2
        //             $(panel).height(h);
        //         }
        //     }
        // }
        return {
            x:width,
            y:currentHeight,
        }
    }
    //鼠标按下的时候获得鼠标点相对于panel的坐标
    getPositionByPanel2(panel,x,y){
        var bbox = panel.getBoundingClientRect();  
		return {  
			x: (x - bbox.left) * ($(panel).width() / bbox.width),   
			y: (y - bbox.top) * ($(panel).height() / bbox.height)  
		}; 
    }
   
    setElemPosition(elem){
        let {x,y}=this.getPositionByPanel(this.panel);
        elem.setProps({x:x,y:y});
    }

	handleMouseUp(e) {
        console.log("up");
        let {x,y}=this.getPositionByPanel2(this.panel,e.clientX,e.clientY);
        let that=this;
        if(that.elem && this._currentChunk){
            console.log("up",1)
            //有要放进布局的元素
            this.addElementToChunk(this.elem);
            this._currentChunk.resetChunkElemPosition();
            
            this.repaint();
            this.elem=null;
            this._currentChunk=null;
        }else if(that.elem && !this._currentChunk){
            console.log("up",2)
            //有要放进panel的元素
            this.addElement(this.elem);
            
            this.repaint();
            this.elem=null;
        }else if(this._currentChunk && this._currentElem && this._currentOnline){
            console.log("up",3)

            //有要在布局中调整位置的元素
            this.isAllowDraw=false;
            this.resetElementToChunk();
            
            this.repaint();
            this._currentChunk=null;
            this._currentElem=null;
            this._currentOnline=null;

        }else if(this._currentOnline!==null && this._currentChunk){
            console.log("up",4)

            //有要调整边线的(布局)元素
            console.log(this._currentChunk)
            console.log(x,y)
            this.resetChunkChildren(x,y)
            
            
            this.repaint();
            this._currentChunk=null;
            this._currentElem=null;
            this._currentOnline=null;
        }
        else{
            console.log("up",5)
            this.isAllowDraw=false;
            // this._currentChunk=null;
            // this._currentElem=null;
            // this._currentOnline=null;
            // if(this._currentChunk){
            //     this._currentChunk=null;
            // }
        }
        this.changeStatues(FormPanel.ACTION_NORMAL);
        
	}

	handleMouseDown(e) {
        let {x,y}=this.getPositionByPanel2(this.panel,e.clientX,e.clientY);
        console.log(x,y)
        let currentChunk=this.selectedChunk(x,y);
        this._currentChunk=currentChunk;
        
        if(e.button == 0){
            const menu = Menu.getInstance();
			//console.log(menu);
			if(menu.getProp('hasMenu') && menu.getProp('isShowMenu')) {
				menu.hideMenu();
			}
            if(currentChunk){
                //当前鼠标点击的是区域
                console.log("1,down")
                this.isAllowDraw=false;
                this._currentPropElem=this._currentChunk;
                this._currentChunk.setProps({_handlePointX:x,_handlePointY:y,isEdit:true,});
                if(this._currentChunk.scope=="tablelayout"){
                    let currentElementT=this.selectedTableChunkElement(x,y);
                    let currentOnlineT=this.isOnBaseLine(this._currentChunk,x,y);
                    console.log(currentOnlineT)
                    if(currentElementT){
                        
                        this._currentElem=currentElementT;
                        
                        this._currentPropElem=this._currentElem;

                        this._currentElem.setProps({_handlePointX:x,_handlePointY:y});
                    }else if(currentOnlineT !== null){
                        this._currentOnline=currentOnlineT;
                        this.savePreX(currentChunk.trs);
                        // this._currentOnline._currentOnline.xPre= this._currentOnline._currentOnline.x;
                        // this._currentOnline._currentOnline.yPre= this._currentOnline._currentOnline.y;
                        this._currentChunk.trs[this._currentOnline].widthPre= this._currentChunk.trs[this._currentOnline].width;
                        this._currentChunk.trs[this._currentOnline].heightPre= this._currentChunk.trs[this._currentOnline].height;

                    }
                }else if(this._currentChunk.scope=="FlowLayout" || this._currentChunk.scope=="CellLayout"){
                    let currentElementF=this.selectedChunkElement(x,y);
                    let currentOnlineF=this.isOnBaseLine(this._currentChunk,x,y);
                    console.log(currentElementF)
                    if(currentElementF){
                        //当前选中元素，这个元素是布局下的元素
                        // this.isAllowDraw=true;
                        this._currentElem=currentElementF;
                        
                        this._currentPropElem=this._currentElem;

                        this._currentElem.setProps({preX:x,preY:y});
                        
                    }else if(currentOnlineF){
                        //当前选中布局的边线
                        this._currentOnline=currentOnlineF;
                        this._currentOnline.heightPre= this._currentOnline.height;
                        this._currentChunk.heightPre= this._currentChunk.height;
                        this._currentOnline.setProps({_handlePointX:x,_handlePointY:y,isEdit:true,});
                        if(this._currentOnline.scope=="textarea"){
                            //此时应该对多行文本框的所有上级布局元素保存值，然后在move中在进行改变
                            // this.setSubData(x,y);
                            // console.log(this.changeChunk,"changechunk");
                            this._currentOnline.widthPre= this._currentOnline.width;
                        }
                    }else{
                        this._currentElem=currentElementF;
                        if(this._currentElem && this._currentElem.scope!="FlowLayout" && this._currentElem.scope!="CellLayout"){
                            this._currentElem.isChecked=true;
                        }
                        // //选中的是布局下布局的边线
                        // currentOnlineF=this.isOnBaseLine(this._currentElem,x,y);
                        // this._currentElem.setProps({_handlePointX:x,_handlePointY:y});
                        // this._currentPropElem=this._currentElem;

                        // this._currentElem.heightPre= this._currentElem.height;

                        // this._currentChunk.heightPre= this._currentChunk.height;
                        // this._currentOnline=currentOnlineF;
                        // console.log(currentOnlineF)
                    }
                }else if(this._currentChunk.scope=="textarea"){

                    let currentOnlineTe = this._currentChunk.isOnBaseLine(x,y);
                    if(currentOnlineTe){
                        this._currentOnline=currentOnlineTe;
                        this._currentOnline.heightPre= this._currentOnline.height;
                        this._currentOnline.widthPre= this._currentOnline.width;
                        this._currentOnline.smallwidthPre= this._currentOnline.smallwidth;

                        this._currentOnline.setProps({_handlePointX:x,_handlePointY:y,isEdit:true,});
                    }
                    

                }
                // this._currentElem.setProps({x:x,y:y});
                this.resetisCheck();
                this.repaint();
                this.changeStatues(FormPanel.ACTION_IN_ELEMENT);
            }else{
                this.isAllowDraw=true;
                this._currentChunk=null;
                this._currentElem=null;
                this.resetisCheck();
                this.repaint();
                this.changeStatues(FormPanel.ACTION_NORMAL);
            }
        }else if(e.button == 2){
            console.log("点击的鼠标右键");
            const menu = Menu.getInstance();
            if(currentChunk){
                this.isAllowDraw=false;
                this.stopElementDefaultMenu(this.panel);//阻止单个的td默认事件不生效，先暂时阻止整个panel的默认事件

                if(currentChunk && currentChunk.scope=="tablelayout"){
                    // const target = e.target;
                    let {nowRowIndex,nowColIndex,realRowIndex}=this.selectedChunkPart(x,y);
                    this.nowRowIndex=nowRowIndex;
                    this.nowColIndex=nowColIndex;
                    this.realRowIndex=realRowIndex;
                    this.stopElementDefaultMenu(this.panel);//阻止单个的td默认事件不生效，先暂时阻止整个panel的默认事件
                    console.log(this._currentChunk)
                    if(this._currentChunk && this._currentChunk.isSelected(x, y)) {

                        menu.setProps({target: e, form: this});
                        console.log("yes",this)

                        console.log("yes",this._currentChunk)
                        menu.showMenu("table");
                    } else {
                        menu.hideMenu();
                    }

                }else {

                    if(this._currentChunk || this._currentElem) {

                        menu.setProps({target: e, form: this});
                        menu.showMenu("flow");
                    } else {
                        menu.hideMenu();
                    }
                }
            }else{
                return false;

            }
        }else {
            return false;
        }
		console.log("down");
    }
    //对于布局内的多行文本框，需要保存多行文本框的上级的一些参数，然后给move的时候用
    setSubData(x,y){
        this.changeChunk=this._currentChunk.getChangeChunk(x,y);
    }
    //重置所有不是布局元素的ischeck属性,并且给当前的加上ischeck属性
    resetisCheck(){
        
        for(let i=0;i<this.chunk.length;i++){
            if(this.chunk[i].scope!="FlowLayout" && this.chunk[i].scope!="CellLayout"){
                this.chunk[i].isChecked=false;
            }else{
                this.chunk[i].resetisCheck();
            }
        }
        if(this._currentChunk && this._currentChunk.scope!="FlowLayout" && this._currentChunk.scope!="CellLayout"){
            this._currentChunk.isChecked=true;
        }else if(this._currentElem && this._currentElem.scope!="FlowLayout" && this._currentElem.scope!="CellLayout"){
            this._currentElem.isChecked=true;
        }
    }

    savePreX(currentChunkChildren){
        let length=currentChunkChildren.length;
        for(let i=0;i<length;i++){
            currentChunkChildren[i].xPre=currentChunkChildren[i].x;
            currentChunkChildren[i].yPre=currentChunkChildren[i].y;

        }
    }
    //屏蔽浏览器默认的右键菜单
	stopElementDefaultMenu(target) {
		target.oncontextmenu  = (ev) => {
			return false;   //屏蔽右键菜单
		}
	}
    //判断鼠标按下的位置在不在组件的边线上，这个应该给每个布局组件方法，然后让他们自行判断
    isOnBaseLine(currentChunk,x,y){
        let current=null;
        for(let i=0;i<this.chunk.length;i++){
            if(current){
                return current;
            }
            if(this.chunk[i].isOnBaseLine){
                current=this.chunk[i].isOnBaseLine(x,y);
            }
        }
        if(current){
            return current;
        }
        //console.log(currentChunk)
        // const scope=currentChunk.scope;
        // switch(scope){
        //     case 'tablelayout':
        //         let rows=currentChunk.rows;
        //         for(let i=0;i<rows;i++){
        //             if(y<currentChunk.trs[i].y+currentChunk.trs[i].height+5 && y>currentChunk.trs[i].y+currentChunk.trs[i].height-5){
        //                 return i
        //                 // {
        //                 //     i:i,
        //                     // _currentOnline:currentChunk.trs[i],
        //                     // _currentChunkChildren:currentChunk.trs
        //                 // };
                        
        //             }
        //         } 
        //         break;
        //     case 'FlowLayout':
        //         if(y<currentChunk.y+currentChunk.height+5 && y>currentChunk.y+currentChunk.height-5){
        //             return true
                    
        //         }
        //         break;
        //     default:
        //         break;

        // }
        
        return null;
    }
    //重新计算所有元素的坐标值
    resetChunkPosition(){
        let x=0,y=0;
        let bigHeight=0;
        for(let i=0;i<this.chunk.length;i++){
            if(bigHeight<this.chunk[i].height)bigHeight=this.chunk[i].height+this.chunk[i].marginbottom+this.chunk[i].margintop;
            this.chunk[i].x=x;this.chunk[i].y=y;
            if(this.chunk[i].scope=="FlowLayout" || this.chunk[i].scope=="CellLayout"){
                this.chunk[i].resetChunkElemPosition();            
            }
            x+=this.chunk[i].width;
            if(this.chunk[i+1]){
                if(this.chunk[i+1].width+x>this.width){
                    x=0;y=bigHeight+this.chunk[i].y;
                    bigHeight=0;
                }
            }
        }
    }
    //布局内的元素重新确定所属布局(用于表格布局元素重新确定控件所属单元格)
    resetElementToChunk(){
        if(this._currentChunk.resetElementToChunk)
        this._currentChunk.resetElementToChunk(this._currentElem);
        console.log(this.chunk)
    }
    //布局内的元素重新确定所属布局(暂时用于flowlayout布局，不确定是否通用)
    resetElementChunk(){
        //先拿到event下的id，然后判断是不是容器id，
        let ev = window.event || arguments.callee.caller.arguments[0];
        let data=ev.dataTransfer.getData("Text");
        let delElm=null;
        // let isChunk=false;
        //先判断给的chunkid是布局元素,因为可能会不小心放在元素的区域内
        // if(this._currentChunkId){
        //     for(let j=0;j<this.chunk.length;j++){
        //         if(this.chunk[j].id==this._currentChunkId && (this.chunk[j].scope=="FlowLayout"||this.chunk[j].scope=="CellLayout")){
        //             isChunk=true;
        //             break;
        //         }else if(this.chunk[j].element && this.chunk[j].element.length>0){
        //             isChunk=this.chunk[j].elemIsChunk(this._currentChunkId)
        //         }else{
        //             isChunk=false;
        //         }
        //     }
        // }
        //先循环trunk，然后找到对应id的元素，吧这个元素从这个区域中删除
        if(this._currentChunkId&& this._currentElemId){
            for(let i=0;i<this.chunk.length;i++){
                if(this.chunk[i].id==this._currentElemId){
                    delElm=this.chunk[i];
                    this.chunk.splice(i,1);
                    this._currentElemId=null;

                    break;
                }else{
                    if( this.chunk[i].element&&this.chunk[i].element.length>0){
                        delElm=this.chunk[i].delElem(this._currentElemId);
                        if(delElm){
                            this._currentElemId=null;
                        }
                        
                    }
                }
            }

            if(this._currentChunkId=="formBoard" && delElm){
                //再把这个元素加到容器内
                delElm.isblock="false";
                this.addElement(delElm)
                this._currentChunkId=null;

            }else if(delElm){
                // 然后在循环trunk，将这个元素加入到对应id的区域中
                for(let a=0;a<this.chunk.length;a++){
                    if(this.chunk[a].id==this._currentChunkId){
                        if(this.chunk[a].scope=="FlowLayout"){
                            delElm.isblock="false";
                            delElm.width=delElm.preWidth?delElm.preWidth:delElm.width;
                        }else if(this.chunk[a].scope=="CellLayout"){
                            delElm.isblock="true";
                            delElm.preWidth=delElm.width;
                            delElm.width=this.width;
                        }
                        this.chunk[a].element.push(delElm);
                        this.chunk[a].resetChunkElemPosition()
                        this._currentChunkId=null;

                    }else{
                        if(this.chunk[a].element && this.chunk[a].element.length>0){
                            this.chunk[a].addElem(this._currentChunkId,delElm);
                            this._currentChunkId=null;
                        }
                    }
                    
                }
            }
            this.resetChunkPosition();
        }else{
            return false;
        }
    }
    //鼠标按下判断是否选择区域//此时还要判断当前鼠标是否在布局下布局区域
    selectedChunk(x,y){
        const len=this.chunk.length;
        for(let i=0;i<len;i++){
            if(this.chunk[i].x-5<x&&this.chunk[i].x+this.chunk[i].width+5>x&&this.chunk[i].y-5<y&&this.chunk[i].y+this.chunk[i].height+5>y){
                // if(this.chunk.element.length>0){
                //     let elemLength=this.chunk.element.length;
                    
                // }
                return this.chunk[i];
            }
            
        }
        return false;
    }
    // getSelectedElem(length,x,y){
    //     for(let j=0;j<length;j++){
    //         if(this._currentChunk.element[j].scope=="FlowLayout"){
    //             if(this._currentChunk.element[j].x-5<x&&this._currentChunk.element[j].x+this._currentChunk.element[j].width+5>x&&this._currentChunk.element[j].y-5<y&&this._currentChunk.element[j].y+this._currentChunk.element[j].height+5>y){
    //                 return this._currentChunk.element[j];
    //             }  
    //         }
            
    //     }
    // }
    /**
     * 确认当前鼠标选中的是table下面的哪一个tr,哪一个td
     * 2019.12.13 在tr层不进行判断，因为合并单元格之后tr的高度是不变的。但是如果不在tr层进行判断，这样就拿不到正确的行数，不能在这里拿到正确的行数传回去，
     *  */
    selectedChunkPart(x,y){
        let currentChunk = this._currentChunk;
        let row=null,col=null,realrow=null;
        if(currentChunk){
            let len=currentChunk.trs.length;
            for(let i=0;i<len;i++){
                // if(currentChunk.trs[i].y-5<y&&currentChunk.trs[i].y+currentChunk.trs[i].height+5>y){
                //     row=currentChunk.trs[i].rowIndex;
                // }
                    for(let j=0;j<currentChunk.trs[i].tds.length;j++){
                        if( currentChunk.trs[i].tds[j].x-5<x && currentChunk.trs[i].tds[j].x+currentChunk.trs[i].tds[j].width+5>x && currentChunk.trs[i].tds[j].y-5<y  && currentChunk.trs[i].tds[j].y+currentChunk.trs[i].tds[j].height+5>y){
                            // console.log({"nowRowIndex":i,"nowColIndex":j})
                            if(currentChunk.trs[i].tds[j].rowspan!==1){
                                for(let k=0;k<len;k++){
                                    if(currentChunk.trs[k].y-5<y&&currentChunk.trs[k].y+currentChunk.trs[k].height+5>y){
                                        realrow=currentChunk.trs[k].rowIndex;
                                        this.cellHaveRowspan=true;
                                    }
                                }
                            }else{
                                this.cellHaveRowspan=false;
                                realrow=currentChunk.trs[i].tds[j].rowIndex;
                            }
                            row=currentChunk.trs[i].tds[j].rowIndex;
                            col=currentChunk.trs[i].tds[j].colIndex;
                            return {"nowRowIndex":row,"nowColIndex":col,"realRowIndex":realrow}
                        }
                    }
                    // return i;
                // }
            }
            return false;
        }
    }
    //判断鼠标按下是否选择表格布局区域下的元素
    selectedTableChunkElement(x,y){
        if(this._currentChunk.element.length>0){
            let elementLength=this._currentChunk.element.length
            for(let j=0;j<elementLength;j++){
                if(this._currentChunk.element[j].x<x&&this._currentChunk.element[j].x+this._currentChunk.element[j].width>x&&this._currentChunk.element[j].y<y&&this._currentChunk.element[j].y+this._currentChunk.element[j].height>y){
                    let element=this._currentChunk.element[j];//table下面的某个小区域
                    let elementFirst=this._currentChunk.element[0];
                    if(element.childrens.length>0){
                        let childrensLength=element.childrens.length;
                        for(let k=0;k<childrensLength;k++){
                            if(elementFirst.x+element.childrens[k].x<x&&elementFirst.x+element.childrens[k].x+element.childrens[k].width*(j%this._currentChunk.cols+1)>x&&elementFirst.y+element.childrens[k].y<y&&elementFirst.y+element.childrens[k].y+element.childrens[k].height*(Math.ceil((j+1)/this._currentChunk.rows))>y){
                                return element.childrens[k]
                            }
                        }

                    }
                }
            }                    
        }
        return false;
    }
    //判断鼠标按下是否选择元素
    /**
     * 现在看来主要是用在鼠标按下的时候
     *应该在每个布局元素中写一个方法，判断当前鼠标是否在自己下面的元素中，返回元素或者false
     */
    selectedChunkElement(x,y){
        if(this._currentChunk.element.length>0){
            // let elementLength=this._currentChunk.element.length
            // for(let j=0;j<elementLength;j++){
            //     if(this._currentChunk.element[j].x<x&&this._currentChunk.element[j].x+this._currentChunk.element[j].width>x&&this._currentChunk.element[j].y<y&&this._currentChunk.element[j].y+this._currentChunk.element[j].height>y){
            //         //判断如果是布局下的布局，要返回下一层布局
            //         // if(this._currentChunk.element[j].scope=="FlowLayout" && this._currentChunk.element[j].element.length>0){
            //         //     for(let i=0;i<this._currentChunk.element[j].element.length;i++){
            //         //         if(this._currentChunk.element[j].element[i].x<x && this._currentChunk.element[j].element[i].x+this._currentChunk.element[j].element[i].width>x && this._currentChunk.element[j].element[i].y<y && this._currentChunk.element[j].element[i].y+this._currentChunk.element[j].element[i].height>y){
            //         //             return this._currentChunk.element[j].element[i];
            //         //         }
            //         //     }
            //         // }
            //         return this._currentChunk.element[j];
            //     }
            // }   
            let currentElem = this._currentChunk.selectedElement(x,y);    
            console.log(currentElem,"鼠标按下的元素")
            return currentElem;             
        }
        return false;
    }
    //添加非布局元素到区域中
    addElement(elem){
        this.chunk.push(elem);
        this.allNameNow.push({"name":elem.name})
        this.refreshTreeList();
    }
    //添加非布局元素到布局元素中
    addElementToChunk(elem){
        elem.zIndex=100;
        let {x,y}=this._currentChunk.setElementPosition(elem);
        elem.x=x;elem.y=y;
        if(elem.scope=="FlowLayout" || elem.scope=="CellLayout"){
            elem.height=this._currentChunk.getnoUseHeight()*0.8;
            // elem.height=elem.height
        }
        this.allNameNow.push({"name":elem.name})
        this._currentChunk.addElement(elem);
        this.refreshTreeList();
    }
    refreshTreeList(){
        const tree = Tree.getInstance();
		tree.render();
    }
    transformToTree() {
        let tree=[];
        const len=this.chunk.length;
        for(let i=0;i<len;i++){
            let data = this.chunk[i].getNodeConfigInfo();
            tree.push(data);
        }
        if(tree.length==0){
            // return false;
        }
        return tree;
    }
    getCurrToEdit(){
        if(this._currentChunk && this._currentElem){
            return this._currentElem;
        }else if(this._currentChunk && !this._currentElem){
            return this._currentChunk;

        }
        // else{
        // return this._currentPropElem;
        // }
    }
    clearCurrToEdit(){
        if(this._currentChunk){
            this._currentChunk.setProps({isEdit:false})
        }
        this._currentChunk=null;
        this.elem=null;
    }
    //获取所有部门选择框的字段
    getallDeptName(name){
        let allDeptName={};
        for(let i=0;i<this.chunk.length;i++){
            if(this.chunk[i].scope=="dept"){
                allDeptName[this.chunk[i].name]="false";
                //allDeptName.push(data)
            }else if(this.chunk[i].scope=="FlowLayout" || this.chunk[i].scope=="CellLayout"){
                allDeptName={...allDeptName,...this.chunk[i].getallDeptName()}

            }
        }
        delete allDeptName[name];
        return allDeptName;
    }
    //删除最外层的元素
    deleteChunk(id){
        let delInd=null;
        for(let i=0;i<this.chunk.length;i++){
            if(this.chunk[i].id==id){
                delInd=i;
                break;
            }
        }
        if(delInd!=null){
            this.allNameNow.forEach((el,index)=>{
                if(el.name==this.chunk[delInd].name){
                    this.allNameNow.splice(index,1)
                }
            })
            this.chunk.splice(delInd,1);
            this.resetChunkPosition();
            this._currentChunk=null;
        }
    }
    deleteElem(chunkId,elemId){
        //这个方法只用在这里，所以做个单独优化：chunkid只记录最外层id，所以调用元素的deleteelem方法来处理，然后在把name返回用来删除allnamenow的值
        let delInd=null,delCInd=null,name=null;
        for(let i=0;i<this.chunk.length;i++){
            if(this.chunk[i].id==chunkId){
                // delCInd=i;
                // for(let j=0;j<this.chunk[i].element.length;j++){
                //     if(this.chunk[i].element[j].id==elemId){
                //         delInd=j;
                //     }
                // }
                name=this.chunk[i].deleteElem(elemId);

            }
        }
        if(name!=null){
            this.allNameNow.forEach((el,index)=>{
                if(el.name==name){
                    this.allNameNow.splice(index,1)
                }
            })
            // this.chunk[delCInd].element.splice(delInd,1);
            this.resetChunkPosition();
            this._currentChunk=null;
        }
    }
    setAllProcesspreValue(){
        for(let i=0;i<this.chunk.length;i++){
            if(this.chunk[i].scope!="FlowLayout" && this.chunk[i].scope!="CellLayout"){
                this.chunk[i].processprevalue=this.getAllNameScript();
            }else{
                this.chunk[i].setAllProcesspreValue(this.getAllNameScript());
            }
        }
    }
    // 拿到已保存的字段的名字和value組成的字符串
    getAllNameScript(){
        let h=JSON.stringify(this.allName).replace(/"/g,"'");
        h+=";";
        console.log(h);
        return h

    }
    toCheck(){
        for(let i=0;i<this.chunk.length;i++){
            let check=this.chunk[i].toCheck();
            if(!check){
                return check;
            }
        }
        return true;
    }

}
FormPanel.ACTION_NORMAL = 0x00000000;
FormPanel.ACTION_IN_ELEMENT = 0x00000001;
FormPanel.ACTION_IN_BASELINE = 0x00000010;
FormPanel.ACTION_ARCHOR_UPPER_LEFT = 0x00000011;
FormPanel.ACTION_ARCHOR_UPPER_RIGHT = 0x00000012;
FormPanel.ACTION_ARCHOR_LOWER_LEFT = 0x00000013;
FormPanel.ACTION_ARCHOR_LOWER_RIGHT = 0x00000014;
export default FormPanel;