import Element from './Element';
import {Sequence} from '../../utility';
class Viewdialogfield extends Element{
    constructor(){
        super();
        this.width=170;
        this.height=30;
        this.name="";//唯一标识
        this.text="viewdialogfield";
        this.cursor="default";
        this.scope="viewdialogfield";
        this.id = Sequence.createUuid();
        this.belongId="";
        this.preX=0;
        this.preY=0;
        this.moveX=0;
        this.moveY=0;
        this.value="视图选择框";//值
        this.refreshonchanged="false";//刷新
        this.calculateonrefresh="false";//冲计算
        this.mobile="true";//手机可用
        this.refreshmode=0;//冲刷新的方式
        
        this.hiddenscript="";//隐藏条件脚本
        this.hiddenvalue="";//隐藏时显示值
        this.hiddenprintscript="";//打印时隐藏条件脚本
        this.printhiddenvalue="";//打印隐藏时显示值
        this.readonlyscript="";//只读条件脚本
        this.refreshfields=[];//局部刷新的字段组合

        this.smallwidth=100;

        this.caption="";//说明文字
        this.module="";//模块
        this.dialogview="";//视图
        this.opentype="弹出层显示";//打开类型
        this.maximization="default";//显示大小
        this.divwidth="";
        this.divheight="";
        this.selectone="false";//拼接模式
        this.mutilselect="false";//多项选择
        this.allowviewdoc="false";//允许查看文档
        this.mapping=[];//映射
        this.okscript=""//确定条件脚本
        this.callbackscript=""//确定后执行脚本
        

    }
    toHtml(){}
    
    paint(){
        // if(this.x==0&&this.y==0){
        //     this.x=this.left;
        //     this.y=this.top;
        // }else{
        //     this.left=this.x;
        //     this.top=this.y;
        // }
        //console.log(panel);
        let map=JSON.stringify(this.mapping).replace(/"/g,"'");
        let h="";
        if (this.isblock == "true") {
            h = `<span type="f-img" class="block"`;
          } else {
            h = `<span type="f-img" class="inlineBlock"`;
          }
          h +=` id="${this.id}" draggable="true" style="min-width:${this.width}px;min-height:${this.height}px;margin-bottom:${this.marginbottom}px;margin-top:${this.margintop}px;">`
          
        if(this.isshowlabel=="true" || this.isshowlabel==true){
            h+=`<f-label style="line-height:${this.height}px;">${this.labelvalue}</f-label>`
        }
            h+=`<f-img  classname="cn.myapps.runtime.dynaform.form.ejb.ViewDialogField" type="text" nodeid="${this.id}" class="inlineBlock" minwidth="${this.width}" style="`
            
            if(this.isChecked){
                h += `border:1px solid #40a9ff;`;
            }else{
                h += `border:1px solid #ccc;`;
            }
            h+=`min-width:${this.smallwidth}px;min-height:${this.height}px;`;
          
            
            if(this.zIndex){
                h+=`z-index:`+this.zIndex+`;`;
            }
            h+=`" name="${this.name}" isshowlabel="${this.isshowlabel}" labelvalue="${this.labelvalue}"
            refreshonchanged="${this.refreshonchanged}" 
            calculateonrefresh="${this.calculateonrefresh}" mobile="${this.mobile}"
            refreshmode="${this.refreshmode}" maximization="${this.maximization}"
            hiddenscript="${this.encode(this.hiddenscript)}" hiddenvalue="${this.hiddenvalue}" 
            hiddenprintscript="${this.encode(this.hiddenprintscript)}" 
            printhiddenvalue="${this.printhiddenvalue}" readonlyscript="${this.encode(this.readonlyscript)}"
            caption="${this.caption}" module="${this.module}"
            dialogview="${this.dialogview}" opentype="${this.opentype}" mapping="${map}"
            okscript="${this.encode(this.okscript)}" callbackscript="${this.encode(this.callbackscript)}"
            divwidth="${this.divwidth}" divheight="${this.divheight}"
            `;
           

            h+=`refreshfields="`;
            if(this.refreshfields.length>0){
                for(let i=0;i<this.refreshfields.length;i++){
                    h+=this.refreshfields[i];
                    if(i!=this.refreshfields.length-1){
                        h+=";";
                    }
                }
            }

            h+=`"`+

            `>`+
            this.value+
            `</f-img></span>`
        return h;
    }
    
    getNodeConfigInfo(){
        let node = {};
		node.text = this.text;
		node.icon = 'glyphicon glyphicon-star-empty';
		node.uuid = this.getProp('id');	
		node.instance = this;
		return node;
    }

    toCheck(){
        if(this.name==""){
            alert("组件名称不能为空")
            return false;
        }
        if(this.module==""){
            alert(this.name+"的模块字段不能为空")
            return false;
        }
        if(this.dialogview==""){
            alert(this.name+"的视图字段不能为空")
            return false;
        }
        if(this.mapping==[]){
            alert(this.name+"的映射字段不能为空")
            return false;
        }
        return true;
    }
}
export default Viewdialogfield;