import Element from './Element';
import {Sequence} from '../../utility';
class Tabfield extends Element{
    constructor(){
        super();
        this.name="";
        this.width=170;
        this.height=30;
        this.cursor="default";
        this.scope="tabfield";
        this.text="tabfield";
        this.id = Sequence.createUuid();
        this.preX=0;
        this.preY=0;
        this.moveX=0;
        this.moveY=0;
        this.value="选项卡";//值
        this.smallwidth=100;
        this.showmode="0";//
        this.allowsamename="false";
        this.relstr=[];//选项卡内容
        // {
        //     name:"",
        //     type:"",
        //     moduleId:"",
        //     formId:"",
        //     formIds:[],
        //     hiddenScript:"",
        //     readOnlyScript:"",
        //     hiddenPrintScript:"",
        //     refreshOnChanged:false,
        //     calculateOnRefresh:false,
        //     relate:false,

        // }
        this.selectedscript="";//页签脚本
    }
    toHtml(){}
    
    paint(){
        let h="";
        if (this.isblock == "true") {
            h = `<span type="f-img" class="block"`;
          } else {
            h = `<span type="f-img" class="inlineBlock"`;
          }
          h +=` id="${this.id}" draggable="true" style="min-width:${this.width}px;min-height:${this.height}px;margin-bottom:${this.marginbottom}px;margin-top:${this.margintop}px;">`
          
        if(this.isshowlabel=="true" || this.isshowlabel==true){
            h+=`<f-label style="line-height:${this.height}px;">${this.labelvalue}</f-label>`
        }
            h+=`<f-img type="tabfield"  classname="cn.myapps.runtime.dynaform.form.ejb.TabField" nodeid="${this.id}" class="inlineBlock" minwidth="${this.width}" style="`
            
            if(this.isChecked){
                h += `border:1px solid #40a9ff;`;
            }else{
                h += `border:1px solid #ccc;`;
            }
            h+=`min-width:${this.smallwidth}px;min-height:${this.height}px;`;
          
            
            if(this.zIndex){
                h+=`z-index:`+this.zIndex+`;`;
            }
            h+=`" name="${this.name}"  isshowlabel="${this.isshowlabel}" labelvalue="${this.labelvalue}" 
            showmode="${this.showmode}" allowsamename="${this.allowsamename}" selectedscript="${this.encode(this.selectedscript)}" `
            if(this.relstr.length>0){
                // for(let i=0;i<this.relstr.length;i++){
                //    if(this.relstr[i].name==""){
                //     this.relstr.splice(i,1);
                //     if(i!=0)i=i-1;
                //    }
                
                // }
                let arr=[...this.relstr];
                let {formIds, ...data} = this.relstr;
                this.relstr.forEach((elm,index)=>{
                    let {formIds, ...data} = elm;
                    // elm=data;
                    arr[index]=JSON.stringify(data).replace(/"/g,"'");
                })
                h+=`relstr="[`+arr.join("---")+`]"`;
            }else {
                h+=`relstr=""`;
            }
            h+=`;`
            h+=`"`+
            `>`+
            this.value+
            `</f-img></span>`
        return h;
    }
    
    getNodeConfigInfo(){
        let node = {};
		node.text = this.name;
		node.icon = 'glyphicon glyphicon-user';
		node.uuid = this.getProp('id');	
		node.instance = this;
		return node;
    }
}
export default Tabfield;