import Element from "./Element";
import { Sequence } from "../../utility";
class Qrcodefield extends Element {
  constructor() {
    super();
    this.width = 170;
    this.height = 30;
    this.name = ""; //唯一标识
    this.text = "qrcodefield";
    this.cursor = "default";
    this.scope = "qrcodefield";
    this.id = Sequence.createUuid();
    this.belongId = "";
    this.preX = 0;
    this.preY = 0;
    this.moveX = 0;
    this.moveY = 0;
    this.value = "二维码控件"; //值
    this.discript = ""; //描述

    this.hiddenscript = ""; //隐藏条件脚本
    this.hiddenvalue = ""; //隐藏时显示值
    this.hiddenprintscript = ""; //打印时隐藏条件脚本
    this.printhiddenvalue = ""; //打印隐藏时显示值

    this.smallwidth = 100;
    this.mobile="true";//手机可用
    this.readonlyscript="";//只读脚本
    this.valuescript="";//内容脚本
    this.calculateonrefresh="false";//重计算
    this.size=0;//大小
    this.handletype="text";//扫码处理方式
  }
  toHtml() {}

  paint() {
    // if(this.x==0&&this.y==0){
    //     this.x=this.left;
    //     this.y=this.top;
    // }else{
    //     this.left=this.x;
    //     this.top=this.y;
    // }
    //console.log(panel);

    let h = "";
    if (this.isblock == "true") {
      h = `<span type="f-img" class="block"`;
    } else {
      h = `<span type="f-img" class="inlineBlock"`;
    }
    h +=` id="${this.id}" draggable="true" style="min-width:${this.width}px;min-height:${this.height}px;margin-bottom:${this.marginbottom}px;margin-top:${this.margintop}px;">`
    
    if (this.isshowlabel == "true" || this.isshowlabel == true) {
      h += `<f-label style="line-height:${this.height}px;">${this.labelvalue}</f-label>`;
    }
    h += `<f-img type="text" nodeid="${this.id}" class="inlineBlock" minwidth="${this.width}" style="`;
    
    if(this.isChecked){
      h += `border:1px solid #40a9ff;`;
    }else{
      h += `border:1px solid #ccc;`;
    }
    h+=`min-width:${this.smallwidth}px;min-height:${this.height}px;`;

    
    if (this.zIndex) {
      h += `z-index:` + this.zIndex + `;`;
    }
    h += `" name="${this.name}" classname="cn.myapps.runtime.dynaform.form.ejb.QRCodeField" isshowlabel="${this.isshowlabel}" labelvalue="${this.labelvalue}"  
            fieldtype="VALUE_TYPE_TEXT"
            discript="${this.encode(this.discript)}"
            hiddenscript="${this.encode(this.hiddenscript)}" hiddenvalue="${this.hiddenvalue}" 
            hiddenprintscript="${this.encode(this.hiddenprintscript)}" 
            printhiddenvalue="${this.encode(this.printhiddenvalue)}"
            mobile="${this.mobile}"
            readonlyscript="${this.encode(this.readonlyscript)}"
            valuescript="${this.encode(this.valuescript)}"
            calculateonrefresh="${this.calculateonrefresh}"
            size="${this.size}" handletype="${this.handletype}"
            `;
    h += `>` + this.value + `</f-img></span>`;
    return h;
  }

  getNodeConfigInfo() {
    let node = {};
    node.text = this.text;
    node.icon = "glyphicon glyphicon-signal";
    node.uuid = this.getProp("id");
    node.instance = this;
    return node;
  }
}
export default Qrcodefield;
