import Element from './Element';
import {Sequence} from '../../utility';
class Includefield extends Element{
    constructor(){
        super();
        this.width=170;
        this.height=30;
        this.name="";//唯一标识
        this.text="Includefield";
        this.cursor="default";
        this.scope="includefield";
        this.id = Sequence.createUuid();
        this.belongId="";
        this.preX=0;
        this.preY=0;
        this.moveX=0;
        this.moveY=0;
        this.value="包含元素";//值
        this.editmode="00";//值方式
        this.isdefaultvalue="false"//是否是默认值
        this.refreshonchanged="false";//刷新
        this.calculateonrefresh="false";//冲计算
        this.valuescript='';//脚本值
        this.refreshmode=0;//冲刷新的方式
        
        
        this.hiddenscript="";//隐藏条件脚本
        this.hiddenvalue="";//隐藏时显示值
        this.hiddenprintscript="";//打印时隐藏条件脚本
        this.printhiddenvalue="";//打印隐藏时显示值
        this.processdescription="";//值设计脚本的值
        this.refreshfields=[];//局部刷新的字段组合

        this.smallwidth=100;

        this.includetype="0";//包含元素类型
        this.module="none";//模块
        this.viewid="";//视图
        this.relate="true";//是否为父子关系
        this.fixation="false";//固定高度
        this.fixationheight=0;//固定高度的高度
    }
    toHtml(){}
    
    paint(){
        // if(this.x==0&&this.y==0){
        //     this.x=this.left;
        //     this.y=this.top;
        // }else{
        //     this.left=this.x;
        //     this.top=this.y;
        // }
        //console.log(panel);
        
        let h="";
        if (this.isblock == "true") {
            h = `<span type="f-img" class="block"`;
          } else {
            h = `<span type="f-img" class="inlineBlock"`;
          }
          h +=` id="${this.id}" draggable="true" style="min-width:${this.width}px;min-height:${this.height}px;margin-bottom:${this.marginbottom}px;margin-top:${this.margintop}px;">`
          
        if(this.isshowlabel=="true" || this.isshowlabel==true){
            h+=`<f-label style="line-height:${this.height}px;">${this.labelvalue}</f-label>`
        }
            h+=`<f-img type="text" classname="cn.myapps.runtime.dynaform.form.ejb.IncludeField" nodeid="${this.id}" class="inlineBlock" minwidth="${this.width}" style="`
            
            if(this.isChecked){
                h += `border:1px solid #40a9ff;`;
            }else{
                h += `border:1px solid #ccc;`;
            }
            h+=`min-width:${this.smallwidth}px;min-height:${this.height}px;`;
          
            
            if(this.zIndex){
                h+=`z-index:`+this.zIndex+`;`;
            }
            h+=`" name="${this.name}" isshowlabel="${this.isshowlabel}" labelvalue="${this.labelvalue}"
            
            isdefaultvalue="${this.isdefaultvalue}" refreshonchanged="${this.refreshonchanged}" 
            calculateonrefresh="${this.calculateonrefresh}"
            refreshmode="${this.refreshmode}" 
            hiddenscript="${this.encode(this.hiddenscript)}" hiddenvalue="${this.hiddenvalue}" 
            hiddenprintscript="${this.encode(this.hiddenprintscript)}" 
            printhiddenvalue="${this.printhiddenvalue}" 
            processdescription="${this.processprevalue}[${this.encode(this.processdescription)}]"
            editmode="${this.editmode}" valuescript="${this.encode(this.valuescript)}"
            includetype="${this.includetype}" module="${this.module}"
            viewid="${this.viewid}" relate="${this.relate}"
            fixation="${this.fixation}"
            fixationheight="${this.fixationheight}px"
            `;
           

            h+=`refreshfields="`;
            // processdescription="${this.processdescription}"
            if(this.refreshfields.length>0){
                for(let i=0;i<this.refreshfields.length;i++){
                    h+=this.refreshfields[i];
                    if(i!=this.refreshfields.length-1){
                        h+=";";
                    }
                }
            }

            h+=`"`+

            `>`+
            this.value+
            `</f-img></span>`
        return h;
    }
    
    getNodeConfigInfo(){
        let node = {};
		node.text = this.text;
		node.icon = 'glyphicon glyphicon-th-large';
		node.uuid = this.getProp('id');	
		node.instance = this;
		return node;
    }

    toCheck(){
        if(this.name==""){
            alert("组件名称不能为空")
            return false;
        }
        if(this.module==""){
            alert(this.name+"的模块字段不能为空")
            return false;
        }
        if(this.viewid==""){
            alert(this.name+"的视图字段不能为空")
            return false;
        }
        return true;
    }
}
export default Includefield;