import Element from "./Element";
import { Sequence } from "../../utility";
class Imageuploadfield extends Element {
  constructor() {
    super();
    this.width = 170;
    this.height = 30;
    this.name = ""; //唯一标识
    this.text = "imageuploadfield";
    this.cursor = "default";
    this.scope = "imageuploadfield";
    this.id = Sequence.createUuid();
    this.belongId = "";
    this.preX = 0;
    this.preY = 0;
    this.moveX = 0;
    this.moveY = 0;
    this.value = "图片上传"; //值
    this.readonlyshowvalonly = "true"; //只读时仅只显示值
    this.refreshonchanged = "false"; //刷新
    this.calculateonrefresh = "false"; //冲计算
    this.valuescript = ""; //脚本值
    this.mobile="true"; //手机可用
    this.discript = ""; //描述
    this.refreshmode = 0; //冲刷新的方式

    this.hiddenscript = ""; //隐藏条件脚本
    this.hiddenvalue = ""; //隐藏时显示值
    this.hiddenprintscript = ""; //打印时隐藏条件脚本
    this.printhiddenvalue = ""; //打印隐藏时显示值
    this.readonlyscript = ""; //只读条件脚本
    this.refreshfields = []; //局部刷新的字段组合

    this.smallwidth = 100;
    this.limitsize = ""; //限制单个上传文件大小
    this.limitnumber=10;//最大上传数量
    this.filepattern="00";//存放路径
    this.filecatalog="";//自定义存放路径
    this.imgh=100;//存放路径
    this.imgw=100;//自定义存放路径
  }
  toHtml() {}

  paint() {
    // if(this.x==0&&this.y==0){
    //     this.x=this.left;
    //     this.y=this.top;
    // }else{
    //     this.left=this.x;
    //     this.top=this.y;
    // }
    //console.log(panel);

    let h = "";
    if (this.isblock == "true") {
      h = `<span type="f-img" class="block"`;
    } else {
      h = `<span type="f-img" class="inlineBlock"`;
    }
    h +=` id="${this.id}" draggable="true" style="min-width:${this.width}px;min-height:${this.height}px;margin-bottom:${this.marginbottom}px;margin-top:${this.margintop}px;">`
    
    if (this.isshowlabel == "true" || this.isshowlabel == true) {
      h += `<f-label style="line-height:${this.height}px;">${this.labelvalue}</f-label>`;
    }
    h += `<f-img type="text" nodeid="${this.id}" class="inlineBlock" minwidth="${this.width}" style="`;
    
    if(this.isChecked){
      h += `border:1px solid #40a9ff;`;
    }else{
      h += `border:1px solid #ccc;`;
    }
    h+=`min-width:${this.smallwidth}px;min-height:${this.height}px;`;

    
    if (this.zIndex) {
      h += `z-index:` + this.zIndex + `;`;
    }
    h += `" name="${this.name}" fieldtype="VALUE_TYPE_TEXT" classname="cn.myapps.runtime.dynaform.form.ejb.ImageUploadField" isshowlabel="${this.isshowlabel}" labelvalue="${this.labelvalue}"  
            
            readonlyshowvalonly="${this.readonlyshowvalonly}" 
            refreshonchanged="${this.refreshonchanged}" 
            calculateonrefresh="${this.calculateonrefresh}" mobile="${this.mobile}" discript="${this.encode(this.discript)}"
            refreshmode="${this.refreshmode}"
            hiddenscript="${this.encode(this.hiddenscript)}" hiddenvalue="${this.hiddenvalue}" 
            hiddenprintscript="${this.encode(this.hiddenprintscript)}" 
            printhiddenvalue="${this.printhiddenvalue}" readonlyscript="${this.encode(this.readonlyscript)}"
            valuescript="${this.encode(this.valuescript)}"
            limitsize="${this.limitsize}"
            limitnumber="${this.limitnumber}"
            filepattern="${this.filepattern}"
            filecatalog="${this.filecatalog}"
            imgh="${this.imgh}"
            imgw="${this.imgw}"
            `;

    h += `refreshfields="`;

    // processdescription="${this.processdescription}"
    if (this.refreshfields.length > 0) {
      for (let i = 0; i < this.refreshfields.length; i++) {
        h += this.refreshfields[i];
        if (i != this.refreshfields.length - 1) {
          h += ";";
        }
      }
    }

    h += `"` + `>` + this.value + `</f-img></span>`;
    return h;
  }

  getNodeConfigInfo() {
    let node = {};
    node.text = this.text;
    node.icon = "glyphicon glyphicon-ok";
    node.uuid = this.getProp("id");
    node.instance = this;
    return node;
  }
}
export default Imageuploadfield;
