import { StringUtil } from '../../utility/index';

class Element {
    constructor(){
        this.key="";
        this.width=50;
        this.height=50;
        this.id="";
        this.x=0;
        this.y=0;
        this.left=0;
        this.top=0;
        this.xByElement=0;
        this.yByElement=0;
        this._handlePointX=0;
        this._handlePointY=0;
        this.belong=null;
        this.isEdit=false;
        this.borderWidth=1;

        //公用属性
        // this.panelWidth=0;
        this.isshowlabel=true;
        this.labelvalue="默认标签：";
        this.isblock="false";
        this.labelWidth=70;
        this.processprevalue="";//用來存儲頁面上已保存的字段的name和value組成的數組字符串
        this.margintop=0;
        this.marginbottom=10;
        this.isChecked=false;
        
    }
    setProps(newProps, isCloneProps = false) {
        if(isCloneProps) {
            this.oldProps = this.cloneProps(this);
        }
        
        if((newProps['font'] || newProps['paragraph']) && !newProps['mode']) {
            if(newProps['font']) {
                Object.assign(this.font, newProps['font']);	
            } else if(newProps['paragraph']) {
                Object.assign(this.paragraph, newProps['paragraph']);	
            }
        } else {
            //注意！此方法对一层树结构合并没问题，但若是对象里的属性还是一个对象，则进行合并时，该属性里的对象会被覆盖而非合并操作
            Object.assign(this, newProps);
        }
        
        //在属性合并完成后单独对相对于画布左上角的y(this.y)和打印时输出的y(this.printedY)进行调整
        if(typeof newProps.printedY === 'undefined') {
            this.printedY = this.y - this.prevChunkBaseline;	
        } else  {
            this.y = this.prevChunkBaseline + this.printedY;
        }
    }
    getProp(prop) {
		if(this[prop] !== null && this[prop] !== undefined) {
		  return this[prop];	
		} else if(this.font[prop] !== null && this.font[prop] !== undefined) {
		  return this.font[prop];
		} else if(this.paragraph[prop] !== null && this.paragraph[prop] !== undefined) {
			return this.paragraph[prop];
		}
		
		return (undefined);
    }
    changeElementPosition(position) {
		
		if(typeof position != 'object') {
			return false;
		}
		
		let movedX, movedY = 0;
		let elementPos = {};

		if(position.x && !position.y) {
			movedX = position.x - this._handlePointX;
			elementPos.x = this.x + movedX;
			
			this.setProps({x: elementPos.x, _handlePointX: position.x});
		} else if(position.y && !position.x) {
			movedY = position.y - this._handlePointY;
			elementPos.y = this.y + movedY;
			
			this.setProps({y: elementPos.y, _handlePointY: position.y});
		} else if(position.y && position.x) {
			movedX = position.x - this._handlePointX;
			movedY = position.y - this._handlePointY;
			elementPos.x = this.x + movedX;
			elementPos.y = this.y + movedY;
			
			this.setProps({x: elementPos.x, y: elementPos.y, _handlePointX: position.x, _handlePointY: position.y});
		} else {
			return false;
		}
    }
    parseHtml(html){
        // let label=$(html.children[0])
        let elem=$(html.children[1])[0];
        //样式
        // console.log(style);
        let obj={};
        for(let key in elem.attributes){
            switch(elem.attributes[key].name){
                case "style":
                    let style=elem.attributes[elem.attributes[key].name].value;

                    do{
                        
                        let i=style.indexOf(":");
                        let key2 = style.slice(0,i);
                        style=style.slice(i+1);
            
                        let j=style.indexOf(";");
                        let val=style.slice(0,j);
                        style=style.slice(j+1);
                        if(key2=="min-width"|| key2=="min-height" || key2=="z-index"){
                            if(key2=="min-width"){
                                obj["smallwidth"]=parseFloat(val);
                            }else if(key2=="min-height"){
                                obj["height"]=parseFloat(val);
                            }else{
                                obj[key2]=parseFloat(val);
                            }
                        }else{
                            obj[key2]=val;
                        }
            
                    }while(style.length!=0);
                break;
                case "refreshfields":
                    let refreshfields=elem.attributes[elem.attributes[key].name].value.split(";");
                    if(refreshfields==""){
                        obj.refreshfields=[]
                    }else{
                        obj.refreshfields=refreshfields;
                    }
                break;
                case "mapping":
                    obj.mapping=JSON.parse(elem.attributes[key].value.replace(/'/g,"\""))
                break;
                case "relstr":
                    let arr=elem.attributes[key].value.replace(/\[/,"").replace(/\]/,"").split("---");
                    let str=[...arr];
                    if(arr!=""){
                        arr.forEach((elm,ind)=>{
                            str[ind]=JSON.parse(elm.replace(/'/g,"\""));
                        })
                    }
                    
                    //JSON.parse(elem.attributes[key].value.replace(/'/g,"\""))
                    obj.relstr=str;
                break;
                case "processdescription":
                    obj.processdescription=elem.attributes[key].value!=""?elem.attributes[key].value.split(";[")[1].replace(/]/,""):""; 
                break;
                default:
                    if(elem.attributes[key].name&&elem.attributes[key].value){
                        if(elem.attributes[key].name=="minwidth"){
                            obj["width"] = parseFloat(elem.attributes[key].value)
                        }else if(elem.attributes[key].name=="fixationheight"){
                            obj["fixationheight"] = parseFloat(elem.attributes[key].value)
                        }else if(elem.attributes[key].name=="nodeid"){
                            obj["id"] = elem.attributes[key].value
                        }else if(elem.attributes[key].name=="discript" || elem.attributes[key].name=="hiddenscript" || elem.attributes[key].name=="hiddenprintscript" || elem.attributes[key].name=="readonlyscript" || elem.attributes[key].name=="processdescription" || elem.attributes[key].name=="valuescript" || elem.attributes[key].name=="hiddenscript" || elem.attributes[key].name=="hiddenscript" || elem.attributes[key].name=="hiddenscript" || elem.attributes[key].name=="hiddenscript" || elem.attributes[key].name=="hiddenscript" ){
                            obj[elem.attributes[key].name]=StringUtil.dencodeHTML(elem.attributes[key].value);
                        }else{
                            obj[elem.attributes[key].name]=elem.attributes[key].value;
                        }
                        

                    }
                break;
            }
        }
        // let value=elem.innerHTML;
        // obj["value"]=value;
        this.setProps(obj);
        console.log(obj)
    }
    toCheck(){
        if(this.name==""){
            alert("组件名称不能为空")
            return false;
        }
        return true;
    }

    encode(data){
        return StringUtil.encodeHTML(data);
    }
    
}
export default Element;