import Element from './Element';
import {Sequence} from '../../utility';
class Data extends Element{
    constructor(){
        super();
        this.width=170;
        this.height=50;
        this.name="";//唯一标识
        this.text="data";
        this.cursor="default";
        this.scope="data";
        this.id = Sequence.createUuid();
        this.belongId="";
        this.preX=0;
        this.preY=0;
        this.moveX=0;
        this.moveY=0;
        // this.fieldtype="VALUE_TYPE_DATE"//用来标识日期选择框的参数
        this.value="日期选择框";//值
        this.datepattern="YM";//格式
        this.texttype="text";//显示
        this.isdefaultvalue="false"//是否是默认值
        this.readonlyshowvalonly="true";//只读时仅只显示值
        this.refreshonchanged="false";//刷新
        this.calculateonrefresh="false";//冲计算
        this.editmode=0;//值的方式
        this.valuescript='';//脚本值
        this.mobile="true";//手机可用
        this.discript='';//描述
        this.refreshmode=0;//冲刷新的方式

        this.validatelibs="core.dynaform.form.formfield.validate.checkPhone_system";//校验方式
        this.validaterule="";//校验脚本
        this.hiddenscript="";//隐藏条件脚本
        this.hiddenvalue="";//隐藏时显示值
        this.hiddenprintscript="";//打印时隐藏条件脚本
        this.printhiddenvalue="";//打印隐藏时显示值
        this.readonlyscript="";//只读条件脚本
        
        this.limit="false"//限制
        this.prev_name=""//开始日期字段名

        this.processdescription="";//值设计脚本的值
        this.refreshfields=[];//局部刷新的字段组合
        this.smallwidth=100;
        this.instantvalidate="false";//即时校验
    }
    toHtml(){}
    
    paint(){
        
        let h="";
        if (this.isblock == "true") {
            h = `<span type="f-input" class="block"`;
          } else {
            h = `<span type="f-input" class="inlineBlock"`;
          }
          h +=` id="${this.id}" draggable="true" style="min-width:${this.width}px;min-height:${this.height}px;margin-bottom:${this.marginbottom}px;margin-top:${this.margintop}px;">`
          
        if(this.isshowlabel=="true" || this.isshowlabel==true){
            h+=`<f-label style="line-height:${this.height}px;">${this.labelvalue}</f-label>`
        }
        h+=`<f-input classname="cn.myapps.runtime.dynaform.form.ejb.DateField" nodeid="${this.id}" class="inlineBlock" minwidth="${this.width}" style="`
        
        if(this.isChecked){
            h += `border:1px solid #40a9ff;`;
        }else{
            h += `border:1px solid #ccc;`;
        }
        h+=`min-width:${this.smallwidth}px;min-height:${this.height}px;`;
        
        if(this.zIndex){
            h+=`z-index:`+this.zIndex+`;`;
        }
        h+=`" name="${this.name}" type="text" fieldtype="VALUE_TYPE_DATE" classname="cn.myapps.runtime.dynaform.form.ejb.DateField" isshowlabel="${this.isshowlabel}" labelvalue="${this.labelvalue}" 
        datepattern="${this.datepattern}" texttype="${this.texttype}" 
        processdescription="${this.encode(this.processdescription)}" readonlyshowvalonly="${this.readonlyshowvalonly}"
        isdefaultvalue="${this.isdefaultvalue}" refreshonchanged="${this.refreshonchanged}" 
        calculateonrefresh="${this.calculateonrefresh}" mobile="${this.mobile}"
        discript="${this.encode(this.discript)}" refreshmode="${this.refreshmode}" validatelibs="${this.encode(this.validatelibs)}"
        validaterule="${this.validaterule}" hiddenscript="${this.encode(this.hiddenscript)}" hiddenvalue="${this.hiddenvalue}"
        hiddenprintscript="${this.encode(this.hiddenprintscript)}" printhiddenvalue="${this.printhiddenvalue}" readonlyscript="${this.encode(this.readonlyscript)}"
        editmode="${this.editmode}" valuescript="${this.encode(this.valuescript)}"
        limit="${this.limit}" prev_name="${this.prev_name}" instantvalidate="${this.instantvalidate}"
        `;
        h+=`refreshfields="`;
        if(this.refreshfields.length>0){
            for(let i=0;i<this.refreshfields.length;i++){
                h+=this.refreshfields[i];
                if(i!=this.refreshfields.length-1){
                    h+=";";
                }
            }
        }
        h+=`"`+

        
        `>`+
        this.value+
        `</f-input></span>`
        return h;
    }
    
    getNodeConfigInfo(){
        let node = {};
		node.text = this.text;
		node.icon = 'glyphicon glyphicon-pencil';
		node.uuid = this.getProp('id');	
		node.instance = this;
		return node;
    }
}
export default Data;