import Element from './Element';
import {Sequence} from '../../utility';
class Button extends Element{
    constructor(){
        super();
        this.width=170;
        this.height=30;
        this.name="";//唯一标识
        this.text="button";
        this.cursor="default";
        this.scope="button";
        this.id = Sequence.createUuid();
        this.belongId="";
        this.preX=0;
        this.preY=0;
        this.moveX=0;
        this.moveY=0;
        this.value="按钮";//值
        this.isdefaultvalue="false"//是否是默认值
        this.refreshonchanged="false";//刷新
        this.calculateonrefresh="false";//重计算
        this.refreshmode=0;//重刷新的方式
        this.hiddenscript="";//隐藏条件脚本
        this.hiddenvalue="";//隐藏时显示值
        this.hiddenprintscript="";//打印时隐藏条件脚本
        this.printhiddenvalue="";//打印隐藏时显示值
        this.readonlyscript="";//只读条件脚本
        this.refreshfields=[];//局部刷新的字段组合
        this.smallwidth=100;
        this.acttype=""//动作类型
        this.beforeactionscript=""//动作执行前脚本
        this.afteractionscript=""//动作执行后脚本
        this.statetoshow=""//状态标签
        this.filenamescript="";//文件路径脚本
    }
    toHtml(){}
    
    paint(){
        let h="";
        if (this.isblock == "true") {
            h = `<span type="f-input" class="block"`;
          } else {
            h = `<span type="f-input" class="inlineBlock"`;
          }
          h +=` id="${this.id}" draggable="true" style="min-width:${this.width}px;min-height:${this.height}px;margin-bottom:${this.marginbottom}px;margin-top:${this.margintop}px;">`
          
        if(this.isshowlabel=="true" || this.isshowlabel==true){
            h+=`<f-label style="line-height:${this.height}px;">${this.labelvalue}</f-label>`
        }
            h+=`<f-input classname="cn.myapps.runtime.dynaform.form.ejb.ButtonField" value="${this.name}" type="button" nodeid="${this.id}" class="inlineBlock" minwidth="${this.width}" style="`
            
            if(this.isChecked){
                h += `border:1px solid #40a9ff;`;
            }else{
                h += `border:1px solid #ccc;`;
            }
            h+=`min-width:${this.smallwidth}px;min-height:${this.height}px;`;
            
            if(this.zIndex){
                h+=`z-index:`+this.zIndex+`;`;
            }
            h+=`" name="${this.name}" isshowlabel="${this.isshowlabel}" labelvalue="${this.labelvalue}" 
            isdefaultvalue="${this.isdefaultvalue}" refreshonchanged="${this.refreshonchanged}" 
            calculateonrefresh="${this.calculateonrefresh}" 
            hiddenscript="${this.encode(this.hiddenscript)}" hiddenvalue="${this.hiddenvalue}" 
            hiddenprintscript="${this.encode(this.hiddenprintscript)}" 
            printhiddenvalue="${this.printhiddenvalue}" readonlyscript="${this.encode(this.readonlyscript)}" 
            valuescript="${this.valuescript}" acttype="${this.acttype}" 
            beforeactionscript="${this.encode(this.beforeactionscript)}" afteractionscript="${this.encode(this.afteractionscript)}"
            filenamescript="${this.encode(this.filenamescript)}"`;
           

            h+=`refreshfields="`;
            if(this.refreshfields.length>0){
                for(let i=0;i<this.refreshfields.length;i++){
                    h+=this.refreshfields[i];
                    if(i!=this.refreshfields.length-1){
                        h+=";";
                    }
                }
            }
            h+=`"`+

            `>`+
            this.value+
            `</f-input></span>`
        return h;
    }
    
    getNodeConfigInfo(){
        let node = {};
		node.text = this.text;
		node.icon = 'glyphicon glyphicon-cloud';
		node.uuid = this.getProp('id');	
		node.instance = this;
		return node;
    }
    toCheck(){
        if(this.name==""){
            alert("组件名称不能为空")
            return false;
        }
        if(this.acttype==""){
            alert(this.name+"的动作不能为空")
            return false;
        }
        return true;
    }
}
export default Button;