import Element from "./Element";
import { Sequence } from "../../utility";
class Attachment extends Element {
  constructor() {
    super();
    this.width = 170;
    this.height = 30;
    this.name = ""; //唯一标识
    this.text = "attachment";
    this.cursor = "default";
    this.scope = "attachment";
    this.id = Sequence.createUuid();
    this.belongId = "";
    this.preX = 0;
    this.preY = 0;
    this.moveX = 0;
    this.moveY = 0;
    this.value = "文件上传"; //值
    this.readonlyshowvalonly = "true"; //只读时仅只显示值
    this.refreshonchanged = "false"; //刷新
    this.calculateonrefresh = "false"; //冲计算
    this.valuescript = ""; //脚本值
    this.mobile = "true"; //手机可用
    this.discript = ""; //描述
    this.refreshmode = 0; //冲刷新的方式

    this.validatelibs =
      "core.dynaform.form.formfield.validate.checkPhone_system"; //校验方式
    this.validaterule = ""; //校验脚本
    this.hiddenscript = ""; //隐藏条件脚本
    this.hiddenvalue = ""; //隐藏时显示值
    this.hiddenprintscript = ""; //打印时隐藏条件脚本
    this.printhiddenvalue = ""; //打印隐藏时显示值
    this.readonlyscript = ""; //只读条件脚本
    this.refreshfields = []; //局部刷新的字段组合

    this.smallwidth = 100;
    this.instantvalidate = "false"; //即时校验（新增属性）
    this.limitsize = ""; //限制单个上传文件大小
    this.filetype="00";//上传文件类型
    this.customizetype="";//自定义上传类型的内容
    this.limitnumber=10;//最大上传数量
    this.filepattern="00";//存放路径
    this.filecatalog="";//自定义存放路径
    this.previewedit="true";//office 文档预览时可编辑
    this.openwatermark="false";//是否添加水印
    this.supportsorting="false";//文件排序功能仅支持H5皮肤
    this.watermarksupportmode="";//添加水印模式
    this.watermarkscript=""//添加水印脚本
  }
  toHtml() {}

  paint() {
    // if(this.x==0&&this.y==0){
    //     this.x=this.left;
    //     this.y=this.top;
    // }else{
    //     this.left=this.x;
    //     this.top=this.y;
    // }
    //console.log(panel);

    let h = "";
    if (this.isblock == "true") {
      h = `<span type="f-img" class="block"`;
    } else {
      h = `<span type="f-img" class="inlineBlock"`;
    }
    h +=` id="${this.id}" draggable="true" style="min-width:${this.width}px;min-height:${this.height}px;margin-bottom:${this.marginbottom}px;margin-top:${this.margintop}px;">`
    
    if (this.isshowlabel == "true" || this.isshowlabel == true) {
      h += `<f-label style="line-height:${this.height}px;">${this.labelvalue}</f-label>`;
    }
    h += `<f-img type="text" nodeid="${this.id}" class="inlineBlock" minwidth="${this.width}" style="`;
    
    if(this.isChecked){
      h += `border:1px solid #40a9ff;`;
    }else{
      h += `border:1px solid #ccc;`;
    }
    h+=`min-width:${this.smallwidth}px;min-height:${this.height}px;`;
    
    if (this.zIndex) {
      h += `z-index:` + this.zIndex + `;`;
    }
    h += `" name="${this.name}" fieldtype="VALUE_TYPE_TEXT" classname="cn.myapps.runtime.dynaform.form.ejb.AttachmentUploadField" isshowlabel="${this.isshowlabel}" labelvalue="${this.labelvalue}"  
            
            instantvalidate="${this.instantvalidate}"
            readonlyshowvalonly="${this.readonlyshowvalonly}" 
            refreshonchanged="${this.refreshonchanged}" 
            calculateonrefresh="${this.calculateonrefresh}" mobile="${this.mobile}" discript="${this.encode(this.discript)}"
            refreshmode="${this.refreshmode}" validatelibs="${this.validatelibs}" 
            validaterule="${this.validaterule}"
            hiddenscript="${this.encode(this.hiddenscript)}" hiddenvalue="${this.hiddenvalue}" 
            hiddenprintscript="${this.encode(this.hiddenprintscript)}" 
            printhiddenvalue="${this.printhiddenvalue}" readonlyscript="${this.encode(this.readonlyscript)}"
            valuescript="${this.encode(this.valuescript)}"
            limitsize="${this.limitsize}"
            filetype="${this.filetype}"
            limitnumber="${this.limitnumber}"
            customizetype="${this.customizetype}"
            filepattern="${this.filepattern}"
            filecatalog="${this.filecatalog}"
            previewedit="${this.previewedit}"
            openwatermark="${this.openwatermark}"
            supportsorting="${this.supportsorting}"
            watermarksupportmode="${this.watermarksupportmode}"
            watermarkscript="${this.encode(this.watermarkscript)}"
            `;

    h += `refreshfields="`;

    // processdescription="${this.processdescription}"
    if (this.refreshfields.length > 0) {
      for (let i = 0; i < this.refreshfields.length; i++) {
        h += this.refreshfields[i];
        if (i != this.refreshfields.length - 1) {
          h += ";";
        }
      }
    }

    h += `"` + `>` + this.value + `</f-img></span>`;
    return h;
  }

  getNodeConfigInfo() {
    let node = {};
    node.text = this.text;
    node.icon = "glyphicon glyphicon-th-list";
    node.uuid = this.getProp("id");
    node.instance = this;
    return node;
  }
}
export default Attachment;
