class layout{
    constructor(){
        this.key="";
        this.width=300;
        this.height=200;
        this.id="";
        this.x=0;
        this.y=0;
        this.tlx=0;//记录左上角的坐标
        this.tly=0;
        this.blx=0;
        this.bly=0;
        this.left=0;//方便初始化拿到的数据存储
        this.top=0;
        this.xByElement=0;
        this.yByElement=0;
        this._handlePointX=0;
        this._handlePointY=0;
        this.borderWidth=1;
        this.margintop=0;
        this.marginbottom=0;
    }
    setProps(newProps, isCloneProps = false) {
        if(isCloneProps) {
            this.oldProps = this.cloneProps(this);
        }
        
        if((newProps['font'] || newProps['paragraph']) && !newProps['mode']) {
            if(newProps['font']) {
                Object.assign(this.font, newProps['font']);	
            } else if(newProps['paragraph']) {
                Object.assign(this.paragraph, newProps['paragraph']);	
            }
        } else {
            //注意！此方法对一层树结构合并没问题，但若是对象里的属性还是一个对象，则进行合并时，该属性里的对象会被覆盖而非合并操作
            Object.assign(this, newProps);
        }
        
        //在属性合并完成后单独对相对于画布左上角的y(this.y)和打印时输出的y(this.printedY)进行调整
        if(typeof newProps.printedY === 'undefined') {
            this.printedY = this.y - this.prevChunkBaseline;	
        } else  {
            this.y = this.prevChunkBaseline + this.printedY;
        }
    }
    getProp(prop) {
		if(this[prop] !== null && this[prop] !== undefined) {
		  return this[prop];	
		} else if(this.font[prop] !== null && this.font[prop] !== undefined) {
		  return this.font[prop];
		} else if(this.paragraph[prop] !== null && this.paragraph[prop] !== undefined) {
			return this.paragraph[prop];
		}
		
		return (undefined);
    }
    isSelected(x, y) {
		if(x >= this.x && x <= this.x + this.width && y >= this.y && y <= this.y + this.height) {
            return true;
        }
        return false;
	}
    changeElementPosition(position) {
		
		if(typeof position != 'object') {
			return false;
		}
		
		let movedX, movedY = 0;
		let elementPos = {};

		if(position.x && !position.y) {
			movedX = position.x - this._handlePointX;
			elementPos.x = this.x + movedX;
			
			this.setProps({x: elementPos.x, _handlePointX: position.x});
		} else if(position.y && !position.x) {
			movedY = position.y - this._handlePointY;
			elementPos.y = this.y + movedY;
			
			this.setProps({y: elementPos.y, _handlePointY: position.y});
		} else if(position.y && position.x) {
			movedX = position.x - this._handlePointX;
			movedY = position.y - this._handlePointY;
			elementPos.x = this.x + movedX;
			elementPos.y = this.y + movedY;
			
			this.setProps({x: elementPos.x, y: elementPos.y, _handlePointX: position.x, _handlePointY: position.y});
		} else {
			return false;
		}
    }
    getnoUseHeight(){
        if(this.element.length>0){
            let nowBigHeight=0;
            for(let i=0;i<this.element.length;i++){
                let y=this.element[i].y;
                let bigHeight=this.element[i].height;

                if(this.element[i+1]){
                    if(this.element[i].height<this.element[i+1].height && y==this.element[i+1].y){
                        bigHeight=this.element[i+1].height;
                    }
                    if(y!=this.element[i+1].y){
                        nowBigHeight+=bigHeight;
                        bigHeight=0;
                    }
                }
                if(bigHeight!=0 && nowBigHeight==0){
                    nowBigHeight=bigHeight;
                }
               
            }
            return this.height-nowBigHeight;
        }else{
            return this.height;
        }
    }
    toCheck(){
        return true;
    }
    
}
export default layout;