import {Sequence} from '../../utility';
import TdLayout from './TdLayout';
class TrLayout {
    constructor(){
        
        this.type="";
        this.text="panelLayout";
        this.cursor="default";
        this.x=0;
        this.y=0;
        this.width=0;//tr的宽度设置是不生效的，设置这个字段只是为了给td设置值
        this.height=0;
        this.widthPre=0;
        this.heightPre=0;
        // this.tlx=0;//最新的tr下面的边线的x值
        // this.tly=0;
        this.xPre=0;
        this.yPre=0;
        this.tds=[];
        this.cols=0;
        this.iWhich=null;
        this.rowIndex=0;
        this.haveCellSpan=[];//用来记录向下的单元格合并
        this.haveCellRightSpan=[];//用来记录向右的单元格合并
    }
    init(){
        for(let i=0;i<this.cols;i++){
            let td=new TdLayout();
            td.colIndex=i;
            td.rowIndex=this.rowIndex;
            td.width=this.width/this.cols;
            td.height=this.height;
            td.x=this.x+(this.width/this.cols)*i;
            td.y=this.y;
            this.tds.push(td);
        }
    }
    paint(){
        if(!this.id) {
			this.id = Sequence.createUuid();
		}
        //console.log(panel);
        let h=`<tr `+
        
        `height="`+
        this.height+
        `"`+
        `width="`+
        this.width+
        `">`;
        for(let i=0;i<this.tds.length;i++){
            if(!this.tds[i].hide){
                h += this.tds[i].paint();
            }
            
        }
        h += `</tr>`
        return h;
    }
    parseHtml(html){
        let that=this;
        let y = this.y;
        let x = this.x;
        let rowIndex = this.rowIndex;
        let colIndex = 0;
        
        let root=$(html)[0];
        const traversalNode = (htmlNode) => {
            const {tagName}=htmlNode;
            switch(tagName){
                case 'TD':
                    
                    let tdLayout = new TdLayout();
                    // tdLayout.width=parseInt(htmlNode2.getAttribute("width"));
                    // tdLayout.height=parseInt(htmlNode2.getAttribute("height"));
                    // tdLayout.parent=that;
                    tdLayout.width=parseInt(htmlNode.getAttribute("width"));
                    tdLayout.height=parseInt(htmlNode.getAttribute("height"));
                    tdLayout.colspan=parseInt(htmlNode.getAttribute("colspan"));
                    tdLayout.rowspan=parseInt(htmlNode.getAttribute("rowspan"));

                    tdLayout.x=x;
                    x+=tdLayout.width;
                    tdLayout.y=y;
                    tdLayout.rowIndex=rowIndex;
                    tdLayout.colIndex=colIndex;
                    colIndex++;
                    tdLayout.parseHtml(htmlNode);
                    that.tds.push(tdLayout);
                    break;
                default:
                   // console.log("no");
                    break;

            }
        }
        if(root.hasChildNodes()) {
            let style=root.getAttribute("style");
            // let obj={};
            // do{
            //     let i=style.indexOf(":");
            //     let key = style.slice(0,i);
            //     style=style.slice(i+1);

            //     let j=style.indexOf(";");
            //     let val=style.slice(0,j);
            //     style=style.slice(j+1);

            //     obj[key]=parseFloat(val);

            // }while(style.length!=0);
            // this.setProps(obj);
            this.cols=root.children.length;

            for(let j = 0;j < root.children.length;j++) {
                traversalNode(root.children[j]);
            }
        }
    }
    resetTdLayout(moveY){
        this.tds.forEach((elm)=>{
            elm.y = this.y;
            elm.height +=moveY;
        })
    }
    getNodeConfigInfo(){
        let node = {};
		node.text = this.text;
		node.icon = 'glyphicon glyphicon-pencil';
		node.uuid = this.getProp('id');	
		node.instance = this;
		return node;
    }
}
export default TrLayout;