import {Sequence} from '../../utility';
import {Input} from '../component/index';
class TdLayout {
    constructor(){
        
        this.type="";
        this.text="tdLayout";
        this.cursor="default";
        this.childrens=[];
        this.x=0;
        this.y=0;
        this.id=Sequence.createUuid();
        this.parent=null;
        this.width=0;
        this.height=0;
        this.colspan=1;
        this.rowspan=1;
        this.rowIndex=0;
        this.colIndex=0;
        this.hide=false;
    }
    paint(){
        //console.log(panel);
        let h=`<td `+
        `style="`+
        `border:1px solid #ccc`+
        `"`+
        `height="`+
        this.height+
        `"`+
        `width="`+
        this.width+
        `"`+
        `id="`+
        this.id+
        `"`+
        `colspan="`+
        this.colspan+
        `"`+
        `rowspan="`+
        this.rowspan+
        `"`+
        `>`+
        `</td>`
        
        return h;
    }
    getNodeConfigInfo(){
        
        let node = {};
		node.text = this.text;
		node.icon = 'glyphicon glyphicon-cloud';
		node.uuid = this.id;	
        node.instance = this;
        if(this.childrens.length > 0) {
			node.nodes = []
			for(let i = 0, len = this.childrens.length;i < len;i++) {
				const data = this.childrens[i].getNodeConfigInfo();
				node.nodes.push(data);	
			}
		}
		return node;
    }
    parseHtml(html){
        let that=this;
        let root=$(html)[0];
        const traversalNode = (htmlNode) => {
            const {tagName}=htmlNode;
            switch(tagName){
                case 'F-INPUT':
                    let input = new Input();
                    input.belongId=that.id
                    input.parseHtml(htmlNode);
                    that.childrens.push(input);
                    break;
                default:
                   // console.log("no");
                    break;

            }
        }
        if(root.hasChildNodes()) {
            
            for(let i = 0;i < root.children.length;i++) {
                traversalNode(root.children[i]);
            }
        }
    }
    getParent(){
        return this.parent;
    }
}
export default TdLayout;